var QNum = function(template) {
	this.node = document.createElement("form");
	this.nodeInput = document.createElement("input");
	this.nodeButton = document.createElement("button");
	this.result = new ExerciceResult();
	this.init(template);
};

QNum.prototype.parseFloat = function(str) {
	return parseFloat(str.replace(",", "."));
};

QNum.prototype.init = function(template) {
	var self = this;

	this.node.className = "qnum";
	this.node.onsubmit = function() { self.onsubmit(); return false };
	this.node.appendChild(this.nodeInput);

	//champ de saisie
//	this.nodeInput.setAttribute("type", "number");
	this.nodeInput.setAttribute("step", template.hasAttribute("step") ? template.getAttribute("step") : "any");
	if (template.hasAttribute("min")) this.nodeInput.setAttribute("min", template.getAttribute("min"));
	if (template.hasAttribute("max")) this.nodeInput.setAttribute("max", template.getAttribute("max"));

	//affichage de l’unité
	if (template.hasAttribute("unit")) {
		var span = document.createElement("span");
		span.className = "unit";
		span.appendChild(document.createTextNode(template.getAttribute("unit")));
		this.node.appendChild(span);
	}

	//bouton de validation
	this.nodeButton.appendChild(document.createTextNode("Ok"));
	this.node.appendChild(this.nodeButton);

	//
	this.choices = [];
	if (template.hasAttribute("value")) {
		var value = this.parseFloat(template.getAttribute("value"));
		this.choices.push(new QNumChoice(template.getAttribute("messageEqual"), true, value, template.getAttribute("marginOfError")));
		if (template.hasAttribute("messageLessThan")) this.choices.push(new QNumChoice(template.getAttribute("messageLessThan"), false, false, false, value));
		if (template.hasAttribute("messageGreaterThan")) this.choices.push(new QNumChoice(template.getAttribute("messageGreaterThan"), false, false, false, false, value));
		if (template.hasAttribute("messageNotEqual")) this.choices.push(new QNumChoice(template.getAttribute("messageNotEqual")));
	}

	var nodes = document.getChildsByTagName(template, "choice");
	for (var i = 0; i < nodes.length; i++) {
		this.choices.push(new QNumChoice().readTemplate(nodes[i]));
	}

	this.node.appendChild(this.result.node);
};

QNum.prototype.onsubmit = function() {
	var choice = this.getChoice(this.parseFloat(this.nodeInput.value));
	if (choice) {
		this.result.set(choice.result, choice.msg);
	}
	else {
		this.result.set(false, "Mauvaise réponse");
	}
};

QNum.prototype.getChoice = function(value) {
	for (var i = 0; i < this.choices.length; i++) {
		var choice = this.choices[i];
		if (choice.match(value))
			return choice;
	}
	return false;
};

var QNumChoice = function(msg, result, equal, marginOfError, lessThan, greaterThan) {
	this.msg = msg;
	this.result = result;
	this.equal = equal;
	this.marginOfError = marginOfError;
	this.lessThan = lessThan;
	this.greaterThan = greaterThan;
};

QNumChoice.prototype.readTemplate = function(template) {
	this.msg = template.getAttribute("message");
	this.result = template.getAttribute("result") == "true" ? true : false;

	this.equal = template.hasAttribute("equal") ? QNum.prototype.parseFloat(template.getAttribute("equal")) : false;
	this.marginOfError = template.hasAttribute("marginOfError") ? QNum.prototype.parseFloat(template.getAttribute("marginOfError")) : false;
	this.greaterThan = template.hasAttribute("greaterThan") ? QNum.prototype.parseFloat(template.getAttribute("greaterThan")) : false;
	this.lessThan = template.hasAttribute("lessThan") ? QNum.prototype.parseFloat(template.getAttribute("lessThan")) : false;

	return this;
};

QNumChoice.prototype.match = function(value) {
	if (this.equal) {
		var delta = this.marginOfError ? this.equal * this.marginOfError / 100 : 0.00001;
		return (this.equal - delta <= value && value <= this.equal + delta);
	}

	if (this.greaterThan && this.lessThan)
		return (this.greaterThan < value && value < this.lessThan);

	if (this.greaterThan)
		return value > this.greaterThan;

	if (this.lessThan)
		return value < this.lessThan;

	return true;
};
