document.getChildsByTagName = function(parent, name) {
	var result = [];
	for (var i = 0; i < parent.childNodes.length; i++) {
		var child = parent.childNodes[i];
		if (child.nodeName.toLowerCase() == name.toLowerCase()) {
			result.push(child);
		}
	}
	return result;
};

document.getFirstChildByTagName = function(parent, name) {
	var childs = this.getChildsByTagName(parent, name);
	return childs.length > 0 ? childs[0] : false;
};

document.moveChilds = function(from, to) {
	while (from.firstChild) to.appendChild(from.firstChild);
};

document.mapWidget = function(nodes, Widget) {
	while (nodes.length > 0) {
		var node = nodes[0];
		var widget = new Widget(node);
		node.parentNode.replaceChild(widget.node, node);
	}
};

document.moveNodes = function(nodes, to) {
	for (var i = 0; i < nodes.length; i++) {
		to.appendChild(nodes[i]);
	}
};

document.mapWidgetTo = function(nodes, Widget, to) {
	for (var i = 0; i < nodes.length; i++) {
		var node = nodes[i];
		var widget = new Widget(node);
		to.appendChild(widget.node);
	}
};

document.createElementSVG = function(tagName) {
	return document.createElementNS("http://www.w3.org/2000/svg", tagName);
};
