#!/bin/bash

PRG=$0
AppRoot=`dirname "$PRG"`
JavaCmd="/usr/bin/java"
JavaFx="/usr/bin/javafxpackager"

# set JRE arguments
MainClass="rg.espfx.EspFx"
JavaRequiredVersion="1.8+"

ClassPath=\
"lib/bibTEP.jar:"\
"lib/gef2.jar:"\
"lib/im2.jar:"\
"lib/imStruc2.jar:"\
"lib/inth2.jar:"\
"lib/ThoptDemo2.jar:"\
"lib/ThoptEdu2.jar:"\
"lib/Thopt2.jar:"\
"lib/EspFx.jar:"\
"extBib.zip:"\
"extUser2.zip:"\
"extThopt2.zip"

LANG=fr_FR.UTF-8

############################################

function extractJavaVersionString() {
	echo `"$1" -version 2>&1 | awk '/version/{print $NF}' | sed -E 's/"//g'`
}

function extractJavaMajorVersion() {
	version_str=$(extractJavaVersionString "$1")
	echo ${version_str} | sed -E 's/([0-9]\.[0-9]).*/\1/g'
}

function comparableJavaVersionNumber() {
	echo $1 | sed -E 's/[[:punct:]]//g'
}

#
# function: Java version tester
#           check whether a given java version
#           satisfies the given requirement
############################################

function JavaVersionSatisfiesRequirement() {
	java_ver=$1
	java_req=$2

	# e.g. 1.8*
	if [[ ${java_req} =~ ^[0-9]\.[0-9]\*$ ]] ; then
		java_req_num=${java_req:0:3}
		java_ver_num=${java_ver:0:3}
		if [ ${java_ver_num} == ${java_req_num} ] ; then
			return 0
		else
			return 1
		fi

		# e.g. 1.8+
		elif [[ ${java_req} =~ ^[0-9]\.[0-9]\+$ ]] ; then
			java_req_num=$(comparableJavaVersionNumber ${java_req})
			java_ver_num=$(comparableJavaVersionNumber ${java_ver})
			if [ ${java_ver_num} -ge ${java_req_num} ] ; then
				return 0
			else
				return 1
		fi

		# e.g. 1.8
		elif [[ ${java_req} =~ ^[0-9]\.[0-9]$ ]] ; then
			if [ ${java_ver} == ${java_req} ] ; then
				return 0
			else
				return 1
		fi

		# not matching any of the above patterns
		else
			return 2
	fi
}

while [ -h "$PRG" ]; do
	ls=`ls -ld "$PRG"`
	link=`expr "$ls" : '^.*-> \(.*\)$' 2>/dev/null`
	if expr "$link" : '^/' 2> /dev/null >/dev/null; then
		PRG="$link"
	else
		PRG="`dirname "$PRG"`/$link"
	fi
done

# check Java Runtime Environnement installation
if [ -x "$JavaCmd" ] ; then
	echo "commande Java: " $JavaCmd
else
	zenity --info --text="Java ne semble pas installé sur votre système !"
	exit
fi

# check Java Runtime Environnement version
JavaMajorVersion=$(extractJavaMajorVersion $JavaCmd)
echo "Installed java version:" ${JavaMajorVersion}

if JavaVersionSatisfiesRequirement  ${JavaMajorVersion} ${JavaRequiredVersion} ; then
	echo "Required JRE version:" ${JavaRequiredVersion}"..OK"
else
	zenity --info --text="La version de Java ne semble pas convenir ! (version installée : ${JavaMajorVersion} ; requise : ${JavaRequiredVersion})"
	exit
fi

if [ -x "$JavaFx" ] ; then
	echo "JavaFx: " $JavaFx
else
	zenity --info --text="JavaFx ne semble pas installé sur votre système !"
	exit
fi

# run Java
echo "AppRoot: " ${AppRoot}
cd $AppRoot
pwd

set -x
exec ${JavaCmd} -cp "${ClassPath}" ${MainClass} ${Args:+ $Args}

