/*
 * Decompiled with CFR 0.152.
 */
package rg.corps;

import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JOptionPane;
import rg.chart.Q;
import rg.corps.g;
import rg.corps.h;
import rg.corps.j;
import rg.corps.m;
import rg.diag.ac;
import rg.thopt.ProjetDemo;
import rg.util.E;
import rg.util.F;
import rg.util.G;
import rg.util.Inversable;

public abstract class Corps
implements Serializable,
F,
Inversable {
    private static final long serialVersionUID = -3724279377059637262L;
    protected static ResourceBundle resIntTh_fr = ResourceBundle.getBundle(G.d, G.f);
    protected static ResourceBundle resInt_fr = ResourceBundle.getBundle(G.d, G.f);
    public String nom;
    public String Comment = "";
    public double M;
    public double h0 = 0.0;
    public double T0;
    public double u0 = 0.0;
    public double hid0;
    public double M_sec;
    public double PC;
    public double TC;
    public double VC;
    public double omega;
    public double $R = 8.314;
    public double H;
    public double S;
    public double xx;
    public double T;
    public double P;
    public double U;
    public double V;
    public double Cv;
    public double Xh;
    public double Tmini;
    public double Tmaxi;
    public double Pmini;
    public double Pmaxi;
    protected double lambdaV_A;
    protected double lambdaV_B;
    protected double lambdaV_C;
    protected double lambdaV_D;
    protected double muV_A;
    protected double muV_B;
    protected double muV_C;
    protected double muV_D;
    protected double lambdaL_A;
    protected double lambdaL_B;
    protected double lambdaL_C;
    protected double lambdaL_D;
    protected double muL_A;
    protected double muL_B;
    protected double muL_C;
    protected double muL_D;
    protected double muL_E;
    public boolean isMixture = false;
    public String type_corps;
    public int typeCorps;
    public double T0_xh;
    public double[] a_s;
    public double[] b_s;
    public double[] c_s;
    public double smin;
    public double smax;
    public double Zc;
    public double C_Leiner;
    public double K_Leiner;
    public double q00_Leiner;
    public double L00_Leiner;
    public double DhScaleSxDiag = 900.0;
    protected Vector gazModifyListeners = new Vector();
    public Vector vGazComp = new Vector();
    public Object[] component = new Object[3];

    public Corps() {
        this.component[1] = "1";
        this.component[2] = "1";
        this.a_s = new double[7];
        this.b_s = new double[7];
        this.c_s = new double[7];
    }

    public String getClassType() {
        return this.nom;
    }

    public void notifyGazModified() {
    }

    public void typeModified(E e2) {
    }

    public void Calculate() {
    }

    public boolean isCalculable() {
        return true;
    }

    public boolean isValidated() {
        return true;
    }

    public boolean isSuppressed() {
        return false;
    }

    public void updateSubstComp(String[] stringArray, double[] dArray, double[] dArray2) {
    }

    public Vector getGasComp() {
        return new Vector();
    }

    public void updateGasComp(Vector vector) {
    }

    public synchronized void addTypeModifyListener(F f2) {
        if (!this.gazModifyListeners.contains(f2)) {
            this.gazModifyListeners.addElement(f2);
        }
    }

    public synchronized void removeTypeModifyListener(F f2) {
        if (this.gazModifyListeners.contains(f2)) {
            this.gazModifyListeners.removeElement(f2);
        }
    }

    public double as(double d2) {
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < 7) {
            d3 += this.a_s[n2] * Math.pow(d2, n2);
            ++n2;
        }
        return d3;
    }

    public double bs(double d2) {
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < 7) {
            d3 += this.b_s[n2] * Math.pow(d2, n2);
            ++n2;
        }
        return d3;
    }

    public double cs(double d2) {
        double d3 = 0.0;
        int n2 = 0;
        while (n2 < 7) {
            d3 += this.c_s[n2] * Math.pow(d2, n2);
            ++n2;
        }
        return d3;
    }

    public double pHs(double d2, double d3) {
        if (d2 > this.smax) {
            d2 = this.smax;
        }
        if (d2 < this.smin) {
            d2 = this.smin;
        }
        double d4 = this.as(d2) * d3 * d3 + this.bs(d2) * d3 + this.cs(d2);
        return Math.exp(d4);
    }

    public String getNom() {
        return this.nom;
    }

    public String getType() {
        return this.type_corps;
    }

    public double getPCI() {
        return 0.0;
    }

    public double getChemicalExergy() {
        return this.getPCS();
    }

    public double getPCS() {
        return 0.0;
    }

    public void initCorpsExt(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, int n2) {
        this.M = d2;
        this.PC = d3;
        this.TC = d4;
        this.VC = d5;
        this.Tmini = d6;
        this.Tmaxi = d7;
        this.Pmini = d8;
        this.Pmaxi = d9;
        this.typeCorps = n2;
        if (n2 == 6) {
            this.isMixture = true;
        }
    }

    public static Object createSubstance(String string) {
        g g2 = new g();
        return g2.a(string, true);
    }

    public static Object createIdealGas(String object) {
        j j2 = null;
        Corps corps = ac.a.a((String)object);
        if (corps == null) {
            try {
                j2 = new j(resInt_fr.getString("air"), false);
                new j(resInt_fr.getString("air"), false).b = false;
                j2.nom = object;
            }
            catch (m m2) {}
        } else {
            try {
                j2 = (j)corps;
            }
            catch (ClassCastException classCastException) {
                object = String.valueOf(resInt_fr.getString("mess_300")) + (String)object + resInt_fr.getString("mess_300_a");
                JOptionPane.showMessageDialog(G.af, object);
            }
        }
        corps = j2;
        object = ac.a;
        Corps corps2 = ((ProjetDemo)object).a(corps.getNom());
        if (corps2 == null) {
            ((ProjetDemo)object).d.addElement(corps);
        }
        return j2;
    }

    public Vector getGasComposition() {
        return this.getGasComp();
    }

    public void updateGasComposition(Vector vector) {
        this.updateGasComp(vector);
    }

    public void setState(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.P = d2;
        this.T = d3;
        this.xx = d4;
        this.U = d5;
        this.H = d6;
        this.S = d7;
        this.V = d8;
        this.Cv = d9;
        this.Xh = d10;
    }

    public void setNom(String string) {
        this.nom = string;
    }

    public void setComment(String string) {
        this.Comment = string;
    }

    public void setTypeCorps(String string) {
        this.type_corps = string;
    }

    public double getCp(double d2) {
        return d2 + this.$R / this.M * 1000.0;
    }

    public double inv_hT_p(double d2, double d3) {
        return 0.0;
    }

    public double inv_hp_T(double d2, double d3) {
        return 0.0;
    }

    public double inv_sT_p(double d2, double d3) {
        return 0.0;
    }

    public double inv_sT_p(double d2, double d3, double d4, double d5) {
        return 0.0;
    }

    public double inv_Pv_T(double d2, double d3) {
        return 0.0;
    }

    public double inv_sp_T(double d2, double d3) {
        return 0.0;
    }

    public double inv_sv_T(double d2, double d3) {
        return 0.0;
    }

    public double inv_uv_T(double d2, double d3) {
        return 0.0;
    }

    public double inv_vT_p(double d2, double d3) {
        return 0.0;
    }

    public void etat_complet(double d2, double d3, double d4) {
    }

    public double psat_T(double d2, double d3) {
        return 0.0;
    }

    public double Tsat_exact(double d2) {
        return 0.0;
    }

    public double Tsat_p(double d2, double d3) {
        return 0.0;
    }

    public void CalcPropCorps(double d2, double d3, double d4) {
        this.etat_complet(d2, d3, d4);
    }

    public void CalcPropCorps(double d2, double d3, double d4, double d5, String string, double[] dArray) {
        this.etat_complet(d2, d3, d4);
    }

    public double[] getState() {
        double[] dArray = new double[9];
        double[] dArray2 = dArray;
        dArray[0] = this.T;
        dArray2[1] = this.P;
        dArray2[2] = this.xx;
        dArray2[3] = this.V;
        dArray2[4] = this.U;
        dArray2[5] = this.H;
        dArray2[6] = this.S;
        dArray2[7] = this.Cv;
        dArray2[8] = this.Xh;
        return dArray2;
    }

    public double[] getQuality() {
        double[] dArray = new double[1];
        double[] dArray2 = dArray;
        dArray[0] = this.xx;
        return dArray2;
    }

    public double[] getSatComp(double d2, double d3, int n2) {
        double[] dArray = new double[1];
        double[] dArray2 = dArray;
        dArray[0] = n2;
        return dArray2;
    }

    public double[] getMolarWeights() {
        double[] dArray = new double[1];
        double[] dArray2 = dArray;
        dArray[0] = this.xx;
        return dArray2;
    }

    public Vector getSubstProperties() {
        Vector<Number> vector = new Vector<Number>();
        vector.addElement(this.T);
        vector.addElement(this.P);
        vector.addElement(this.xx);
        vector.addElement(this.V);
        vector.addElement(this.U);
        vector.addElement(this.H);
        vector.addElement(this.S);
        vector.addElement(this.M);
        vector.addElement(this.typeCorps);
        vector.addElement(this.M_sec);
        vector.addElement(this.TC);
        vector.addElement(this.PC);
        vector.addElement(this.VC);
        vector.addElement(new Double(this.getChemicalExergy()));
        return vector;
    }

    public double getP_from_hT(double d2, double d3) {
        return this.inv_hT_p(d2, d3);
    }

    public double getT_from_hP(double d2, double d3) {
        return this.inv_hp_T(d2, d3);
    }

    public double getT_from_hP(double d2, double d3, double d4, String string, double[] dArray) {
        return this.inv_hp_T(d2, d3);
    }

    public double getP_from_sT(double d2, double d3) {
        return this.inv_sT_p(d2, d3);
    }

    public double getP_from_sT(double d2, double d3, double d4, double d5) {
        return this.inv_sT_p(d2, d3, d4, d5);
    }

    public double getT_from_sP(double d2, double d3) {
        return this.inv_sp_T(d2, d3);
    }

    public double getT_from_sP(double d2, double d3, double d4, String string, double[] dArray) {
        return this.inv_sp_T(d2, d3);
    }

    public double getT_from_sv(double d2, double d3) {
        return this.inv_sv_T(d2, d3);
    }

    public double getT_from_uv(double d2, double d3) {
        return this.inv_uv_T(d2, d3);
    }

    public double getP_from_vT(double d2, double d3) {
        return this.inv_vT_p(d2, d3);
    }

    public double getSatPressure(double d2, double d3) {
        return this.psat_T(d2, d3);
    }

    public double getSatPressure(double d2, double d3, double d4, String string, double[] dArray) {
        return this.psat_T(d2, d3);
    }

    public double getSatTemperature(double d2, double d3) {
        if (this instanceof h) {
            return this.Tsat_exact(d2);
        }
        return this.Tsat_p(d2, d3);
    }

    public double getSatTemperature(double d2, double d3, double d4, String string, double[] dArray) {
        return this.Tsat_p(d2, d3);
    }

    public double V_sat(double d2) {
        return 0.0;
    }

    public double V_sat_liq(double d2) {
        return 0.0;
    }

    public double v_cond_mass(double d2, double d3, double d4) {
        return 0.0;
    }

    public double muL(double d2, double d3) {
        return Math.exp(this.muL_A + this.muL_B / d2 + this.muL_C * Math.log(d2) + this.muL_D * Math.pow(d2, this.muL_E));
    }

    public double muV(double d2, double d3) {
        return this.muV_A * Math.pow(d2, this.muV_B) / (1.0 + this.muV_C / d2 + this.muV_D / d2 / d2);
    }

    public double lambdaL(double d2, double d3) {
        return this.lambdaL_A + this.lambdaL_B * d2 + this.lambdaL_C * d2 * d2 + this.lambdaL_D * d2 * d2 * d2;
    }

    public double lambdaV(double d2, double d3) {
        return this.lambdaV_A * Math.pow(d2, this.lambdaV_B) / (1.0 + this.lambdaV_C / d2 + this.lambdaV_D / d2 / d2);
    }

    public double getLiquidViscosity(double d2, double d3) {
        double d4 = Math.exp(this.muL_A + this.muL_B / d2 + this.muL_C * Math.log(d2) + this.muL_D * Math.pow(d2, this.muL_E));
        return d4;
    }

    public double getLiquidViscosity(double d2) {
        double d3 = Math.exp(this.muL_A + this.muL_B / d2 + this.muL_C * Math.log(d2) + this.muL_D * Math.pow(d2, this.muL_E));
        return d3;
    }

    public double getLiquidViscosity(double d2, double d3, double d4, String string, double[] dArray) {
        return 0.0;
    }

    public double getVaporViscosity(double d2, double d3) {
        return this.muV_A * Math.pow(d2, this.muV_B) / (1.0 + this.muV_C / d2 + this.muV_D / d2 / d2);
    }

    public double getVaporViscosity(double d2) {
        return this.muV_A * Math.pow(d2, this.muV_B) / (1.0 + this.muV_C / d2 + this.muV_D / d2 / d2);
    }

    public double getVaporViscosity(double d2, double d3, double d4, String string, double[] dArray) {
        return 0.0;
    }

    public double getLiquidConductivity(double d2, double d3) {
        double d4 = this.lambdaL_A + this.lambdaL_B * d2 + this.lambdaL_C * d2 * d2 + this.lambdaL_D * d2 * d2 * d2;
        return d4;
    }

    public double getLiquidConductivity(double d2) {
        double d3 = this.lambdaL_A + this.lambdaL_B * d2 + this.lambdaL_C * d2 * d2 + this.lambdaL_D * d2 * d2 * d2;
        return d3;
    }

    public double getLiquidConductivity(double d2, double d3, double d4, String string, double[] dArray) {
        return 0.0;
    }

    public double getVaporConductivity(double d2, double d3) {
        double d4 = this.lambdaV_A * Math.pow(d2, this.lambdaV_B) / (1.0 + this.lambdaV_C / d2 + this.lambdaV_D / d2 / d2);
        return d4;
    }

    public double getVaporConductivity(double d2) {
        double d3 = this.lambdaV_A * Math.pow(d2, this.lambdaV_B) / (1.0 + this.lambdaV_C / d2 + this.lambdaV_D / d2 / d2);
        return d3;
    }

    public double getVaporConductivity(double d2, double d3, double d4, String string, double[] dArray) {
        return 0.0;
    }

    public double[] getTransportProperties(double d2, double d3) {
        double[] dArray = new double[]{0.0, 0.0};
        if (this.xx == 0.0) {
            dArray[0] = this.getLiquidViscosity(d2, d3);
            dArray[1] = this.getLiquidConductivity(d2, d3);
        } else {
            dArray[0] = this.getVaporViscosity(d2, d3);
            dArray[1] = this.getVaporConductivity(d2, d3);
        }
        return dArray;
    }

    public double[] getTransportProperties(double d2, double d3, double d4, String string, double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        if (this.xx == 0.0) {
            dArray2[0] = this.getLiquidViscosity(d2, d3, d4, string, dArray);
            dArray2[1] = this.getLiquidConductivity(d2, d3, d4, string, dArray);
        } else {
            dArray2[0] = this.getVaporViscosity(d2, d3, d4, string, dArray);
            dArray2[1] = this.getVaporConductivity(d2, d3, d4, string, dArray);
        }
        return dArray2;
    }

    public void setSubstanceParameters(double[] dArray) {
    }

    public double[] getCriticalParameters() {
        double[] dArray = new double[4];
        double[] dArray2 = dArray;
        dArray[0] = this.TC;
        dArray2[1] = this.PC;
        dArray2[2] = this.VC;
        dArray2[3] = this.M;
        return dArray2;
    }

    public double[] getCriticalParameters(double d2, String string, double[] dArray) {
        double[] dArray2 = new double[4];
        double[] dArray3 = dArray2;
        dArray2[0] = this.TC;
        dArray3[1] = this.PC;
        dArray3[2] = this.VC;
        dArray3[3] = this.M;
        return dArray3;
    }

    public double[] getPTx_from_sh(double d2, double d3) {
        if (this.typeCorps == 3 || this.typeCorps == 4) {
            double d4;
            double[] dArray = new double[3];
            this.T = this.getT_from_hP(d3, 1.0);
            dArray[0] = d4 = this.getP_from_sT(d2, this.T);
            dArray[1] = this.T;
            dArray[2] = 1.0;
            return dArray;
        }
        Q q2 = new Q();
        return q2.a(d2, d3, this);
    }

    public boolean isMolarFraction() {
        return true;
    }

    public abstract double f_dicho(double var1, double var3, String var5);
}

