/*
 * Decompiled with CFR 0.152.
 */
package bibTEP;

import bibTEP.Alphas;
import bibTEP.CpGeneralisee;
import bibTEP.Ede;
import bibTEP.EnthalpieEntropie;
import bibTEP.Modeles;
import bibTEP.MonoPhaseException;
import bibTEP.OutputPv;
import bibTEP.ResultatCardan;
import bibTEP.SolutionR;
import bibTEP.TEPbibSubstance;

public class PureTEPbibSubstance
extends TEPbibSubstance {
    public PureTEPbibSubstance() {
    }

    public PureTEPbibSubstance(String systName, String systFile) {
        super(systName, systFile);
    }

    public double getSatPressure(double T, double x) throws MonoPhaseException {
        double[] paramC = new double[3];
        double Psat = this.getFugacityEquality("Psat", T, 0);
        return Psat;
    }

    public double getSatTemperature(double P, double x) throws MonoPhaseException {
        return this.getFugacityEquality("Tsat", P, 0);
    }

    double getFugacityEquality(String callFunction, double param, int i) {
        double PP;
        double TT;
        double[] init = new double[2];
        this.callFunction = callFunction;
        if (callFunction.equals("Psat")) {
            TT = this.Tparam = param;
            if (this.compProp[i].codePsat == 1) {
                init[1] = PP = this.compProp[i].psat_T(this.Tparam);
            } else {
                double INT = 5.92714 - 6.09648 / this.Tr - 1.28862 * Math.log(this.Tr) + 0.169347 * Math.pow(this.Tr, 6.0) + this.compProp[i].omega * (15.2518 - 15.6875 / this.Tr - 13.4721 * Math.log(this.Tr) + 0.43577 * Math.pow(this.Tr, 6.0));
                init[1] = PP = Math.exp(INT) * this.compProp[i].Pc;
            }
        }
        if (callFunction.equals("Tsat")) {
            PP = this.Pparam = param;
            init[1] = TT = this.compProp[i].Tsat_P(this.Pparam);
        }
        double[] result = this.solveWithMinPack(1, callFunction, init, 1.0E-6);
        return result[1];
    }

    public double[] getT_from_hP(double h, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Hparam = h;
        this.Pparam = P;
        double Tsat = 300.0;
        try {
            Tsat = this.getSatTemperature(P, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Tsat: " + Tsat + "  Tc: " + this.mixTc);
        }
        double hl = 0.0;
        double hv = 0.0;
        if (Tsat < this.mixTc) {
            double[] res2 = this.calcSubstance(Tsat, P, 0.0);
            hl = res2[0];
            res2 = this.calcSubstance(Tsat, P, 1.0);
            hv = res2[0];
            if (this.debug) {
                System.out.println("hl: " + hl + "  hv: " + hv);
            }
            if (h >= hl && h <= hv) {
                double xx = (h - hl) / (hv - hl);
                res[0] = Tsat;
                res[1] = xx;
                if (this.debug) {
                    System.out.println("h: " + h + "  xx: " + xx);
                }
                return res;
            }
            init[1] = (this.mixTc + this.Tmini) / 2.0;
        } else {
            init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        }
        this.callFunction = "invhP";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    public double[] getT_from_sP(double s, double P) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Sparam = s;
        this.Pparam = P;
        double Tsat = 300.0;
        try {
            Tsat = this.getSatTemperature(P, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Tsat: " + Tsat + "  Tc: " + this.mixTc);
        }
        double sl = 0.0;
        double sv = 0.0;
        if (Tsat < this.mixTc) {
            double[] res2 = this.calcSubstance(Tsat, P, 0.0);
            sl = res2[5];
            res2 = this.calcSubstance(Tsat, P, 1.0);
            sv = res2[5];
            if (this.debug) {
                System.out.println("sl: " + sl + "  sv: " + sv);
            }
            if (s >= sl && s <= sv) {
                res[0] = Tsat;
                res[1] = (s - sl) / (sv - sl);
                return res;
            }
            init[1] = (this.mixTc + this.Tmini) / 2.0;
        } else {
            init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        }
        this.callFunction = "invsP";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1];
        res[1] = 1.0;
        return res;
    }

    public double[] getP_from_sT(double s, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Sparam = s;
        this.Tparam = T;
        double Psat = 100000.0;
        try {
            Psat = this.getSatPressure(T, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Psat: " + Psat + "Pc: " + this.mixPc);
        }
        double sl = 0.0;
        double sv = 0.0;
        if (Psat < this.mixPc) {
            double[] res2 = this.calcSubstance(T, Psat, 0.0);
            sl = res2[5];
            res2 = this.calcSubstance(T, Psat, 1.0);
            sv = res2[5];
            if (this.debug) {
                System.out.println("sl: " + sl + "  sv: " + sv);
            }
            if (s >= sl && s <= sv) {
                res[0] = Psat / 100000.0;
                res[1] = (s - sl) / (sv - sl);
                return res;
            }
            init[1] = this.mixPc / 2.0;
        } else {
            init[1] = (this.mixPc + this.Pmaxi) / 2.0;
        }
        this.callFunction = "invsT";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    public double[] getP_from_hT(double h, double T) {
        double[] res = new double[2 * this.nbComponents + 1];
        double[] init = new double[2];
        this.Hparam = h;
        this.Tparam = T;
        double Psat = 100000.0;
        try {
            Psat = this.getSatPressure(T, 0.0);
        }
        catch (MonoPhaseException e) {
            e.printStackTrace();
        }
        if (this.debug) {
            System.out.println("Psat: " + Psat + "Pc: " + this.mixPc);
        }
        double hl = 0.0;
        double hv = 0.0;
        if (Psat < this.mixPc) {
            double[] res2 = this.calcSubstance(T, Psat, 0.0);
            hl = res2[0];
            res2 = this.calcSubstance(T, Psat, 1.0);
            hv = res2[0];
            if (this.debug) {
                System.out.println("hl: " + hl + "  hv: " + hv);
            }
            if (h >= hl && h <= hv) {
                double xx = (h - hl) / (hv - hl);
                res[0] = Psat;
                res[1] = xx;
                return res;
            }
            init[1] = this.mixPc / 2.0;
        } else {
            init[1] = (this.mixPc + this.Pmaxi) / 2.0;
        }
        this.callFunction = "invhT";
        double[] result = this.solveWithMinPack(1, this.callFunction, init, 1.0E-6);
        res[0] = result[1] / 100000.0;
        res[1] = 1.0;
        return res;
    }

    public double[] getTPx_from_hs(double h, double s) {
        double[] res = new double[3 * this.nbComponents + 1];
        double[] init = new double[3];
        this.Hparam = h;
        this.Sparam = s;
        init[1] = (this.mixTc + this.Tmaxi) / 2.0;
        init[2] = this.mixPc / 2.0;
        this.callFunction = "invhs";
        double[] result = this.solveWithMinPack(2, this.callFunction, init, 1.0E-6);
        res[0] = result[2];
        res[1] = result[1];
        res[2] = 1.0;
        return res;
    }

    public void fcn(int mm, int n, double[] x, double[] fvec, int[] iflag) {
        super.fcn(mm, n, x, fvec, iflag);
        double PP = 1.0;
        double TT = 300.0;
        if (iflag[1] == 1) {
            ++this.nfev;
        }
        if (iflag[1] == 2) {
            ++this.njev;
        }
        if (this.callFunction.equals("Tsat")) {
            TT = x[1];
            PP = this.Pparam;
            fvec[1] = this.getFugacityResidual(PP, TT, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("Psat")) {
            PP = x[1];
            TT = this.Tparam;
            fvec[1] = this.getFugacityResidual(PP, TT, x);
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhP")) {
            TT = x[1];
            PP = this.Pparam;
            fvec[1] = this.getEnthalpyResidual(this.Hparam, PP, x);
            this.callFunction = "invhP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsP")) {
            TT = x[1];
            PP = this.Pparam;
            fvec[1] = this.getEntropyResidual(this.Sparam, PP, x);
            this.callFunction = "invsP";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invsT")) {
            PP = x[1];
            TT = this.Tparam;
            fvec[1] = this.getEntropyResidual2(this.Sparam, x, TT);
            this.callFunction = "invsT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhT")) {
            PP = x[1];
            TT = this.Tparam;
            fvec[1] = this.getEnthalpyResidual2(this.Hparam, x, TT);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
        }
        if (this.callFunction.equals("invhs")) {
            TT = x[1];
            PP = x[2];
            fvec[1] = this.getEnthalpyResidual3(this.Hparam, x);
            fvec[2] = this.getEntropyResidual3(this.Sparam, x);
            this.callFunction = "invhT";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            if (this.debug) {
                System.out.println("fvec[2]: " + fvec[2] + "  x[2]: " + x[2]);
            }
        }
        if (this.callFunction.equals("adjustmentMC")) {
            fvec[1] = this.objFunction(x[1], x[2], x[3], 0);
            fvec[2] = 0.0;
            fvec[3] = 0.0;
            this.callFunction = "adjustmentMC";
            if (this.debug) {
                System.out.println("fvec[1]: " + fvec[1] + "  x[1]: " + x[1]);
            }
            if (this.debug) {
                System.out.println("x[2]: " + x[2] + "  x[3]: " + x[3]);
            }
        }
    }

    protected double getEnthalpyResidual(double h, double PP, double[] x) {
        double[] res = this.calcSubstance(x[1], PP, 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEnthalpyResidual2(double h, double[] x, double TT) {
        double[] res = this.calcSubstance(TT, x[1], 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEnthalpyResidual3(double h, double[] x) {
        double[] res = this.calcSubstance(x[1], x[2], 1.0);
        double critere = h - res[0];
        return critere;
    }

    protected double getEntropyResidual(double s, double PP, double[] x) {
        double[] res = this.calcSubstance(x[1], PP, 1.0);
        double critere = s - res[5];
        return critere;
    }

    protected double getEntropyResidual2(double s, double[] x, double TT) {
        double[] res = this.calcSubstance(TT, x[1], 1.0);
        double critere = s - res[5];
        return critere;
    }

    protected double getEntropyResidual3(double s, double[] x) {
        double[] res = this.calcSubstance(x[1], x[2], 1.0);
        double critere = s - res[5];
        return critere;
    }

    protected double getFugacityResidual(double PP, double TT, double[] x) {
        this.mod = this.modeleUtilise(this.nbmodele, this.mixomega, this.mixTc, this.mixPc, this.mixZc);
        this.solR = this.r1r2(this.mod.u, this.mod.w);
        this.mixb = this.mod.omegab * 8.314472471 * this.mixTc / this.mixPc;
        this.Tr = TT / this.mixTc;
        this.Trref = this.mixTref / this.mixTc;
        this.mixac = this.mod.omegaa * Math.pow(8.314472471, 2.0) * Math.pow(this.mixTc, 2.0) / this.mixPc;
        this.fonctionalphas = this.alphaUtilise(this.nbalpha, this.mixomega, this.Tr, this.mixc1, this.mixc2, this.mixc3);
        this.mixalpha = this.fonctionalphas.alpha;
        this.m = this.fonctionalphas.m;
        this.mixa = this.mixac * this.mixalpha;
        Ede modele = this.equationdEtat(PP, TT, this.mod.u, this.mod.w, this.mixa, this.mixb);
        ResultatCardan Z = this.cubique(modele.A, modele.B, modele.C, modele.D);
        double fugaciteL = this.calculFugacite(PP, TT, this.solR.r1, this.solR.r2, this.mixa, this.mixb, Z.ZL);
        double fugaciteV = this.calculFugacite(PP, TT, this.solR.r1, this.solR.r2, this.mixa, this.mixb, Z.ZV);
        double critere = fugaciteL / fugaciteV - 1.0;
        if (this.debug) {
            System.out.println("temperature " + TT + " pression " + PP + "  critere " + critere);
        }
        this.satValue = x[1];
        return critere;
    }

    public double[] calcSubstance(double T, double P, double x) {
        double[] res = new double[6];
        this.mod = this.modeleUtilise(this.nbmodele, this.mixomega, this.mixTc, this.mixPc, this.mixZc);
        this.solR = this.r1r2(this.mod.u, this.mod.w);
        this.mixb = this.mod.omegab * 8.314472471 * this.mixTc / this.mixPc;
        this.Tr = T / this.mixTc;
        this.Trref = this.mixTref / this.mixTc;
        this.mixac = this.mod.omegaa * Math.pow(8.314472471, 2.0) * Math.pow(this.mixTc, 2.0) / this.mixPc;
        this.fonctionalphas = this.alphaUtilise(this.nbalpha, this.mixomega, this.Tr, this.mixc1, this.mixc2, this.mixc3);
        this.mixalpha = this.fonctionalphas.alpha;
        this.mixa = this.mixac * this.mixalpha;
        this.mixdadt = this.mixac * this.fonctionalphas.dalpha;
        this.equationdEtat = this.equationdEtat(P, T, this.mod.u, this.mod.w, this.mixa, this.mixb);
        this.Z = this.cubique(this.equationdEtat.A, this.equationdEtat.B, this.equationdEtat.C, this.equationdEtat.D);
        double vV = this.Z.ZV * 8.314472471 * T / P;
        double vL = this.Z.ZL * 8.314472471 * T / P;
        double Psat = 1.0;
        if (T <= this.mixTc) {
            try {
                Psat = this.getSatPressure(T, 0.0);
            }
            catch (MonoPhaseException e) {
                e.printStackTrace();
            }
            if (P > Psat * 1.001) {
                this.v = vL;
                x = 0.0;
            } else if (P < Psat * 0.999) {
                this.v = vV;
                x = 1.0;
            } else {
                this.v = vL + x * (vV - vL);
            }
        } else {
            this.v = vL;
            x = 1.0;
        }
        this.Rho = 1.0 / this.v;
        this.hSIdeal = new EnthalpieEntropie();
        if (this.compProp[0].codeCp == 1) {
            this.hSIdeal.h = this.compProp[0].h_gaz_mol(T);
            this.hSIdeal.s = this.compProp[0].s_gaz_mol(T, P);
        } else {
            this.hSIdeal = this.methodeTrapezes(1000, this.compProp[0].Tref, T, P);
        }
        this.hSRes = new EnthalpieEntropie();
        if (T <= this.mixTc && Psat * 0.999 < P && P < Psat * 1.001) {
            double hl = P * vL - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((vL - this.mixb * this.solR.r1) / (vL - this.mixb * this.solR.r2));
            double hv = P * vV - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((vV - this.mixb * this.solR.r1) / (vV - this.mixb * this.solR.r2));
            this.hSRes.h = hl + x * (hv - hl);
            double sl = 8.314472471 * Math.log((vL - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((vL - this.mixb * this.solR.r1) / (vL - this.mixb * this.solR.r2)) + 8.314472471 * Math.log(this.mixPref);
            double sv = 8.314472471 * Math.log((vV - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((vV - this.mixb * this.solR.r1) / (vV - this.mixb * this.solR.r2)) + 8.314472471 * Math.log(this.mixPref);
            this.hSRes.s = sl + x * (sv - sl);
        } else {
            this.hSRes.h = P * this.v - 8.314472471 * T + (this.mixa - this.mixdadt * T) / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((this.v - this.mixb * this.solR.r1) / (this.v - this.mixb * this.solR.r2));
            this.hSRes.s = 8.314472471 * Math.log((this.v - this.mixb) * P / (8.314472471 * T)) - this.mixdadt / (this.mixb * (this.solR.r1 - this.solR.r2)) * Math.log((this.v - this.mixb * this.solR.r1) / (this.v - this.mixb * this.solR.r2)) + 8.314472471 * Math.log(this.mixPref);
        }
        this.hS = new EnthalpieEntropie();
        this.hS.h = this.hSIdeal.h + this.hSRes.h + this.mixh0;
        this.hS.s = this.hSIdeal.s + this.hSRes.s + this.mixs0;
        if (this.debug) {
            System.out.print(String.valueOf(T) + "\t");
            System.out.print(String.valueOf(P) + "\t");
            System.out.print(String.valueOf(this.v) + "\t");
            System.out.print(String.valueOf(this.Rho) + "\t");
            System.out.print(String.valueOf(x) + "\t");
            System.out.print(String.valueOf(this.hS.h) + "\t");
            System.out.print(String.valueOf(this.hS.s) + "\t");
            System.out.println("h0 " + this.mixh0 + " s0 " + this.mixs0);
            System.out.println(" ");
        }
        res[0] = this.hS.h / this.mixM;
        res[1] = 1000.0 / this.Rho / this.mixM;
        res[2] = 0.0;
        res[3] = x;
        res[4] = res[0] - (P * res[1] - this.mixu0) / 100.0;
        res[5] = this.hS.s / this.mixM;
        return res;
    }

    public ResultatCardan cubique(double a, double b, double c, double d) {
        ResultatCardan resultat = new ResultatCardan();
        double p = c / a - Math.pow(b, 2.0) / (3.0 * Math.pow(a, 2.0));
        double q = 2.0 * Math.pow(b, 3.0) / (27.0 * Math.pow(a, 3.0)) - b * c / (3.0 * Math.pow(a, 2.0)) + d / a;
        double gDelta = 4.0 * Math.pow(p, 3.0) + 27.0 * Math.pow(q, 2.0);
        double m = -q / 2.0 + 0.5 * Math.sqrt(gDelta / 27.0);
        double n = -q / 2.0 - 0.5 * Math.sqrt(gDelta / 27.0);
        double u = Math.pow(Math.abs(m), 0.3333333333333333);
        double v = Math.pow(Math.abs(n), 0.3333333333333333);
        if (gDelta > 0.0) {
            if (m < 0.0) {
                u = -u;
            }
            if (n < 0.0) {
                v = -v;
            }
            double x = u + v;
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = x;
            return resultat;
        }
        if (gDelta == 0.0) {
            if (b == 0.0 & c == 0.0 && d == 0.0) {
                resultat.ZL = 0.0;
                resultat.ZI = 0.0;
                resultat.ZV = 0.0;
                return resultat;
            }
            double x = 3.0 * q / p;
            double y = -3.0 * q / (2.0 * p);
            resultat.ZL = x += -b / (3.0 * a);
            resultat.ZI = 0.0;
            resultat.ZV = y += -b / (3.0 * a);
            return resultat;
        }
        double k = 3.0 * q / (2.0 * p * Math.sqrt(-p / 3.0));
        double theta = Math.acos(k);
        double x = 2.0 * Math.sqrt(-p / 3.0) * Math.cos(theta / 3.0);
        double y = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 2) / 3.0);
        double z = 2.0 * Math.sqrt(-p / 3.0) * Math.cos((theta + Math.PI * 4) / 3.0);
        resultat.ZV = x += -b / (3.0 * a);
        resultat.ZI = z += -b / (3.0 * a);
        resultat.ZL = y += -b / (3.0 * a);
        return resultat;
    }

    public Ede equationdEtat(double P, double T, double u, double w, double a, double b) {
        Ede equation = new Ede();
        equation.A = P * Math.pow(8.314472471 * T / P, 3.0);
        equation.B = (P * b * u - b * P - 8.314472471 * T) * Math.pow(8.314472471 * T / P, 2.0);
        equation.C = (b * b * w * P - P * (b * b * u) - 8.314472471 * T * b * u + a) * (8.314472471 * T) / P;
        equation.D = -b * b * b * P * w - 8.314472471 * T * b * b * w - a * b;
        return equation;
    }

    public double calculFugacite(double P, double T, double r1, double r2, double a, double b, double Z) {
        double v = Z * 8.314472471 * T / P;
        double lnphi = Z - 1.0 - Math.log(P * (v - b) / (8.314472471 * T)) + a / (b * 8.314472471 * T * (r1 - r2)) * Math.log((v - b * r1) / (v - b * r2));
        double phi = Math.exp(lnphi);
        return phi;
    }

    public SolutionR r1r2(double u, double w) {
        SolutionR solR = new SolutionR();
        solR.r1 = (-u + Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        solR.r2 = (-u - Math.pow(u * u - 4.0 * w, 0.5)) / 2.0;
        return solR;
    }

    public Modeles modeleUtilise(int n, double omega, double Tc, double Pc, double Zc) {
        Modeles mod = new Modeles();
        switch (n) {
            case 0: {
                mod.u = 0.0;
                mod.w = 0.0;
                mod.omegaa = 0.421875;
                mod.omegab = 0.125;
                break;
            }
            case 1: {
                mod.u = 1.0;
                mod.w = 0.0;
                mod.omegaa = 0.42748;
                mod.omegab = 0.08664;
                break;
            }
            case 2: {
                mod.u = 2.0;
                mod.w = -1.0;
                double truc = 0.3333333333333333 * (-1.0 + Math.pow(6.0 * Math.sqrt(2.0) + 8.0, 0.3333333333333333) - Math.pow(6.0 * Math.sqrt(2.0) - 8.0, 0.3333333333333333));
                mod.omegaa = 8.0 * (5.0 * truc + 1.0) / (49.0 - 37.0 * truc);
                mod.omegab = truc / (truc + 3.0);
                break;
            }
            case 3: {
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = this.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = 1.0 - 3.0 * Zc;
                double b2 = mod.omegab * 8.314472471 * Tc / Pc;
                double c2 = mod.omegac * 8.314472471 * Tc / Pc;
                mod.u = 1.0 + c2 / b2;
                mod.w = -c2 / b2;
                break;
            }
            case 4: {
                double c2;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zc + 1.0;
                double c1 = 3.0 * Zc * Zc;
                double d1 = -Math.pow(Zc, 3.0);
                ResultatCardan omegaB = this.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zc * (1.0 - Zc) + 3.0 * (1.0 - 2.0 * Zc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.omegac = (1.0 - 3.0 * Zc + mod.omegab) / mod.omegab;
                double b2 = mod.omegab * 8.314472471 * Tc / Pc;
                mod.u = c2 = mod.omegac * 8.314472471 * Tc / Pc;
                mod.w = -c2 + 1.0;
                break;
            }
            case 5: {
                double Zcc = 0.3333333333333333;
                double a1 = 1.0;
                double b1 = 1.0 - 3.0 * Zcc + 1.0;
                double c1 = 3.0 * Zcc * Zcc;
                double d1 = -Math.pow(Zcc, 3.0);
                ResultatCardan omegaB = this.cubique(a1, b1, c1, d1);
                mod.omegab = omegaB.ZV;
                mod.omegaa = 1.0 - 3.0 * Zcc * (1.0 - Zcc) + 3.0 * (1.0 - 2.0 * Zcc) * mod.omegab + Math.pow(mod.omegab, 2.0);
                mod.u = 1.0;
                mod.w = 0.0;
            }
        }
        return mod;
    }

    public Alphas alphaUtilise(int n, double omega, double Tr, double c1, double c2, double c3) {
        Alphas fonctionalpha = new Alphas();
        if (this.debug) {
            System.out.println("FUNCTION ALPHA MC C1: " + this.mixc1 + "\t" + "MC C2: " + this.mixc2 + "\t" + "MC C3: " + this.mixc3);
        }
        switch (n) {
            case 0: {
                fonctionalpha.m = 0.48 + 1.574 * omega - 0.175 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 1: {
                fonctionalpha.m = 0.4783 + 1.6337 * omega - 0.317 * Math.pow(omega, 2.0) + 0.76 * Math.pow(omega, 3.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 2: {
                fonctionalpha.m = 0.37464 + 1.54226 * omega - 0.26992 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 3: {
                if (omega < 0.4) {
                    fonctionalpha.m = 0.418 + 1.58 * omega - 0.58 * Math.pow(omega, 2.0);
                    fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                    fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                    break;
                }
                fonctionalpha.m = 0.212 + 2.2 * omega - 0.831 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 4: {
                if (Tr <= 1.0) {
                    double L0 = 0.125283;
                    double M0 = 0.911807;
                    double N0 = 1.948153;
                    double L1 = 0.511614;
                    double M1 = 0.784054;
                    double N1 = 2.812522;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.401219;
                double M0 = 4.963075;
                double N0 = -2.0;
                double L1 = 0.024955;
                double M1 = 1.248088;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 5: {
                if (Tr <= 1.0) {
                    double L0 = 0.141599;
                    double M0 = 0.919422;
                    double N0 = 2.496441;
                    double L1 = 0.500315;
                    double M1 = 0.799457;
                    double N1 = 3.29179;
                    double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                    double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                    fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                    break;
                }
                double L0 = 0.441411;
                double M0 = 6.500018;
                double N0 = -2.0;
                double L1 = 0.03258;
                double M1 = 1.289098;
                double N1 = -8.0;
                double alpha1 = Math.pow(Tr, N1 * (M1 - 1.0)) * Math.exp(L1 * (1.0 - Math.pow(Tr, N1 * M1)));
                double alpha0 = Math.pow(Tr, N0 * (M0 - 1.0)) * Math.exp(L0 * (1.0 - Math.pow(Tr, N0 * M0)));
                fonctionalpha.alpha = alpha0 + omega * (alpha1 - alpha0);
                break;
            }
            case 6: {
                double c0 = 0.378893 + 1.4897153 * omega - 0.17131848 * omega * omega + 0.0196554 * Math.pow(omega, 3.0);
                fonctionalpha.m = c0 + c1 * (1.0 + Math.pow(Tr, 0.5) * (0.7 - Tr));
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 7: {
                if (Tr <= 1.0) {
                    fonctionalpha.alpha = Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)) + c2 * Math.pow(1.0 - Math.pow(Tr, 0.5), 2.0) + c3 * Math.pow(1.0 - Math.pow(Tr, 0.5), 3.0), 2.0);
                    fonctionalpha.dalpha = 2.0 * (1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)) + c2 * Math.pow(1.0 - Math.pow(Tr, 0.5), 2.0) + c3 * Math.pow(1.0 - Math.pow(Tr, 0.5), 3.0)) * (-0.5 / Math.pow(this.mixTc, 0.5) * Math.pow(Tr * this.mixTc, -0.5) * c1 + 2.0 * c2 * (1.0 - Math.pow(Tr, 0.5)) * (-0.5 / Math.pow(this.mixTc, 0.5) * Math.pow(Tr * this.mixTc, -0.5)) + 3.0 * c3 * Math.pow(1.0 - Math.pow(Tr, 0.5), 2.0) * (-0.5 / Math.pow(this.mixTc, 0.5) * Math.pow(Tr * this.mixTc, -0.5)));
                    break;
                }
                fonctionalpha.alpha = Math.pow(1.0 + c1 * (1.0 - Math.pow(Tr, 0.5)), 2.0);
                fonctionalpha.dalpha = (1.0 + c1 * (1.0 - Math.pow(Tr, 0.5))) * (-c1 / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
                break;
            }
            case 8: {
                fonctionalpha.m = 0.452413 + 1.30982 * omega - 0.296937 * Math.pow(omega, 2.0);
                fonctionalpha.alpha = Math.pow(1.0 + fonctionalpha.m * (1.0 - Math.sqrt(Tr)), 2.0);
                fonctionalpha.dalpha = (1.0 + this.m * (1.0 - Math.pow(Tr, 0.5))) * (-this.m / Math.pow(this.mixTc, 0.5) / Math.pow(Tr * this.mixTc, 0.5));
            }
        }
        return fonctionalpha;
    }

    public static CpGeneralisee fonctionCp(int n, double T) {
        CpGeneralisee Cp = new CpGeneralisee();
        switch (n) {
            case 0: {
                Cp.Cp = 83.15 - 1863.0 / Math.pow(T, 0.5) + 17445.0 / T;
                Cp.CpT = (83.15 - 1863.0 / Math.pow(T, 0.5) + 17445.0 / T) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 1: {
                Cp.Cp = 18.036 - 4.474 * Math.pow(10.0, -5.0) * T + 158.08 / Math.pow(T, 0.5);
                Cp.CpT = (18.036 - 4.474 * Math.pow(10.0, -5.0) * T + 158.08 / Math.pow(T, 0.5)) / T;
                Cp.h0 = 22301.0;
                Cp.s0 = 120.7;
                break;
            }
            case 2: {
                Cp.Cp = 4.0 + 5.5728 / (T * T) * Math.exp(-222.0 / T) + 10.385 / (T * T) * Math.exp(-1010.0 / T) + 12.554 / (T * T) * Math.exp(-2450.0 / T);
                Cp.CpT = (4.0 + 5.5728 / (T * T) * Math.exp(-222.0 / T) + 10.385 / (T * T) * Math.exp(-1010.0 / T) + 12.554 / (T * T) * Math.exp(-2450.0 / T)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 3: {
                Cp.Cp = -39.09957 + 0.7222719 * T - 6.516371E-4 * T * T;
                Cp.CpT = (-39.09957 + 0.7222719 * T - 6.516371E-4 * T * T) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 4: {
                Cp.Cp = (41600.0 + 301400.0 * Math.pow(1461.7 / T / Math.sinh(1461.7 / T), 2.0) + 180950.0 * Math.pow(-668.8 / T / Math.cosh(-668.8 / T), 2.0)) / 1000.0;
                Cp.CpT = (41600.0 + 301400.0 * (1461.7 / T / Math.sinh(1461.7 / T)) + 180950.0 * (-668.8 / T / Math.cosh(-668.8 / T))) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 5: {
                Cp.Cp = (71340.0 + 243000.0 * Math.pow(1630.0 / T / Math.sinh(1630.0 / T), 2.0) + 150330.0 * Math.pow(730.42 / T / Math.cosh(730.42 / T), 2.0)) / 1000.0;
                Cp.CpT = (71340.0 + 243000.0 * Math.pow(1630.0 / T / Math.sinh(1630.0 / T), 2.0) + 150330.0 * Math.pow(730.42 / T / Math.cosh(730.42 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 6: {
                Cp.Cp = (34090.0 + 72460.0 * Math.pow(1723.0 / T / Math.sinh(1723.0 / T), 2.0) + 44800.0 * Math.pow(780.5 / T / Math.cosh(780.5 / T), 2.0)) / 1000.0;
                Cp.CpT = (34090.0 + 72460.0 * Math.pow(1723.0 / T / Math.sinh(1723.0 / T), 2.0) + 44800.0 * Math.pow(780.5 / T / Math.cosh(780.5 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 7: {
                Cp.Cp = (33261.0 + 24919.0 * Math.pow(1112.2 / T / Math.sinh(1112.2 / T), 2.0) + 9253.4 * Math.pow(559.2 / T / Math.cosh(559.2 / T), 2.0)) / 1000.0;
                Cp.CpT = (33261.0 + 24919.0 * Math.pow(1112.2 / T / Math.sinh(1112.2 / T), 2.0) + 9253.4 * Math.pow(559.2 / T / Math.cosh(559.2 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 8: {
                Cp.Cp = (44373.0 + 131190.0 * Math.pow(1642.2 / T / Math.sinh(1642.2 / T), 2.0) + 85441.0 * Math.pow(738.77 / T / Math.cosh(738.77 / T), 2.0)) / 1000.0;
                Cp.CpT = (44373.0 + 131190.0 * Math.pow(1642.2 / T / Math.sinh(1642.2 / T), 2.0) + 85441.0 * Math.pow(738.77 / T / Math.cosh(738.77 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 9: {
                Cp.Cp = (45769.0 + 203850.0 * Math.pow(665.82 / T / Math.sinh(665.82 / T), 2.0) + 134740.0 * Math.pow(277.6 / T / Math.cosh(277.6 / T), 2.0)) / 1000.0;
                Cp.CpT = (45769.0 + 203850.0 * Math.pow(665.82 / T / Math.sinh(665.82 / T), 2.0) + 134740.0 * Math.pow(277.6 / T / Math.cosh(277.6 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 10: {
                Cp.Cp = (122300.0 + 198400.0 * Math.pow(797.82 / T / Math.sinh(797.82 / T), 2.0) + 94756.0 * Math.pow(408.2 / T / Math.cosh(408.2 / T), 2.0)) / 1000.0;
                Cp.CpT = (122300.0 + 198400.0 * Math.pow(797.82 / T / Math.sinh(797.82 / T), 2.0) + 94756.0 * Math.pow(408.2 / T / Math.cosh(408.2 / T), 2.0)) / T / 1000.0;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 11: {
                Cp.Cp = 8.314472 * (4.0 + 17.47 * (569.0 / T) * (569.0 / T) * Math.exp(569.0 / T) / Math.pow(Math.exp(569.0 / T) - 1.0, 2.0) + 16.29 * (2232.0 / T) * (2232.0 / T) * Math.exp(2232.0 / T) / Math.pow(Math.exp(2232.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (4.0 + 17.47 * (569.0 / T) * (569.0 / T) * Math.exp(569.0 / T) / Math.pow(Math.exp(569.0 / T) - 1.0, 2.0) + 16.29 * (2232.0 / T) * (2232.0 / T) * Math.exp(2232.0 / T) / Math.pow(Math.exp(2232.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 12: {
                Cp.Cp = (58140.0 + 286300.0 * Math.pow(1440.6 / T / Math.sinh(1440.6 / T), 2.0) + 189800.0 * Math.pow(-650.43 / T / Math.cosh(-650.43 / T), 2.0)) / 1000.0;
                Cp.CpT = (58140.0 + 286300.0 * Math.pow(1440.6 / T / Math.sinh(1440.6 / T), 2.0) + 189800.0 * Math.pow(-650.43 / T / Math.cosh(-650.43 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 13: {
                Cp.Cp = 5.3 + 0.03973 * T - 1.859E-5 * (T * T);
                Cp.CpT = (5.3 + 0.03973 * T - 1.859E-5 * (T * T)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 14: {
                Cp.Cp = (33427.0 + 48980.0 * Math.pow(2036.0 / T / Math.sinh(2036.0 / T), 2.0) + 22560.0 * Math.pow(882.0 / T / Math.cosh(882.0 / T), 2.0)) / 1000.0;
                Cp.CpT = (33427.0 + 48980.0 * Math.pow(2036.0 / T / Math.sinh(2036.0 / T), 2.0) + 22560.0 * Math.pow(882.0 / T / Math.cosh(882.0 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 15: {
                Cp.Cp = (51480.0 + 144200.0 * Math.pow(1603.4 / T / Math.sinh(1603.4 / T), 2.0) + 77470.0 * Math.pow(725.4 / T / Math.cosh(725.4 / T), 2.0)) / 1000.0;
                Cp.CpT = (51480.0 + 144200.0 * Math.pow(1603.4 / T / Math.sinh(1603.4 / T), 2.0) + 77470.0 * Math.pow(725.4 / T / Math.cosh(725.4 / T), 2.0)) / 1000.0 / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 16: {
                Cp.Cp = 8.314472 * (4.0 + 11.43 * (403.0 / T) * (403.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(403.0 / T) - 1.0, 2.0) + 12.83 * (1428.0 / T) * (1428.0 / T) * Math.exp(1428.0 / T) / Math.pow(Math.exp(1428.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (4.0 + 11.43 * (403.0 / T) * (403.0 / T) * Math.exp(403.0 / T) / Math.pow(Math.exp(403.0 / T) - 1.0, 2.0) + 12.83 * (1428.0 / T) * (1428.0 / T) * Math.exp(1428.0 / T) / Math.pow(Math.exp(1428.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
                break;
            }
            case 17: {
                Cp.Cp = 8.314472 * (5.944 + 7.549 * (718.0 / T) * (718.0 / T) * Math.exp(718.0 / T) / Math.pow(Math.exp(718.0 / T) - 1.0, 2.0) + 1.537 * (877.0 / T) * (877.0 / T) * Math.exp(877.0 / T) / Math.pow(Math.exp(877.0 / T) - 1.0, 2.0) + 2.03 * (4465.0 / T) * (4465.0 / T) * Math.exp(4465.0 / T) / Math.pow(Math.exp(4465.0 / T) - 1.0, 2.0) + 7.455 * (1755.0 / T) * (1755.0 / T) * Math.exp(1755.0 / T) / Math.pow(Math.exp(1755.0 / T) - 1.0, 2.0));
                Cp.CpT = 8.314472 * (5.944 + 7.549 * (718.0 / T) * (718.0 / T) * Math.exp(718.0 / T) / Math.pow(Math.exp(718.0 / T) - 1.0, 2.0) + 1.537 * (877.0 / T) * (877.0 / T) * Math.exp(877.0 / T) / Math.pow(Math.exp(877.0 / T) - 1.0, 2.0) + 2.03 * (4465.0 / T) * (4465.0 / T) * Math.exp(4465.0 / T) / Math.pow(Math.exp(4465.0 / T) - 1.0, 2.0) + 7.455 * (1755.0 / T) * (1755.0 / T) * Math.exp(1755.0 / T) / Math.pow(Math.exp(1755.0 / T) - 1.0, 2.0)) / T;
                Cp.h0 = 0.0;
                Cp.s0 = 0.0;
            }
        }
        return Cp;
    }

    public EnthalpieEntropie methodeTrapezes(int nbtrapezes, double x1, double x2, double P) {
        CpGeneralisee f1 = new CpGeneralisee();
        CpGeneralisee f2 = new CpGeneralisee();
        EnthalpieEntropie hs = new EnthalpieEntropie();
        double pas = (x2 - x1) / (double)nbtrapezes;
        double aireh = 0.0;
        double aires = 0.0;
        int cas = this.numeroCas(this.compProp[0].name);
        if (this.compProp[0].codeCp == 2) {
            int i = 0;
            while (i < nbtrapezes) {
                double borneinf = x1 + (double)i * pas;
                double bornesup = borneinf + pas;
                f1.Cp = (this.compProp[0].A + this.compProp[0].B * Math.pow(this.compProp[0].C / borneinf / Math.sinh(this.compProp[0].C / borneinf), 2.0) + this.compProp[0].D * Math.pow(this.compProp[0].E / borneinf / Math.cosh(this.compProp[0].E / borneinf), 2.0)) / 1000.0;
                f2.Cp = (this.compProp[0].A + this.compProp[0].B * Math.pow(this.compProp[0].C / bornesup / Math.sinh(this.compProp[0].C / bornesup), 2.0) + this.compProp[0].D * Math.pow(this.compProp[0].E / bornesup / Math.cosh(this.compProp[0].E / bornesup), 2.0)) / 1000.0;
                f1.CpT = f1.Cp / borneinf;
                f2.CpT = f2.Cp / bornesup;
                aireh += pas * (f1.Cp + f2.Cp) / 2.0;
                aires += pas * (f1.CpT + f2.CpT) / 2.0;
                ++i;
            }
            hs.h = aireh;
            hs.s = aires - 8.314472471 * Math.log(P);
        } else {
            int i = 0;
            while (i < nbtrapezes) {
                double borneinf = x1 + (double)i * pas;
                double bornesup = borneinf + pas;
                f1 = PureTEPbibSubstance.fonctionCp(cas, borneinf);
                f2 = PureTEPbibSubstance.fonctionCp(cas, bornesup);
                aireh += pas * (f1.Cp + f2.Cp) / 2.0;
                aires += pas * (f1.CpT + f2.CpT) / 2.0;
                ++i;
            }
            hs.h = aireh;
            hs.s = aires - 8.314472471 * Math.log(P);
        }
        return hs;
    }

    public double[] calcC() {
        double[] res = new double[3];
        double[] init = new double[4];
        this.callFunction = "adjustmentMC";
        init[1] = 1.0;
        init[2] = -1.0;
        init[3] = 1.0;
        double[] resultat = this.solveWithMinPack(3, this.callFunction, init, 1.0E-6);
        res[0] = resultat[1];
        res[1] = resultat[2];
        res[2] = resultat[3];
        return res;
    }

    public OutputPv Tfixe(double P, double T, double u, double w, double r1, double r2, double epsilon, double a, double b) {
        OutputPv CondEqui = new OutputPv();
        int compteur = 0;
        double PSave = 0.0;
        double vLSave = 0.0;
        double vVSave = 0.0;
        double vISave = 0.0;
        double critereSave = 1.0;
        double critere = 1.0;
        while (critere > epsilon && compteur < 1000) {
            Ede modele = this.equationdEtat(P, T, u, w, a, b);
            ResultatCardan Z = this.cubique(modele.A, modele.B, modele.C, modele.D);
            double vV = Z.ZV * 8.314472471 * T / P;
            double vL = Z.ZL * 8.314472471 * T / P;
            double vI = Z.ZI * 8.314472471 * T / P;
            double fugaciteL = this.calculFugacite(P, T, r1, r2, a, b, Z.ZL);
            double fugaciteV = this.calculFugacite(P, T, r1, r2, a, b, Z.ZV);
            critere = Math.abs(fugaciteL / fugaciteV - 1.0);
            PSave = P;
            vLSave = vL;
            vVSave = vV;
            vISave = vI;
            critereSave = critere;
            P *= fugaciteL / fugaciteV;
            ++compteur;
        }
        CondEqui.P = PSave;
        CondEqui.vL = vLSave;
        CondEqui.vV = vVSave;
        CondEqui.critere = critereSave;
        CondEqui.vI = vISave;
        return CondEqui;
    }

    public double objFunction(double c1, double c2, double c3, int numComp) {
        OutputPv condEqui = new OutputPv();
        int i = numComp;
        this.mod = this.modeleUtilise(this.nbmodele, this.compProp[i].omega, this.compProp[i].Tc, this.compProp[i].Pc, this.compProp[i].Zc);
        this.solR = this.r1r2(this.mod.u, this.mod.w);
        double epsilon = 1.0E-6;
        this.mixb = this.mod.omegab * 8.314472471 * this.compProp[i].Tc / this.compProp[i].Pc;
        double sum = 0.0;
        int j = 0;
        while (j < this.compProp[i].nbexp) {
            this.Tr = this.compProp[i].Texp[j] / this.compProp[i].Tc;
            this.mixac = this.mod.omegaa * Math.pow(8.314472471, 2.0) * Math.pow(this.compProp[i].Tc, 2.0) / this.compProp[i].Pc;
            this.fonctionalphas = this.alphaUtilise(this.nbalpha, this.compProp[i].omega, this.Tr, c1, c2, c3);
            this.mixalpha = this.fonctionalphas.alpha;
            this.mixa = this.mixac * this.mixalpha;
            double INT = 5.92714 - 6.09648 / this.Tr - 1.28862 * Math.log(this.Tr) + 0.169347 * Math.pow(this.Tr, 6.0) + this.compProp[i].omega * (15.2518 - 15.6875 / this.Tr - 13.4721 * Math.log(this.Tr) + 0.43577 * Math.pow(this.Tr, 6.0));
            double P = Math.exp(INT) * this.compProp[i].Pc;
            condEqui = this.Tfixe(P, this.compProp[i].Texp[j], this.mod.u, this.mod.w, this.solR.r1, this.solR.r2, epsilon, this.mixa, this.mixb);
            double diff_Psat = this.compProp[i].Pexp[j] == 0.0 ? 0.0 : condEqui.P - this.compProp[i].Pexp[j];
            double diff_vL = this.compProp[i].VsatL_exp[j] == 0.0 ? 0.0 : condEqui.vL - this.compProp[i].VsatL_exp[j];
            double diff_Hvap = this.compProp[i].Hvap_exp[j] == 0.0 ? 0.0 : condEqui.P * condEqui.vV - condEqui.P * condEqui.vL - this.compProp[i].VsatL_exp[j];
            sum = sum + Math.pow(diff_Psat, 2.0) + Math.pow(diff_vL, 2.0) + Math.pow(diff_Hvap, 2.0);
            ++j;
        }
        double res = Math.pow(sum, 0.5) / (double)(this.compProp[0].nbexp - 3);
        return res;
    }

    public int numeroCas(String xxx) {
        int cas = 2;
        if (xxx.equalsIgnoreCase("R245fa")) {
            cas = 2;
        }
        if (xxx.equalsIgnoreCase("cyclopentane")) {
            cas = 4;
        }
        if (xxx.equalsIgnoreCase("R600")) {
            cas = 5;
        }
        if (xxx.equalsIgnoreCase("R40")) {
            cas = 6;
        }
        if (xxx.equalsIgnoreCase("NO2")) {
            cas = 7;
        }
        if (xxx.equalsIgnoreCase("R161")) {
            cas = 8;
        }
        if (xxx.equalsIgnoreCase("R1216")) {
            cas = 9;
        }
        if (xxx.equalsIgnoreCase("R610")) {
            cas = 10;
        }
        if (xxx.equalsIgnoreCase("R365mfc")) {
            cas = 11;
        }
        if (xxx.equalsIgnoreCase("toluene")) {
            cas = 12;
        }
        if (xxx.equalsIgnoreCase("R236ea")) {
            cas = 13;
        }
        if (xxx.equalsIgnoreCase("NH3")) {
            cas = 14;
        }
        if (xxx.equalsIgnoreCase("Dimethylether")) {
            cas = 15;
        }
        if (xxx.equalsIgnoreCase("R227ea")) {
            cas = 16;
        }
        if (xxx.equalsIgnoreCase("R1234yf")) {
            cas = 17;
        }
        return cas;
    }
}

