/*
 * Decompiled with CFR 0.152.
 */
package rg.espfx;

import java.util.Vector;
import javax.swing.SwingUtilities;
import rg.thopt.Projet;

public class Thermoptim {
    private Projet projet;

    public Thermoptim() {
        SwingUtilities.invokeLater(new RunnableStart());
    }

    public void loadProject(String string) {
        SwingUtilities.invokeLater(new RunnableLoadProject(string));
    }

    public void displayComponent(String string, String string2) {
        SwingUtilities.invokeLater(new RunnableDisplayComponent(string, string2));
    }

    public void openDiag(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("openDiag", string));
    }

    public void loadCycle(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("readCycle", string));
    }

    public void selectCorps(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("selectSubstance", string));
    }

    public void closeChart() {
        SwingUtilities.invokeLater(new RunnableSetupChart("closeDiag", "1"));
    }

    public void unselectCycle(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("unSelectCycle", string));
    }

    public void removeCycle(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("removeCycle", string));
    }

    public void setChartType(String string) {
        SwingUtilities.invokeLater(new RunnableSetupChart("setChartType", string));
    }

    public void stop() {
        SwingUtilities.invokeLater(new RunnableStop());
    }

    class RunnableStop
    implements Runnable {
        RunnableStop() {
        }

        @Override
        public void run() {
            System.out.println("stop Thermoptim");
            Thermoptim.this.projet.closeEditor();
            Thermoptim.this.projet.setVisible(false);
            Thermoptim.this.projet.dispose();
            System.exit(0);
        }
    }

    class RunnableSetupChart
    implements Runnable {
        String cmd;
        String arg;

        RunnableSetupChart(String string, String string2) {
            this.cmd = string;
            this.arg = string2;
        }

        @Override
        public void run() {
            System.out.println("setupChart(\"" + this.cmd + "\", \"" + this.arg + "\")");
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.cmd);
            vector.addElement(this.arg);
            Thermoptim.this.projet.setupChart(vector);
        }
    }

    class RunnableDisplayComponent
    implements Runnable {
        String type;
        String name;

        RunnableDisplayComponent(String string, String string2) {
            this.type = string;
            this.name = string2;
        }

        @Override
        public void run() {
            System.out.println("displayComponent(\"" + this.type + "\", \"" + this.name + "\")");
            Vector<String> vector = new Vector<String>();
            vector.addElement(this.type);
            vector.addElement(this.name);
            Thermoptim.this.projet.displayComponent(vector);
        }
    }

    class RunnableLoadProject
    implements Runnable {
        String name;

        RunnableLoadProject(String string) {
            this.name = string;
        }

        @Override
        public void run() {
            System.out.println("loadProject(\"" + this.name + "\")");
            String[] stringArray = new String[]{this.name + ".prj", this.name + ".dia", ".", "noTest"};
            Thermoptim.this.projet.loadSelection(stringArray);
        }
    }

    class RunnableStart
    implements Runnable {
        RunnableStart() {
        }

        @Override
        public void run() {
            System.out.println("start Thermoptim");
            Thermoptim.this.projet = new Projet();
            Thermoptim.this.projet.setVisible(true);
            Thermoptim.this.projet.openEditor();
        }
    }
}

