/*
 * Decompiled with CFR 0.152.
 */
package rg.espfx;

import java.io.File;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import netscape.javascript.JSObject;
import rg.espfx.App;
import rg.espfx.Log;

public class EspFx
extends Application {
    public static final String STAGE_TITLE = "Documentation Thermoptim";
    public static final int STAGE_WIDTH = 1024;
    public static final int STAGE_HEIGHT = 768;
    public static final String APPLICATION_NAME = "EspFx";
    public static final String APPLICATION_VERSION = "0.1";
    private final KeyCombination keyCombinationCtrlO = new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
    private static final App app = new App();
    public static String homeUri = "";
    public static final String homeDefaultUri = "explorations/ctc/accueil.html";

    public File selectFile(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Choisissez un fichier d\u2019exploration");
        return fileChooser.showOpenDialog((Window)stage);
    }

    public String selectFileUri(Stage stage) {
        File file = this.selectFile(stage);
        return file != null ? file.toURI().toString() : "";
    }

    public void start(final Stage stage) {
        WebView webView = new WebView();
        final WebEngine webEngine = webView.getEngine();
        webEngine.setUserAgent(APPLICATION_NAME);
        BorderPane borderPane = new BorderPane();
        borderPane.setCenter((Node)webView);
        Scene scene = new Scene((Parent)borderPane);
        scene.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                String string;
                if (EspFx.this.keyCombinationCtrlO.match(keyEvent) && !(string = EspFx.this.selectFileUri(stage)).isEmpty()) {
                    webEngine.load(string);
                }
                switch (keyEvent.getCode()) {
                    case BACK_SPACE: {
                        webEngine.executeScript("history.back()");
                        break;
                    }
                    case ESCAPE: {
                        webEngine.load(homeUri);
                        break;
                    }
                    case F5: {
                        webEngine.reload();
                    }
                }
            }
        });
        webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue observableValue, Worker.State state, Worker.State state2) {
                System.out.println(webEngine.getLocation());
                if (state2 == Worker.State.SCHEDULED) {
                    if (webEngine.getLocation().endsWith(".pdf")) {
                        app.open(webEngine.getLocation());
                    }
                } else if (state2 == Worker.State.SUCCEEDED) {
                    stage.setTitle(webEngine.getTitle());
                    JSObject jSObject = (JSObject)webEngine.executeScript("window");
                    jSObject.setMember("app", app);
                    webEngine.executeScript("if ('onready' in window) window.onready();");
                }
            }
        });
        if (homeUri.isEmpty()) {
            homeUri = this.selectFileUri(stage);
        }
        if (homeUri.isEmpty()) {
            webEngine.loadContent("Appuyer sur Ctrl + O pour ouvrir un fichier d\u2019exploration\u2026", "text/html");
        } else {
            webEngine.load(homeUri);
        }
        stage.setScene(scene);
        stage.setWidth(1024.0);
        stage.setHeight(768.0);
        stage.setTitle("Documentation Thermoptim: " + homeUri);
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent windowEvent) {
                app.exit();
            }
        });
        stage.show();
    }

    public static void main(String[] stringArray) {
        new Log("output.txt").setOut(false);
        new Log("error.txt").setErr(false);
        String string = stringArray.length > 0 ? stringArray[0] : homeDefaultUri;
        homeUri = string.substring(0, 7).equals("http://") || string.substring(0, 6).equals("file:/") ? string : new File(string).toURI().toString();
        System.out.println("homeUri: " + homeUri);
        EspFx.launch((String[])stringArray);
    }
}

