/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.xml.pgml;

import com.ibm.xml.parser.ElementHandler;
import com.ibm.xml.parser.Parser;
import com.ibm.xml.parser.TXElement;
import com.ibm.xml.parser.TagHandler;
import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigCircle;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;
import org.tigris.gef.presentation.FigText;
import org.tigris.gef.xml.DTDEntityResolver;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class PGMLParser
implements ElementHandler,
TagHandler {
    public static PGMLParser SINGLETON = new PGMLParser();
    protected Diagram _diagram = null;
    protected int _nestedGroups = 0;
    protected Hashtable _figRegistry = null;
    protected Hashtable _ownerRegistry = new Hashtable();

    public synchronized Diagram readDiagram(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            String string = uRL.getFile();
            System.out.println("=======================================");
            System.out.println("== READING DIAGRAM: " + uRL);
            Parser parser = new Parser(string);
            parser.addElementHandler((ElementHandler)this);
            parser.setTagHandler((TagHandler)this);
            parser.getEntityHandler().setEntityResolver((EntityResolver)DTDEntityResolver.SINGLETON);
            this.initDiagram("org.tigris.gef.base.Diagram");
            this._figRegistry = new Hashtable();
            parser.readStream(inputStream);
            inputStream.close();
            return this._diagram;
        }
        catch (Exception exception) {
            System.out.println("Exception in readDiagram");
            exception.printStackTrace();
            return null;
        }
    }

    public void setOwnerRegistry(Hashtable hashtable) {
        this._ownerRegistry = hashtable;
    }

    protected void initDiagram(String string) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf("|");
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        try {
            System.out.println("PGMLParser.initDiagram: clsName = " + string2);
            System.out.println("PGMLParser.initDiagram: initStr = " + string3);
            Class<?> clazz = Class.forName(string2);
            this._diagram = (Diagram)clazz.newInstance();
            if (string3 != null && !string3.equals("")) {
                this._diagram.initialize(this.findOwner(string3));
            }
        }
        catch (Exception exception) {
            System.out.println("could not set diagram type to " + string2);
            exception.printStackTrace();
        }
    }

    public void handleStartTag(TXElement tXElement, boolean bl) {
        String string = tXElement.getName();
        if ("group".equals(string)) {
            ++this._nestedGroups;
        } else if (string.equals("pgml")) {
            this.handlePGML(tXElement);
        }
    }

    public void handleEndTag(TXElement tXElement, boolean bl) {
        String string = tXElement.getName();
        if ("group".equals(string)) {
            --this._nestedGroups;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TXElement handleElement(TXElement tXElement) {
        try {
            String string = tXElement.getName();
            if (string.equals("pgml")) return tXElement;
            if (string.equals("group")) {
                this._diagram.add(this.handleGroup(tXElement));
                return tXElement;
            }
            if (this._nestedGroups == 0) {
                if (string.equals("path")) {
                    this._diagram.add(this.handlePolyLine(tXElement));
                    return tXElement;
                } else if (string.equals("ellipse")) {
                    this._diagram.add(this.handleEllipse(tXElement));
                    return tXElement;
                } else if (string.equals("rectangle")) {
                    this._diagram.add(this.handleRect(tXElement));
                    return tXElement;
                } else if (string.equals("text")) {
                    this._diagram.add(this.handleText(tXElement));
                    return tXElement;
                } else {
                    if (string.equals("piewedge") || string.equals("circle") || string.equals("moveto") || string.equals("lineto") || string.equals("curveto") || string.equals("arc") || string.equals("closepath")) return tXElement;
                    System.out.println("unknown top-level tag: " + string);
                }
                return tXElement;
            }
            if (this._nestedGroups <= 0) return tXElement;
        }
        catch (Exception exception) {
            System.out.println("Exception in PGMLParser handleElement");
            exception.printStackTrace();
        }
        return tXElement;
    }

    protected void handlePGML(TXElement tXElement) {
        String string = tXElement.getAttribute("name");
        String string2 = tXElement.getAttribute("description");
        try {
            if (string2 != null && !string2.equals("")) {
                this.initDiagram(string2);
            }
            if (string != null && !string.equals("")) {
                this._diagram.setName(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in handlePGML");
        }
    }

    protected Fig handlePolyLine(TXElement tXElement) {
        String string = tXElement.getAttribute("description");
        if (string != null && string.indexOf("FigLine") != -1) {
            return this.handleLine(tXElement);
        }
        return this.handlePath(tXElement);
    }

    protected FigLine handleLine(TXElement tXElement) {
        FigLine figLine = new FigLine(0, 0, 100, 100);
        this.setAttrs(figLine, tXElement);
        TXElement tXElement2 = tXElement.getElementNamed("moveto");
        TXElement tXElement3 = tXElement.getElementNamed("lineto");
        if (tXElement2 != null && tXElement3 != null) {
            String string = tXElement2.getAttribute("x");
            String string2 = tXElement2.getAttribute("y");
            String string3 = tXElement3.getAttribute("x");
            String string4 = tXElement3.getAttribute("y");
            int n = string == null || string.equals("") ? 0 : Integer.parseInt(string);
            int n2 = string2 == null || string2.equals("") ? 0 : Integer.parseInt(string2);
            int n3 = string3 == null || string3.equals("") ? n : Integer.parseInt(string3);
            int n4 = string4 == null || string4.equals("") ? n2 : Integer.parseInt(string4);
            figLine.setX1(n);
            figLine.setY1(n2);
            figLine.setX2(n3);
            figLine.setY2(n4);
        }
        return figLine;
    }

    protected FigCircle handleEllipse(TXElement tXElement) {
        FigCircle figCircle = new FigCircle(0, 0, 50, 50);
        this.setAttrs(figCircle, tXElement);
        String string = tXElement.getAttribute("rx");
        String string2 = tXElement.getAttribute("ry");
        int n = string == null || string.equals("") ? 10 : Integer.parseInt(string);
        int n2 = string2 == null || string2.equals("") ? 10 : Integer.parseInt(string2);
        figCircle.setX(figCircle.getX() - n);
        figCircle.setY(figCircle.getY() - n2);
        figCircle.setWidth(n * 2);
        figCircle.setHeight(n2 * 2);
        return figCircle;
    }

    protected FigRect handleRect(TXElement tXElement) {
        FigRect figRect;
        String string = tXElement.getAttribute("rounding");
        if (string == null || string.equals("")) {
            figRect = new FigRect(0, 0, 80, 80);
        } else {
            figRect = new FigRRect(0, 0, 80, 80);
            int n = Integer.parseInt(string);
            ((FigRRect)figRect).setCornerRadius(n);
        }
        this.setAttrs(figRect, tXElement);
        return figRect;
    }

    protected FigText handleText(TXElement tXElement) {
        String string;
        FigText figText = new FigText(100, 100, 90, 45);
        this.setAttrs(figText, tXElement);
        String string2 = tXElement.getText();
        figText.setText(string2);
        String string3 = tXElement.getAttribute("font");
        if (string3 != null && !string3.equals("")) {
            figText.setFontFamily(string3);
        }
        if ((string = tXElement.getAttribute("textsize")) != null && !string.equals("")) {
            int n = Integer.parseInt(string);
            figText.setFontSize(n);
        }
        return figText;
    }

    protected FigPoly handlePath(TXElement tXElement) {
        FigPoly figPoly = new FigPoly();
        this.setAttrs(figPoly, tXElement);
        if (tXElement.hasChildNodes()) {
            NodeList nodeList = tXElement.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeList.item(n2);
                int n3 = 0;
                int n4 = 0;
                if (node instanceof TXElement) {
                    String string;
                    String string2 = ((TXElement)node).getAttribute("x");
                    if (string2 != null && !string2.equals("")) {
                        n3 = Integer.parseInt(string2);
                    }
                    if ((string = ((TXElement)node).getAttribute("y")) != null && !string.equals("")) {
                        n4 = Integer.parseInt(string);
                    }
                    figPoly.addPoint(n3, n4);
                }
                ++n2;
            }
        }
        return figPoly;
    }

    protected Fig handleGroup(TXElement tXElement) {
        Fig fig = null;
        String string = tXElement.getAttribute("description");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;[] ");
        String string2 = stringTokenizer.nextToken();
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
            string5 = stringTokenizer.nextToken();
            string6 = stringTokenizer.nextToken();
        }
        try {
            String string7;
            Object object;
            Object object2;
            Object object3;
            Fig fig2;
            TXElement tXElement2;
            String string8;
            Node node;
            int n;
            int n2;
            Class<?> clazz = Class.forName(string2);
            fig = (Fig)clazz.newInstance();
            if (string3 != null && !string3.equals("")) {
                int n3 = Integer.parseInt(string3);
                int n4 = Integer.parseInt(string4);
                n2 = Integer.parseInt(string5);
                n = Integer.parseInt(string6);
                fig.setBounds(n3, n4, n2, n);
            }
            if (fig instanceof FigNode) {
                FigNode figNode = (FigNode)fig;
                if (tXElement.hasChildNodes()) {
                    NodeList nodeList = tXElement.getChildNodes();
                    n2 = nodeList.getLength();
                    n = 0;
                    while (n < n2) {
                        node = nodeList.item(n);
                        if (node instanceof TXElement && "private".equals(string8 = (tXElement2 = (TXElement)node).getName())) {
                            fig2 = null;
                            object3 = tXElement2.getText();
                            object2 = new StringTokenizer((String)object3, "=\"' \t\n");
                            while (((StringTokenizer)object2).hasMoreElements()) {
                                object = ((StringTokenizer)object2).nextToken();
                                string7 = "no such fig";
                                if (((StringTokenizer)object2).hasMoreElements()) {
                                    string7 = ((StringTokenizer)object2).nextToken();
                                }
                                if (!((String)object).equals("enclosingFig")) continue;
                                fig2 = this.findFig(string7);
                            }
                            figNode.setEnclosingFig(fig2);
                        }
                        ++n;
                    }
                }
            }
            if (fig instanceof FigEdge) {
                FigEdge figEdge = (FigEdge)fig;
                if (tXElement.hasChildNodes()) {
                    NodeList nodeList = tXElement.getChildNodes();
                    n2 = nodeList.getLength();
                    n = 0;
                    while (n < n2) {
                        node = nodeList.item(n);
                        if (node instanceof TXElement) {
                            tXElement2 = (TXElement)node;
                            string8 = tXElement2.getName();
                            if ("path".equals(string8)) {
                                fig2 = this.handlePath(tXElement2);
                                figEdge.setFig(fig2);
                                fig2._isComplete = true;
                                figEdge.calcBounds();
                                if (figEdge instanceof FigEdgePoly) {
                                    ((FigEdgePoly)figEdge).setInitiallyLaidOut(true);
                                }
                            } else if ("private".equals(string8)) {
                                fig2 = null;
                                object3 = null;
                                object2 = null;
                                object = null;
                                string7 = tXElement2.getText();
                                StringTokenizer stringTokenizer2 = new StringTokenizer(string7, "=\"' \t\n");
                                while (stringTokenizer2.hasMoreElements()) {
                                    String string9 = stringTokenizer2.nextToken();
                                    String string10 = stringTokenizer2.nextToken();
                                    if (string9.equals("sourcePortFig")) {
                                        fig2 = this.findFig(string10);
                                    }
                                    if (string9.equals("destPortFig")) {
                                        object3 = this.findFig(string10);
                                    }
                                    if (string9.equals("sourceFigNode")) {
                                        object2 = (FigNode)this.findFig(string10);
                                    }
                                    if (!string9.equals("destFigNode")) continue;
                                    object = (FigNode)this.findFig(string10);
                                }
                                figEdge.setSourcePortFig(fig2);
                                figEdge.setDestPortFig((Fig)object3);
                                figEdge.setSourceFigNode((FigNode)object2);
                                figEdge.setDestFigNode((FigNode)object);
                            }
                        }
                        ++n;
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception in handleGroup");
            exception.printStackTrace();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.out.println("No constructor() in class " + string2);
            noSuchMethodError.printStackTrace();
        }
        this.setAttrs(fig, tXElement);
        return fig;
    }

    protected void setAttrs(Fig fig, TXElement tXElement) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = tXElement.getAttribute("name");
        if (string7 != null && !string7.equals("")) {
            this._figRegistry.put(string7, fig);
        }
        if ((string6 = tXElement.getAttribute("x")) != null && !string6.equals("")) {
            string5 = tXElement.getAttribute("y");
            string4 = tXElement.getAttribute("width");
            string3 = tXElement.getAttribute("height");
            int n = Integer.parseInt(string6);
            int n2 = string5 == null || string5.equals("") ? 0 : Integer.parseInt(string5);
            int n3 = string4 == null || string4.equals("") ? 20 : Integer.parseInt(string4);
            int n4 = string3 == null || string3.equals("") ? 20 : Integer.parseInt(string3);
            fig.setBounds(n, n2, n3, n4);
        }
        if ((string5 = tXElement.getAttribute("stroke")) != null && !string5.equals("")) {
            fig.setLineWidth(Integer.parseInt(string5));
        }
        if ((string4 = tXElement.getAttribute("strokecolor")) != null && !string4.equals("")) {
            fig.setLineColor(this.colorByName(string4, Color.blue));
        }
        if ((string3 = tXElement.getAttribute("fill")) != null && !string3.equals("")) {
            fig.setFilled(string3.equals("1") || string3.startsWith("t"));
        }
        if ((string2 = tXElement.getAttribute("fillcolor")) != null && !string2.equals("")) {
            fig.setFillColor(this.colorByName(string2, Color.white));
        }
        if ((string = tXElement.getAttribute("dasharray")) != null && !string.equals("") && !string.equals("solid")) {
            fig.setDashed(true);
        }
        try {
            String string8 = tXElement.getAttribute("href");
            if (string8 != null && !string8.equals("")) {
                fig.setOwner(this.findOwner(string8));
            }
        }
        catch (Exception exception) {
            System.out.println("could not set owner");
        }
    }

    protected Object findOwner(String string) {
        Object v = this._ownerRegistry.get(string);
        return v;
    }

    /*
     * Unable to fully structure code
     */
    protected Fig findFig(String var1_1) {
        block2: {
            block1: {
                var2_2 = null;
                if (var1_1.indexOf(".") != -1) break block1;
                var2_2 = (Fig)this._figRegistry.get(var1_1);
                break block2;
            }
            var3_3 = new StringTokenizer(var1_1, ".");
            var4_4 = var3_3.nextToken();
            var2_2 = (Fig)this._figRegistry.get(var4_4);
            if (!(var2_2 instanceof FigEdge)) ** GOTO lbl15
            return ((FigEdge)var2_2).getFig();
lbl-1000:
            // 1 sources

            {
                if (!(var2_2 instanceof FigGroup)) continue;
                var5_5 = var3_3.nextToken();
                var6_6 = Integer.parseInt(var5_5);
                var2_2 = (Fig)((FigGroup)var2_2).getFigs().elementAt(var6_6);
lbl15:
                // 3 sources

                ** while (var3_3.hasMoreElements())
            }
        }
        return var2_2;
    }

    protected GraphModel getGraphModelFor(String string) {
        System.out.println("should be: " + string);
        return new DefaultGraphModel();
    }

    protected Color colorByName(String string, Color color) {
        if (string.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (string.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (string.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (string.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (string.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (string.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (string.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (string.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (string.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        if (string.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (string.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (string.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (string.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        try {
            return Color.decode(string);
        }
        catch (Exception exception) {
            System.out.println("invalid color code string: " + string);
            return color;
        }
    }

    protected PGMLParser() {
    }
}

