/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.util.StringTokenizer;
import org.tigris.gef.util.Predicate;
import org.tigris.gef.util.PredicateEquals;
import org.tigris.gef.util.PredicateTrue;

public class PredicateStringMatch
implements Predicate {
    public static int MAX_PATS = 10;
    String[] _patterns;
    int _numPats;

    public static Predicate create(String string) {
        string = string.trim();
        String[] stringArray = new String[MAX_PATS];
        int n = 0;
        if (string.startsWith("*")) {
            stringArray[n++] = "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            stringArray[n++] = string2;
        }
        if (string.endsWith("*")) {
            stringArray[n++] = "";
        }
        if (n == 0) {
            return PredicateTrue.theInstance();
        }
        if (n == 1) {
            return new PredicateEquals(stringArray[0]);
        }
        return new PredicateStringMatch(stringArray, n);
    }

    public boolean predicate(Object object) {
        String string = object.toString();
        if (!string.startsWith(this._patterns[0])) {
            return false;
        }
        if (!string.endsWith(this._patterns[this._numPats - 1])) {
            return false;
        }
        int n = 0;
        while (n < this._numPats) {
            String string2 = this._patterns[n];
            int n2 = (string + "*").indexOf(string2);
            if (n2 == -1) {
                return false;
            }
            string = string.substring(n2 + string2.length());
            ++n;
        }
        return true;
    }

    protected PredicateStringMatch(String[] stringArray, int n) {
        this._patterns = stringArray;
        this._numPats = n;
    }
}

