/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.ui;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.tigris.gef.base.CmdCreateNode;
import org.tigris.gef.base.CmdSetMode;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.util.Util;

public class ToolBar
extends JToolBar
implements MouseListener {
    protected Vector _lockable = new Vector();
    protected Vector _modeButtons = new Vector();

    public JButton add(Action action) {
        String string = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.add(action, string, icon);
    }

    public JButton add(Action action, String string, String string2) {
        ImageIcon imageIcon = Util.loadIconResource(string2, string);
        return this.add(action, string, imageIcon);
    }

    public JButton add(Action action, String string, Icon icon) {
        PropertyChangeListener propertyChangeListener;
        JButton jButton = new JButton(icon);
        if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
            this._modeButtons.addElement(jButton);
        }
        jButton.setToolTipText(string + " ");
        jButton.setEnabled(action.isEnabled());
        jButton.addActionListener(action);
        this.add(jButton);
        if (action instanceof CmdSetMode || action instanceof CmdCreateNode) {
            this._lockable.addElement(jButton);
        }
        if ((propertyChangeListener = this.createActionChangeListener(jButton)) != null) {
            action.addPropertyChangeListener(propertyChangeListener);
        }
        jButton.addMouseListener(this);
        return jButton;
    }

    public JToggleButton addToggle(Action action) {
        String string = (String)action.getValue("Name");
        Icon icon = (Icon)action.getValue("SmallIcon");
        return this.addToggle(action, string, icon);
    }

    public JToggleButton addToggle(Action action, String string, String string2) {
        ImageIcon imageIcon = Util.loadIconResource(string2, string);
        return this.addToggle(action, string, imageIcon);
    }

    public JToggleButton addToggle(Action action, String string, Icon icon) {
        JToggleButton jToggleButton = new JToggleButton(icon);
        jToggleButton.setToolTipText(string + " ");
        jToggleButton.setEnabled(action.isEnabled());
        jToggleButton.addActionListener(action);
        this.add(jToggleButton);
        PropertyChangeListener propertyChangeListener = this.createActionToggleListener(jToggleButton);
        action.addPropertyChangeListener(propertyChangeListener);
        return jToggleButton;
    }

    public JToggleButton addToggle(Action action, String string, String string2, String string3) {
        ImageIcon imageIcon = Util.loadIconResource(string2, string);
        ImageIcon imageIcon2 = Util.loadIconResource(string3, string);
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.setToolTipText(string + " ");
        jToggleButton.setEnabled(action.isEnabled());
        jToggleButton.addActionListener(action);
        jToggleButton.setPressedIcon(imageIcon2);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        this.add(jToggleButton);
        PropertyChangeListener propertyChangeListener = this.createActionToggleListener(jToggleButton);
        action.addPropertyChangeListener(propertyChangeListener);
        return jToggleButton;
    }

    public ButtonGroup addRadioGroup(String string, ImageIcon imageIcon, ImageIcon imageIcon2, String string2, ImageIcon imageIcon3, ImageIcon imageIcon4) {
        JRadioButton jRadioButton = new JRadioButton(imageIcon, true);
        jRadioButton.setSelectedIcon(imageIcon2);
        jRadioButton.setToolTipText(string + " ");
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.getAccessibleContext().setAccessibleName(string);
        JRadioButton jRadioButton2 = new JRadioButton(imageIcon3, false);
        jRadioButton2.setSelectedIcon(imageIcon4);
        jRadioButton2.setToolTipText(string2 + " ");
        jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton2.getAccessibleContext().setAccessibleName(string2);
        this.add(jRadioButton);
        this.add(jRadioButton2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        return buttonGroup;
    }

    protected PropertyChangeListener createActionToggleListener(JToggleButton jToggleButton) {
        ToolBar toolBar = this;
        if (toolBar == null) {
            throw null;
        }
        return toolBar.new ActionToggleChangedListener(jToggleButton);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Serializable serializable;
        Object object = mouseEvent.getSource();
        if (this.isModeButton(object)) {
            this.unpressAllButtonsExcept(object);
            serializable = Globals.curEditor();
            if (serializable != null) {
                ((Editor)serializable).finishMode();
            }
            Globals.setSticky(false);
        }
        if (mouseEvent.getClickCount() >= 2) {
            if (!(object instanceof JButton)) {
                return;
            }
            serializable = (JButton)object;
            if (this.canLock(serializable)) {
                ((AbstractButton)serializable).getModel().setPressed(true);
                ((AbstractButton)serializable).getModel().setArmed(true);
                Globals.setSticky(true);
            }
        } else if (mouseEvent.getClickCount() == 1 && object instanceof JButton && this.isModeButton(object)) {
            serializable = (JButton)object;
            ((AbstractButton)serializable).setFocusPainted(false);
            ((AbstractButton)serializable).getModel().setPressed(true);
        }
    }

    protected boolean canLock(Object object) {
        return this._lockable.contains(object);
    }

    protected boolean isModeButton(Object object) {
        return this._modeButtons.contains(object);
    }

    protected void unpressAllButtonsExcept(Object object) {
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getComponent(n2);
            if (component instanceof JButton && component != object) {
                ((JButton)component).getModel().setArmed(false);
                ((JButton)component).getModel().setPressed(false);
            }
            ++n2;
        }
    }

    public void unpressAllButtons() {
        Component component;
        int n = this.getComponentCount();
        int n2 = 0;
        while (n2 < n) {
            component = this.getComponent(n2);
            if (component instanceof JButton) {
                ((JButton)component).getModel().setArmed(false);
                ((JButton)component).getModel().setPressed(false);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            component = this.getComponent(n2);
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                jButton.getModel().setArmed(true);
                jButton.getModel().setPressed(true);
                return;
            }
            ++n2;
        }
    }

    public ToolBar() {
        this.setFloatable(false);
    }

    private class ActionToggleChangedListener
    implements PropertyChangeListener {
        JToggleButton button;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }

        ActionToggleChangedListener(JToggleButton jToggleButton) {
            this.button = jToggleButton;
        }
    }
}

