/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;

public class PropsGridLayout
implements LayoutManager {
    int hgap;
    int vgap;
    int _labelWidth = 100;
    int _labelHeight = 22;
    int _minPropWidth = 150;

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = this._labelWidth + this._minPropWidth + this.hgap;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getPreferredSize();
            n3 += dimension.height + this.vgap;
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        int n2 = this._labelWidth + this._minPropWidth + this.hgap;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            Component component = container.getComponent(n4);
            Dimension dimension = component.getMinimumSize();
            n3 += dimension.height + this.vgap;
            ++n4;
        }
        return new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom + n3);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        int n = container.getComponentCount();
        if (n == 0) {
            return;
        }
        int n2 = insets.left + insets.right + this.hgap + this._labelWidth;
        int n3 = Math.max(container.getSize().width - n2, this._minPropWidth);
        Graphics graphics = container.getGraphics();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            Component component = container.getComponent(n5);
            Dimension dimension = component.getPreferredSize();
            if (n5 % 2 == 0) {
                component.setBounds(0, n4, this._labelWidth, this._labelHeight);
            } else {
                component.setLocation(this._labelWidth + this.hgap, n4);
                component.setSize(dimension);
                n4 += Math.max(dimension.height, this._labelHeight) + this.vgap;
            }
            ++n5;
        }
    }

    public PropsGridLayout(int n, int n2) {
        this.hgap = n;
        this.vgap = n2;
    }
}

