/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.TextComponent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.properties.ui.PropSheet;
import org.tigris.gef.properties.ui.PropertyCanvas;
import org.tigris.gef.properties.ui.PropertySelector;
import org.tigris.gef.properties.ui.PropertyText;
import org.tigris.gef.properties.ui.PropsGridLayout;

public class PropSheetCategory
extends PropSheet {
    public static final String dots = "";
    protected Hashtable _keysComps;
    protected Hashtable _compsKeys;
    protected Hashtable _inUse;
    protected Hashtable _labels;
    protected Hashtable _shown;
    protected String _category = "Misc";
    protected PropertyDescriptor[] _properties;
    protected JFrame _jframe;
    protected boolean inRecursion = false;
    private static /* synthetic */ Class class$Ljava$awt$Color;
    private static /* synthetic */ Class class$Lorg$tigris$gef$properties$ui$ColorEditor;
    private static /* synthetic */ Class class$Ljava$awt$Rectangle;
    private static /* synthetic */ Class class$Lorg$tigris$gef$properties$ui$RectangleEditor;

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String string) {
        if (string == this._category) {
            return;
        }
        this._category = string;
        this.setTabName(string);
        if (this._sel != null) {
            this.updateComponents();
            this.repaint();
        }
    }

    public Component addKeyComp(PropertyDescriptor propertyDescriptor) {
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        if (component == null) {
            component = this.makeComp(propertyDescriptor);
            this._keysComps.put(propertyDescriptor, component);
            this._compsKeys.put(component, propertyDescriptor);
            JLabel jLabel = new JLabel(propertyDescriptor.getName() + dots);
            this._labels.put(propertyDescriptor, jLabel);
        }
        this._inUse.put(propertyDescriptor, propertyDescriptor);
        return component;
    }

    public void updateKeysComps() {
        this._inUse.clear();
        if (this._sel == null) {
            return;
        }
        Class<?> clazz = this._sel.getClass();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            this._properties = beanInfo.getPropertyDescriptors();
        }
        catch (IntrospectionException introspectionException) {
            System.out.println("PropertySheet: Couldn't introspect\n" + introspectionException.toString());
            return;
        }
        int n = 0;
        while (n < this._properties.length) {
            if (PropCategoryManager.inCategory(this._category, this._properties[n])) {
                boolean bl;
                Component component = this.addKeyComp(this._properties[n]);
                boolean bl2 = bl = this._properties[n].getWriteMethod() != null;
                if (component instanceof TextComponent) {
                    ((TextComponent)component).setEditable(bl);
                } else {
                    component.setEnabled(bl);
                }
            }
            ++n;
        }
    }

    public void show(PropertyDescriptor propertyDescriptor) {
        JLabel jLabel = (JLabel)this._labels.get(propertyDescriptor);
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        this.setComponentValue(propertyDescriptor, component);
        if (this._shown.containsKey(propertyDescriptor)) {
            return;
        }
        this.add(jLabel);
        this.add(component);
        jLabel.setVisible(true);
        component.setVisible(true);
        this._shown.put(propertyDescriptor, propertyDescriptor);
    }

    public void hide(PropertyDescriptor propertyDescriptor) {
        if (!this._shown.containsKey(propertyDescriptor)) {
            return;
        }
        JLabel jLabel = (JLabel)this._labels.get(propertyDescriptor);
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        jLabel.setVisible(false);
        component.setVisible(false);
        this.remove(jLabel);
        this.remove(component);
        this._shown.remove(propertyDescriptor);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 400);
    }

    public Dimension getSize() {
        return new Dimension(300, 400);
    }

    public Component makeComp(PropertyDescriptor propertyDescriptor) {
        Component component = null;
        try {
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{};
            Object object = method.invoke(this._sel, objectArray);
            Class<?> clazz = propertyDescriptor.getPropertyType();
            PropertyEditor propertyEditor = null;
            Class<?> clazz2 = propertyDescriptor.getPropertyEditorClass();
            if (clazz2 != null) {
                try {
                    propertyEditor = (PropertyEditor)clazz2.newInstance();
                }
                catch (Exception exception) {
                    System.out.println("exception in makecomp");
                }
            }
            if (propertyEditor == null) {
                propertyEditor = PropertyEditorManager.findEditor(clazz);
            }
            if (propertyEditor == null) {
                return new JLabel(object == null ? "(null)" : object.toString());
            }
            propertyEditor.setValue(object);
            propertyEditor.addPropertyChangeListener(this);
            this._editorsPds.put(propertyEditor, propertyDescriptor);
            this._pdsEditors.put(propertyDescriptor, propertyEditor);
            if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
                component = new PropertyCanvas(this._jframe, propertyEditor);
            } else if (propertyEditor instanceof Component) {
                component = (Component)((Object)propertyEditor);
            } else if (propertyEditor.getTags() != null) {
                component = new PropertySelector(propertyEditor);
            } else if (propertyEditor.getAsText() != null) {
                String string = propertyEditor.getAsText();
                component = new PropertyText(propertyEditor);
            } else {
                System.err.println("Warning: Property \"" + ((Object)propertyDescriptor).toString() + "\" has non-displayabale editor. Skipping.");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Skipping property " + ((Object)propertyDescriptor).toString() + " ; exception on target: " + invocationTargetException.getTargetException());
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Skipping property " + ((Object)propertyDescriptor).toString() + " ; Illegal Access on target: " + illegalAccessException.toString());
            illegalAccessException.printStackTrace();
        }
        return component;
    }

    public void setComponentValue(PropertyDescriptor propertyDescriptor, Component component) {
        Object object;
        if (this.inRecursion) {
            return;
        }
        Object object2 = null;
        try {
            object = propertyDescriptor.getReadMethod();
            Method method = propertyDescriptor.getWriteMethod();
            Object[] objectArray = new Object[]{};
            object2 = ((Method)object).invoke(this._sel, objectArray);
        }
        catch (Exception exception) {
            System.out.println("unexpected Exception!");
        }
        if (object2 == null) {
            System.out.println("null value");
            return;
        }
        if (component == null) {
            System.out.println("tag is null");
        }
        this.inRecursion = true;
        if (component instanceof PropertyEditor) {
            ((PropertyEditor)((Object)component)).setValue(object2);
        } else if (component instanceof PropertyText) {
            ((PropertyText)component).setText(object2.toString());
        } else if (component instanceof PropertySelector) {
            object = object2.toString();
            if (object2 instanceof Boolean) {
                object = (Boolean)object2 != false ? "True" : "False";
            }
            if (object == null) {
                System.out.println("tag is null");
            }
            ((PropertySelector)component).setSelectedItem(object);
        } else if (component instanceof Label) {
            ((Label)component).setText(object2.toString());
        } else {
            object = (PropertyEditor)this._pdsEditors.get(propertyDescriptor);
            if (object != null) {
                this._ignorePropChanges = true;
                object.setValue(object2);
                this._ignorePropChanges = false;
            }
        }
        this.inRecursion = false;
    }

    public void addNotify() {
        if (this._keysComps != null) {
            super.addNotify();
        }
    }

    public boolean canEdit(Object object) {
        return object != null && super.canEdit(object);
    }

    public void updateComponents() {
        super.updateComponents();
        this.updateKeysComps();
        Enumeration enumeration = this._keysComps.keys();
        while (enumeration.hasMoreElements()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)enumeration.nextElement();
            if (this._inUse.containsKey(propertyDescriptor)) {
                this.show(propertyDescriptor);
                continue;
            }
            this.hide(propertyDescriptor);
        }
        this.validate();
    }

    public void updateComponent(PropertyDescriptor propertyDescriptor) {
        Component component = (Component)this._keysComps.get(propertyDescriptor);
        if (component != null) {
            this.setComponentValue(propertyDescriptor, component);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public PropSheetCategory(JFrame jFrame) {
        this._jframe = jFrame;
        this.setTabName("no key");
        this.setLayout(new PropsGridLayout(4, 4));
        this.setSize(this.getInsets().left + this.getInsets().right + 250, this.getInsets().top + this.getInsets().bottom + 300);
        this.setFont(this.getPropertiesFont());
        this._keysComps = new Hashtable(20);
        this._compsKeys = new Hashtable(20);
        this._labels = new Hashtable(20);
        this._inUse = new Hashtable(20);
        this._shown = new Hashtable(20);
    }

    static {
        String[] stringArray = new String[]{"org.tigris.gef.properties.ui", "sun.beans.editors"};
        PropertyEditorManager.setEditorSearchPath(stringArray);
        PropertyEditorManager.registerEditor(class$Ljava$awt$Color != null ? class$Ljava$awt$Color : (class$Ljava$awt$Color = PropSheetCategory.class$("java.awt.Color")), class$Lorg$tigris$gef$properties$ui$ColorEditor != null ? class$Lorg$tigris$gef$properties$ui$ColorEditor : (class$Lorg$tigris$gef$properties$ui$ColorEditor = PropSheetCategory.class$("org.tigris.gef.properties.ui.ColorEditor")));
        PropertyEditorManager.registerEditor(class$Ljava$awt$Rectangle != null ? class$Ljava$awt$Rectangle : (class$Ljava$awt$Rectangle = PropSheetCategory.class$("java.awt.Rectangle")), class$Lorg$tigris$gef$properties$ui$RectangleEditor != null ? class$Lorg$tigris$gef$properties$ui$RectangleEditor : (class$Lorg$tigris$gef$properties$ui$RectangleEditor = PropSheetCategory.class$("org.tigris.gef.properties.ui.RectangleEditor")));
    }
}

