/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JPanel;
import org.tigris.gef.presentation.Fig;

public class PropSheet
extends JPanel
implements PropertyChangeListener {
    public static final int MIN_UPDATE = 200;
    protected Object _sel = null;
    protected Hashtable _pendingStores = new Hashtable();
    protected Hashtable _pdsEditors = new Hashtable();
    protected Hashtable _editorsPds = new Hashtable();
    protected boolean _autoApply = true;
    protected boolean _ignorePropChanges = false;
    protected String _tabName = "Misc";
    protected Font _propertiesFont = new Font("Dialog", 0, 10);
    protected long _lastUpdateTime = System.currentTimeMillis();

    public void setSelection(Object object) {
        if (this._sel == object) {
            return;
        }
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).removePropertyChangeListener(this);
        }
        this._sel = object;
        if (this._sel instanceof Fig) {
            ((Fig)this._sel).addPropertyChangeListener(this);
        }
        this.updateComponents();
    }

    public void setAutoApply(boolean bl) {
        this._autoApply = bl;
        if (this._autoApply) {
            this.apply();
        }
    }

    public String getTabName() {
        return this._tabName;
    }

    public void setTabName(String string) {
        this._tabName = string;
    }

    public boolean canEdit(Object object) {
        return true;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl) {
            this.setSelection(null);
        }
    }

    public Font getPropertiesFont() {
        return this._propertiesFont;
    }

    public void setPropertiesFont(Font font) {
        this._propertiesFont = font;
    }

    public void store(PropertyDescriptor propertyDescriptor, Object object) {
        if (propertyDescriptor == null || object == null) {
            return;
        }
        this._pendingStores.put(propertyDescriptor, object);
        if (this._autoApply) {
            this.apply();
        }
    }

    public void apply() {
        try {
            this._ignorePropChanges = true;
            if (this._sel instanceof Fig) {
                ((Fig)this._sel).startTrans();
            }
            if (this._sel != null) {
                Enumeration enumeration = this._pendingStores.keys();
                while (enumeration.hasMoreElements()) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)enumeration.nextElement();
                    this.applyProperty(propertyDescriptor, this._pendingStores.get(propertyDescriptor));
                }
            }
            if (this._sel instanceof Fig) {
                ((Fig)this._sel).endTrans();
            }
            this._pendingStores.clear();
        }
        finally {
            Object var2_3 = null;
            this.updateComponents();
            this._ignorePropChanges = false;
        }
    }

    protected void applyProperty(PropertyDescriptor propertyDescriptor, Object object) {
        try {
            Object[] objectArray = new Object[]{object};
            objectArray[0] = object;
            Method method = propertyDescriptor.getWriteMethod();
            method.invoke(this._sel, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof PropertyVetoException) {
                System.out.println("Vetoed; because: " + invocationTargetException.getTargetException().getMessage());
            } else {
                System.out.println("InvocationTargetException while updating " + propertyDescriptor.getName() + "\n" + invocationTargetException.getTargetException().toString());
            }
        }
        catch (Exception exception) {
            System.out.println("Unexpected exception while updating " + propertyDescriptor.getName() + "\n" + exception.toString());
        }
    }

    public void revert() {
        this._pendingStores.clear();
        this.updateComponents();
    }

    public void updateComponents() {
    }

    public void updateComponent(PropertyDescriptor propertyDescriptor) {
        this.updateComponents();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._ignorePropChanges) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (object == this._sel && !this._ignorePropChanges) {
            long l = System.currentTimeMillis();
            if (this._lastUpdateTime + 200L > l) {
                return;
            }
            this.updateComponents();
            this._lastUpdateTime = l;
        } else {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this._editorsPds.get(object);
            if (propertyDescriptor != null) {
                this.store(propertyDescriptor, ((PropertyEditor)object).getValue());
            }
        }
    }
}

