/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.properties.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class ColorTilePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    public static final int TILESIZE = 6;
    public static Vector _NetscapeColors = null;
    protected Vector _colors;
    protected int _selected = 0;
    protected int _nCols;
    protected boolean _allowSelection = true;
    protected ActionListener _onlyListener = null;

    public Color getColor() {
        return (Color)this._colors.elementAt(this._selected);
    }

    public void setColor(Color color) {
        if (!this._colors.contains(color)) {
            return;
        }
        this.setSelectionIndex(this._colors.indexOf(color));
    }

    public void allowSelection(boolean bl) {
        this._allowSelection = bl;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n = 0;
        while (n < this._colors.size()) {
            this.paintTile(graphics, n);
            ++n;
        }
        this.showSelection(graphics);
    }

    public void paintTile(Graphics graphics, int n) {
        graphics.setColor((Color)this._colors.elementAt(n));
        int n2 = n % this._nCols;
        int n3 = n / this._nCols;
        graphics.fillRect(n2 * 6, n3 * 6, 6, 6);
    }

    public void showSelection(Graphics graphics) {
        Color color = (Color)this._colors.elementAt(this._selected);
        Color color2 = color.getRed() + color.getBlue() + color.getGreen() > 382 ? Color.black : Color.white;
        graphics.setColor(color2);
        graphics.drawRect(this._selected % this._nCols * 6, this._selected / this._nCols * 6, 5, 5);
    }

    public Dimension getMinimumSize() {
        int n = 6 * this._nCols;
        int n2 = 6 * (this._colors.size() / this._nCols + 2);
        return new Dimension(n, n2);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public boolean setSelectionIndex(int n) {
        if (n < 0 || n > this._colors.size()) {
            return false;
        }
        if (n == this._selected) {
            return false;
        }
        this._selected = n;
        this.repaint();
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (n > this._nCols * 6 - 1 || n2 > this._colors.size() / this._nCols * 6 - 1) {
            return;
        }
        int n3 = n / 6;
        int n4 = n2 / 6;
        if (this.setSelectionIndex(n3 + n4 * this._nCols)) {
            this.fireActionEvent(null);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public static Vector netscapeColors() {
        if (_NetscapeColors == null) {
            int[] nArray = new int[6];
            int n = 0;
            nArray[n++] = 0;
            nArray[n++] = 51;
            nArray[n++] = 102;
            nArray[n++] = 153;
            nArray[n++] = 204;
            nArray[n++] = 255;
            _NetscapeColors = new Vector(n * n * n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = 0;
                while (n3 < n) {
                    int n4 = 0;
                    while (n4 < n) {
                        Color color = new Color(nArray[n2], nArray[n3], nArray[n4]);
                        _NetscapeColors.addElement(color);
                        ++n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return _NetscapeColors;
    }

    public void addActionListener(ActionListener actionListener) {
        this._onlyListener = actionListener;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this._onlyListener == actionListener) {
            this._onlyListener = null;
        }
    }

    public void fireActionEvent(ActionEvent actionEvent) {
        if (this._onlyListener != null) {
            this._onlyListener.actionPerformed(actionEvent);
        }
    }

    public ColorTilePanel() {
        this(ColorTilePanel.netscapeColors());
    }

    public ColorTilePanel(int n) {
        this(ColorTilePanel.netscapeColors(), n);
    }

    public ColorTilePanel(Vector vector) {
        this._colors = vector;
        this._nCols = (int)Math.sqrt(vector.size());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public ColorTilePanel(Vector vector, int n) {
        this._colors = vector;
        this._nCols = n;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }
}

