/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigTextEditor;
import org.tigris.gef.properties.PropCategoryManager;

public class FigText
extends Fig
implements KeyListener,
MouseListener {
    public static final int JUSTIFY_LEFT = 0;
    public static final int JUSTIFY_RIGHT = 1;
    public static final int JUSTIFY_CENTER = 2;
    public static final int MIN_TEXT_WIDTH = 30;
    protected Font _font = new Font("TimesRoman", 0, 10);
    protected transient FontMetrics _fm;
    protected int _lineHeight;
    protected Color _textColor = Color.black;
    protected Color _textFillColor = Color.white;
    protected boolean _textFilled = false;
    protected boolean _editable = true;
    protected boolean _underline = false;
    protected boolean _multiLine = true;
    protected boolean _allowsTab = true;
    protected int _lineSpacing = 0;
    protected int _topMargin = 1;
    protected int _botMargin = 1;
    protected int _leftMargin = 1;
    protected int _rightMargin = 1;
    protected boolean _expandOnly = false;
    protected int _justification = 0;
    protected String _curText;

    public boolean OK() {
        if (!super.OK()) {
            return false;
        }
        return this._font != null && this._lineSpacing > -20 && this._topMargin >= 0 && this._botMargin >= 0 && this._leftMargin >= 0 && this._rightMargin >= 0 && (this._justification == 0 || this._justification == 2 || this._justification == 1) && this._textColor != null && this._textFillColor != null;
    }

    public String getJustificationByName() {
        if (this._justification == 0) {
            return "Left";
        }
        if (this._justification == 2) {
            return "Center";
        }
        if (this._justification == 1) {
            return "Right";
        }
        System.out.println("internal error, unknown text alignment");
        return "Unknown";
    }

    public void setJustifciaionByName(String string) {
        if (string.equals("Left")) {
            this._justification = 0;
        } else if (string.equals("Center")) {
            this._justification = 2;
        } else if (string.equals("Right")) {
            this._justification = 1;
        }
        this._fm = null;
    }

    public Color getTextColor() {
        return this._textColor;
    }

    public void setTextColor(Color color) {
        this.firePropChange("textColor", this._textColor, color);
        this._textColor = color;
    }

    public Color getTextFillColor() {
        return this._textFillColor;
    }

    public void setTextFillColor(Color color) {
        this.firePropChange("textFillColor", this._textFillColor, color);
        this._textFillColor = color;
    }

    public boolean getTextFilled() {
        return this._textFilled;
    }

    public void setTextFilled(boolean bl) {
        this.firePropChange("textFilled", this._textFilled, bl);
        this._textFilled = bl;
    }

    public boolean getEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this.firePropChange("editable", this._editable, bl);
        this._editable = bl;
    }

    public boolean getUnderline() {
        return this._underline;
    }

    public void setUnderline(boolean bl) {
        this.firePropChange("underline", this._underline, bl);
        this._underline = bl;
    }

    public int getJustification() {
        return this._justification;
    }

    public void setJustification(int n) {
        this.firePropChange("justifciaion", this.getJustification(), n);
        this._justification = n;
    }

    public int getLineSpacing() {
        return this._lineSpacing;
    }

    public void setLineSpacing(int n) {
        this.firePropChange("lineSpacing", this._lineSpacing, n);
        this._lineSpacing = n;
        this.calcBounds();
    }

    public int getTopMargin() {
        return this._topMargin;
    }

    public void setTopMargin(int n) {
        this.firePropChange("topMargin", this._topMargin, n);
        this._topMargin = n;
        this.calcBounds();
    }

    public int getBotMargin() {
        return this._botMargin;
    }

    public void setBotMargin(int n) {
        this.firePropChange("botMargin", this._botMargin, n);
        this._botMargin = n;
        this.calcBounds();
    }

    public int getLeftMargin() {
        return this._leftMargin;
    }

    public void setLeftMargin(int n) {
        this.firePropChange("leftMargin", this._leftMargin, n);
        this._leftMargin = n;
        this.calcBounds();
    }

    public int getRightMargin() {
        return this._rightMargin;
    }

    public void setRightMargin(int n) {
        this.firePropChange("rightMargin", this._rightMargin, n);
        this._rightMargin = n;
        this.calcBounds();
    }

    public boolean getExpandOnly() {
        return this._expandOnly;
    }

    public void setExpandOnly(boolean bl) {
        this.firePropChange("expandOnly", this._expandOnly, bl);
        this._expandOnly = bl;
    }

    public Font getFont() {
        return this._font;
    }

    public void setFont(Font font) {
        this.firePropChange("font", this._font, font);
        this._font = font;
        this._fm = null;
        this.calcBounds();
    }

    public String getFontFamily() {
        return this._font.getFamily();
    }

    public void setFontFamily(String string) {
        Font font = new Font(string, this._font.getStyle(), this._font.getSize());
        this.setFont(font);
    }

    public int getFontSize() {
        return this._font.getSize();
    }

    public void setFontSize(int n) {
        Font font = new Font(this._font.getFamily(), this._font.getStyle(), n);
        this.setFont(font);
    }

    public boolean getItalic() {
        return this._font.isItalic();
    }

    public void setItalic(boolean bl) {
        int n = (this.getBold() ? 1 : 0) + (bl ? 2 : 0);
        Font font = new Font(this._font.getFamily(), n, this._font.getSize());
        this.setFont(font);
    }

    public boolean getBold() {
        return this._font.isBold();
    }

    public void setBold(boolean bl) {
        int n = (bl ? 1 : 0) + (this.getItalic() ? 2 : 0);
        this.setFont(new Font(this._font.getFamily(), n, this._font.getSize()));
    }

    public void setMultiLine(boolean bl) {
        this._multiLine = bl;
    }

    public boolean getMultiLine() {
        return this._multiLine;
    }

    public void setAllowsTab(boolean bl) {
        this._allowsTab = bl;
    }

    public boolean getAllowsTab() {
        return this._allowsTab;
    }

    public String deleteLastCharFromString(String string) {
        int n = Math.max(string.length() - 1, 0);
        char[] cArray = string.toCharArray();
        return new String(cArray, 0, n);
    }

    public void deleteLastChar() {
        this._curText = this.deleteLastCharFromString(this._curText);
        this.calcBounds();
    }

    public void append(char c) {
        this.setText(this._curText + c);
    }

    public void append(String string) {
        this.setText(this._curText + string);
    }

    public void setText(String string) {
        this._curText = string;
        this.calcBounds();
    }

    public String getText() {
        return this._curText;
    }

    public void paint(Graphics graphics) {
        int n;
        String string;
        StringTokenizer stringTokenizer;
        int n2 = this._x + this._leftMargin;
        int n3 = this._y + this._topMargin;
        if (this._filled) {
            graphics.setColor(this._fillColor);
            graphics.fillRect(this._x, this._y, this._w, this._h);
        }
        if (this._lineWidth > 0) {
            graphics.setColor(this._lineColor);
            graphics.drawRect(this._x, this._y, this._w - this._lineWidth, this._h - this._lineWidth);
        }
        if (this._font != null) {
            graphics.setFont(this._font);
        }
        this._fm = graphics.getFontMetrics(this._font);
        int n4 = this._lineHeight + this._lineSpacing;
        n3 = this._y + this._topMargin + n4;
        if (this._textFilled) {
            graphics.setColor(this._textFillColor);
            stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                n = this._fm.stringWidth(string);
                switch (this._justification) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        n2 = this._x + (this._w - n) / 2;
                        break;
                    }
                    case 1: {
                        n2 = this._x + this._w - n - this._rightMargin;
                        break;
                    }
                }
                if (string.equals("\n") || string.equals("\r")) {
                    n3 += n4;
                    continue;
                }
                graphics.fillRect(n2, n3 - n4, n, n4);
            }
        }
        graphics.setColor(this._textColor);
        n2 = this._x + this._leftMargin;
        n3 = this._y + this._topMargin + this._lineHeight + this._lineSpacing;
        stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n = this._fm.stringWidth(string);
            switch (this._justification) {
                case 0: {
                    break;
                }
                case 2: {
                    n2 = this._x + (this._w - n) / 2;
                    break;
                }
                case 1: {
                    n2 = this._x + this._w - n;
                    break;
                }
            }
            if (string.equals("\n") || string.equals("\r")) {
                n3 += n4;
                continue;
            }
            if (this._underline) {
                graphics.drawLine(n2, n3 + 1, n2 + n, n3 + 1);
            }
            graphics.drawString(string, n2, n3);
        }
    }

    public boolean hit(Rectangle rectangle) {
        int n = this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        return n > 0;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        this.stuffMinimumSize(dimension);
        return dimension;
    }

    public void stuffMinimumSize(Dimension dimension) {
        int n;
        if (this._font == null) {
            return;
        }
        if (this._fm == null) {
            this._fm = Toolkit.getDefaultToolkit().getFontMetrics(this._font);
        }
        int n2 = 0;
        int n3 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            n = this._fm.stringWidth(string);
            if (string.equals("\n") || string.equals("\r")) {
                ++n3;
                continue;
            }
            n2 = Math.max(n, n2);
        }
        this._lineHeight = this._fm.getHeight();
        int n4 = this._fm.getMaxDescent();
        n = (this._lineHeight + this._lineSpacing) * n3 + this._topMargin + this._botMargin + n4;
        dimension.width = n2 = Math.max(30, n2 + this._leftMargin + this._rightMargin);
        dimension.height = n;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (!this._editable) {
            return;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isActionKey() && !this.isNonStartEditingKey(keyEvent)) {
            if (!this._editable) {
                return;
            }
            FigTextEditor figTextEditor = this.startTextEditor(keyEvent);
            figTextEditor.keyPressed(keyEvent);
            keyEvent.consume();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this._editable) {
            return;
        }
    }

    protected boolean isNonStartEditingKey(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 3: 
            case 9: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 127: 
            case 156: 
            case 157: {
                return true;
            }
        }
        if (keyEvent.isControlDown()) {
            return true;
        }
        if (keyEvent.isAltDown()) {
            return true;
        }
        return keyEvent.isMetaDown();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            if (!this._editable) {
                return;
            }
            this.startTextEditor(mouseEvent);
            mouseEvent.consume();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public FigTextEditor startTextEditor(InputEvent inputEvent) {
        FigTextEditor figTextEditor = new FigTextEditor(this, inputEvent);
        return figTextEditor;
    }

    public void calcBounds() {
        int n;
        if (this._font == null) {
            return;
        }
        if (this._fm == null) {
            this._fm = Toolkit.getDefaultToolkit().getFontMetrics(this._font);
        }
        int n2 = 0;
        int n3 = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(this._curText, "\n\r", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            n = this._fm.stringWidth(string);
            if (string.equals("\n") || string.equals("\r")) {
                ++n3;
                continue;
            }
            n2 = Math.max(n, n2);
        }
        this._lineHeight = this._fm.getHeight();
        int n4 = this._fm.getMaxDescent();
        n = (this._lineHeight + this._lineSpacing) * n3 + this._topMargin + this._botMargin + n4;
        n2 = Math.max(30, n2 + this._leftMargin + this._rightMargin);
        switch (this._justification) {
            case 0: {
                break;
            }
            case 2: {
                if (this._w >= n2) break;
                this._x -= (n2 - this._w) / 2;
                break;
            }
            case 1: {
                if (this._w >= n2) break;
                this._x -= n2 - this._w;
                break;
            }
        }
        this._w = this._expandOnly ? Math.max(this._w, n2) : n2;
        this._h = this._expandOnly ? Math.max(this._h, n) : n;
    }

    public FigText(int n, int n2, int n3, int n4, Color color, String string, int n5) {
        super(n, n2, n3, n4);
        this._x = n;
        this._y = n2;
        this._w = n3;
        this._h = n4;
        this._textColor = color;
        this._font = new Font(string, 0, n5);
        this._justification = 2;
        this._curText = "";
    }

    public FigText(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, Color.blue, "TimesRoman", 10);
    }

    static {
        PropCategoryManager.categorizeProperty("Text", "font");
        PropCategoryManager.categorizeProperty("Text", "underline");
        PropCategoryManager.categorizeProperty("Text", "expandOnly");
        PropCategoryManager.categorizeProperty("Text", "lineSpacing");
        PropCategoryManager.categorizeProperty("Text", "topMargin");
        PropCategoryManager.categorizeProperty("Text", "botMargin");
        PropCategoryManager.categorizeProperty("Text", "leftMargin");
        PropCategoryManager.categorizeProperty("Text", "rightMargin");
        PropCategoryManager.categorizeProperty("Text", "text");
        PropCategoryManager.categorizeProperty("Style", "justification");
        PropCategoryManager.categorizeProperty("Style", "textFilled");
        PropCategoryManager.categorizeProperty("Style", "textFillColor");
        PropCategoryManager.categorizeProperty("Style", "textColor");
    }
}

