/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.presentation.Fig;

public class FigLine
extends Fig {
    protected int _x1;
    protected int _y1;
    protected int _x2;
    protected int _y2;

    public final void setShape(Point point, Point point2) {
        this.setShape(point.x, point.y, point2.x, point2.y);
    }

    public void setShape(int n, int n2, int n3, int n4) {
        this._x1 = n;
        this._y1 = n2;
        this._x2 = n3;
        this._y2 = n4;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public int getX1() {
        return this._x1;
    }

    public int getY1() {
        return this._y1;
    }

    public int getX2() {
        return this._x2;
    }

    public int getY2() {
        return this._y2;
    }

    public void setX1(int n) {
        this._x1 = n;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY1(int n) {
        this._y1 = n;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setX2(int n) {
        this._x2 = n;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public void setY2(int n) {
        this._y2 = n;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public boolean isResizable() {
        return false;
    }

    public boolean isReshapable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public void setPoints(Point[] pointArray) {
        if (pointArray.length != 2) {
            throw new IllegalArgumentException("FigLine must have exactly 2 points");
        }
        this._x1 = pointArray[0].x;
        this._y1 = pointArray[0].y;
        this._x2 = pointArray[1].x;
        this._y2 = pointArray[1].y;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point[] getPoints() {
        Point[] pointArray = new Point[]{new Point(this._x1, this._y1), new Point(this._x2, this._y2)};
        return pointArray;
    }

    public void setPoints(int n, int n2, int n3) {
        if (n == 0) {
            this._x1 = n2;
            this._y1 = n3;
        } else if (n == 1) {
            this._x2 = n2;
            this._y2 = n3;
        } else {
            throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
        }
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point getPoints(int n) {
        if (n == 0) {
            return new Point(this._x1, this._y1);
        }
        if (n == 1) {
            return new Point(this._x2, this._y2);
        }
        throw new IndexOutOfBoundsException("FigLine has exactly 2 points");
    }

    public int getNumPoints() {
        return 2;
    }

    public int[] getXs() {
        int[] nArray = new int[]{this._x1, this._x2};
        return nArray;
    }

    public int[] getYs() {
        int[] nArray = new int[]{this._y1, this._y2};
        return nArray;
    }

    public int getPerimeterLength() {
        int n = (this._x2 - this._x1) * (this._x2 - this._x1);
        int n2 = (this._y2 - this._y1) * (this._y2 - this._y1);
        return (int)Math.sqrt(n + n2);
    }

    public void stuffPointAlongPerimeter(int n, Point point) {
        int n2 = this.getPerimeterLength();
        if (n <= 0) {
            point.x = this._x1;
            point.y = this._y1;
            return;
        }
        if (n >= n2) {
            point.x = this._x2;
            point.y = this._y2;
            return;
        }
        point.x = this._x1 + (this._x2 - this._x1) * n / n2;
        point.y = this._y1 + (this._y2 - this._y1) * n / n2;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._x1 = this._w == 0 ? n : n + (this._x1 - this._x) * n3 / this._w;
        this._y1 = this._h == 0 ? n2 : n2 + (this._y1 - this._y) * n4 / this._h;
        this._x2 = this._w == 0 ? n : n + (this._x2 - this._x) * n3 / this._w;
        this._y2 = this._h == 0 ? n2 : n2 + (this._y2 - this._y) * n4 / this._h;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public Point connectionPoint(Point point) {
        return Geometry.ptClosestTo(this._x1, this._y1, this._x2, this._y2, point);
    }

    public void translate(int n, int n2) {
        this._x1 += n;
        this._y1 += n2;
        this._x2 += n;
        this._y2 += n2;
        this._x += n;
        this._y += n2;
        this.firePropChange("bounds", null, null);
    }

    public void calcBounds() {
        if (this._x1 < this._x2) {
            this._x = this._x1;
            this._w = this._x2 - this._x1;
        } else {
            this._x = this._x2;
            this._w = this._x1 - this._x2;
        }
        if (this._y1 < this._y2) {
            this._y = this._y1;
            this._h = this._y2 - this._y1;
        } else {
            this._y = this._y2;
            this._h = this._y1 - this._y2;
        }
    }

    public void paint(Graphics graphics) {
        if (this._lineWidth > 0) {
            if (this.getDashed()) {
                graphics.setColor(this._lineColor);
                this.drawDashedLine(graphics, 0, this._x1, this._y1, this._x2, this._y2);
            } else {
                graphics.setColor(this._lineColor);
                graphics.drawLine(this._x1, this._y1, this._x2, this._y2);
            }
        }
    }

    public boolean hit(Rectangle rectangle) {
        return Geometry.intersects(rectangle, this._x1, this._y1, this._x2, this._y2);
    }

    public boolean intersects(Rectangle rectangle) {
        return Geometry.intersects(rectangle, this._x1, this._y1, this._x2, this._y2);
    }

    public void createDrag(int n, int n2, int n3, int n4, int n5, int n6) {
        this._x2 = n5;
        this._y2 = n6;
        this.calcBounds();
        this.firePropChange("bounds", null, null);
    }

    public FigLine(int n, int n2, int n3, int n4, Color color) {
        this.setX1(n);
        this.setY1(n2);
        this.setX2(n3);
        this.setY2(n4);
        this.setLineColor(color);
        this.calcBounds();
    }

    public FigLine(int n, int n2, int n3, int n4) {
        this.setX1(n);
        this.setY1(n2);
        this.setX2(n3);
        this.setY2(n4);
        this.calcBounds();
    }
}

