/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.PathConv;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.presentation.ArrowHead;
import org.tigris.gef.presentation.ArrowHeadNone;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.ui.Highlightable;

public abstract class FigEdge
extends Fig
implements PropertyChangeListener,
Highlightable {
    protected Fig _sourcePortFig;
    protected Fig _destPortFig;
    protected FigNode _sourceFigNode;
    protected FigNode _destFigNode;
    protected Fig _fig;
    protected boolean _useNearest = false;
    protected boolean _highlight = false;
    protected ArrowHead _arrowHeadStart = ArrowHeadNone.TheInstance;
    protected ArrowHead _arrowHeadEnd = ArrowHeadNone.TheInstance;
    protected Vector _pathItems = new Vector();

    public void addPathItem(Fig fig, PathConv pathConv) {
        FigEdge figEdge = this;
        if (figEdge == null) {
            throw null;
        }
        this._pathItems.addElement(figEdge.new PathItem(fig, pathConv));
        fig.setGroup(this);
    }

    public void calcBounds() {
        this._fig.calcBounds();
        Rectangle rectangle = this._fig.getBounds();
        Point point = new Point();
        int n = this._pathItems.size();
        int n2 = 0;
        while (n2 < n) {
            PathItem pathItem = (PathItem)this._pathItems.elementAt(n2);
            PathConv pathConv = pathItem.getPath();
            Fig fig = pathItem.getFig();
            int n3 = fig.getX();
            int n4 = fig.getY();
            int n5 = fig.getWidth() / 2;
            int n6 = fig.getHeight() / 2;
            pathConv.stuffPoint(point);
            if (n3 != point.x || n4 != point.y) {
                fig.damage();
                fig.setLocation(point.x - n5, point.y - n6);
            }
            rectangle.add(fig.getBounds());
            ++n2;
        }
        this._x = rectangle.x;
        this._y = rectangle.y;
        this._w = rectangle.width;
        this._h = rectangle.height;
    }

    public void cleanUp() {
        this._fig.cleanUp();
    }

    public void computeRoute() {
    }

    public boolean contains(int n, int n2) {
        if (this._fig.contains(n, n2)) {
            return true;
        }
        int n3 = this._pathItems.size();
        int n4 = 0;
        while (n4 < n3) {
            Fig fig = ((PathItem)this._pathItems.elementAt(n4)).getFig();
            if (fig.contains(n, n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public void delete() {
        if (this._sourceFigNode != null) {
            this._sourceFigNode.removeFigEdge(this);
        }
        if (this._destFigNode != null) {
            this._destFigNode.removeFigEdge(this);
        }
        super.delete();
    }

    public boolean getBetweenNearestPoints() {
        return this._useNearest;
    }

    public Rectangle getBounds() {
        Rectangle rectangle = this._fig.getBounds();
        int n = this._pathItems.size();
        int n2 = 0;
        while (n2 < n) {
            Fig fig = ((PathItem)this._pathItems.elementAt(n2)).getFig();
            rectangle.add(fig.getBounds());
            ++n2;
        }
        return rectangle;
    }

    public boolean getDashed() {
        return this._fig.getDashed();
    }

    public ArrowHead getDestArrowHead() {
        return this._arrowHeadEnd;
    }

    public Fig getDestFigNode() {
        return this._destFigNode;
    }

    public Fig getDestPortFig() {
        return this._destPortFig;
    }

    public Fig getFig() {
        return this._fig;
    }

    public Point getFirstPoint() {
        return this._fig.getFirstPoint();
    }

    public boolean getHighlight() {
        return this._highlight;
    }

    public Point getLastPoint() {
        return this._fig.getLastPoint();
    }

    public Color getLineColor() {
        return this._fig.getLineColor();
    }

    public int getLineWidth() {
        return this._fig.getLineWidth();
    }

    public int getNumPoints() {
        return this._fig.getNumPoints();
    }

    public Fig getPathItem(PathConv pathConv) {
        return null;
    }

    public Fig getPathItemFig(PathItem pathItem) {
        Fig fig = pathItem.getFig();
        return fig;
    }

    public Vector getPathItemFigs() {
        Vector<Fig> vector = new Vector<Fig>();
        int n = 0;
        while (n < this._pathItems.size()) {
            vector.add(this.getPathItemFig((PathItem)this._pathItems.elementAt(n)));
            ++n;
        }
        return vector;
    }

    public Vector getPathItemsRaw() {
        return this._pathItems;
    }

    public int getPerimeterLength() {
        return this._fig.getPerimeterLength();
    }

    public Point[] getPoints() {
        return this._fig.getPoints();
    }

    public Point getPoints(int n) {
        return this._fig.getPoints(n);
    }

    public String getPrivateData() {
        Fig fig = this.getSourcePortFig();
        Fig fig2 = this.getDestPortFig();
        Fig fig3 = this.getSourceFigNode();
        Fig fig4 = this.getDestFigNode();
        String string = "";
        if (fig != null) {
            string = string + "sourcePortFig=\"" + fig.getId() + "\" ";
        }
        if (fig2 != null) {
            string = string + "destPortFig=\"" + fig2.getId() + "\" ";
        }
        if (fig3 != null) {
            string = string + "sourceFigNode=\"" + fig3.getId() + "\" ";
        }
        if (fig4 != null) {
            string = string + "destFigNode=\"" + fig4.getId() + "\" ";
        }
        return string;
    }

    public ArrowHead getSourceArrowHead() {
        return this._arrowHeadStart;
    }

    public Fig getSourceFigNode() {
        return this._sourceFigNode;
    }

    public Fig getSourcePortFig() {
        return this._sourcePortFig;
    }

    public int[] getXs() {
        return this._fig.getXs();
    }

    public int[] getYs() {
        return this._fig.getYs();
    }

    public boolean hit(Rectangle rectangle) {
        if (this._fig.hit(rectangle)) {
            return true;
        }
        int n = this._pathItems.size();
        int n2 = 0;
        while (n2 < n) {
            Fig fig = ((PathItem)this._pathItems.elementAt(n2)).getFig();
            if (fig.hit(rectangle)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Fig hitFig(Rectangle rectangle) {
        Enumeration enumeration = this._pathItems.elements();
        Fig fig = null;
        if (this._fig.hit(rectangle)) {
            fig = this._fig;
        }
        while (enumeration.hasMoreElements()) {
            PathItem pathItem = (PathItem)enumeration.nextElement();
            Fig fig2 = pathItem.getFig();
            if (!fig2.hit(rectangle)) continue;
            fig = fig2;
        }
        return fig;
    }

    public boolean intersects(Rectangle rectangle) {
        if (this._fig.intersects(rectangle)) {
            return true;
        }
        int n = this._pathItems.size();
        int n2 = 0;
        while (n2 < n) {
            Fig fig = ((PathItem)this._pathItems.elementAt(n2)).getFig();
            if (fig.intersects(rectangle)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isReshapable() {
        return this._fig.isReshapable();
    }

    public boolean isResizable() {
        return this._fig.isResizable();
    }

    public boolean isRotatable() {
        return this._fig.isRotatable();
    }

    protected abstract Fig makeEdgeFig();

    public void paint(Graphics graphics) {
        this._fig.paint(graphics);
        this.paintArrowHeads(graphics);
        this.paintPathItems(graphics);
    }

    protected void paintArrowHeads(Graphics graphics) {
        this._arrowHeadStart.paintAtHead(graphics, this._fig);
        this._arrowHeadEnd.paintAtTail(graphics, this._fig);
    }

    public void paintHighlightLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Globals.getPrefs().getHighlightColor());
        double d = n3 - n;
        double d2 = n4 - n2;
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            return;
        }
        double d4 = d2 / d3;
        double d5 = -d / d3;
        double d6 = 2.0;
        while (d6 < 5.0) {
            int n5 = (int)((double)n + d6 * d4);
            int n6 = (int)((double)n2 + d6 * d5);
            int n7 = (int)((double)n3 + d6 * d4);
            int n8 = (int)((double)n4 + d6 * d5);
            graphics.drawLine(n5, n6, n7, n8);
            d6 += 0.27;
        }
    }

    protected void paintPathItems(Graphics graphics) {
        Vector vector = this.getPathItemsRaw();
        int n = 0;
        while (n < vector.size()) {
            PathItem pathItem = (PathItem)vector.elementAt(n);
            Fig fig = pathItem.getFig();
            fig.paint(graphics);
            ++n;
        }
    }

    public void postLoad() {
        this.setOwner(this.getOwner());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getSource();
        if (string.equals("dispose") && object == this.getOwner()) {
            this.delete();
        }
        if (string.equals("highlight") && object == this.getOwner()) {
            this._highlight = (Boolean)propertyChangeEvent.getNewValue();
            this.damage();
        }
    }

    public void removePathItem(PathItem pathItem) {
        this._pathItems.removeElement(pathItem);
        pathItem.getFig().setGroup(null);
    }

    public void setBetweenNearestPoints(boolean bl) {
        this._useNearest = bl;
    }

    public void setDashed(boolean bl) {
        this._fig.setDashed(bl);
    }

    public void setDestArrowHead(ArrowHead arrowHead) {
        this._arrowHeadEnd = arrowHead;
    }

    public void setDestFigNode(FigNode figNode) {
        if (this._destFigNode != null) {
            this._destFigNode.removeFigEdge(this);
        }
        this._destFigNode = figNode;
        figNode.addFigEdge(this);
    }

    public void setDestPortFig(Fig fig) {
        this._destPortFig = fig;
    }

    public void setFig(Fig fig) {
        if (this._fig != null && this._fig.getGroup() == this) {
            this._fig.setGroup(null);
        }
        this._fig = fig;
        this._fig.setGroup(this);
        this._fig.setLayer(this.getLayer());
    }

    public void setHighlight(boolean bl) {
        this._highlight = bl;
        this.damage();
    }

    public void setLineColor(Color color) {
        this._fig.setLineColor(color);
    }

    public void setLineWidth(int n) {
        this._fig.setLineWidth(n);
    }

    public void setNumPoints(int n) {
        this._fig.setNumPoints(n);
        this.calcBounds();
    }

    public void setOwner(Object object) {
        Object object2 = this.getOwner();
        if (object2 instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object2).removePropertyChangeListener(this);
        } else if (object2 instanceof Highlightable) {
            ((Highlightable)object2).removePropertyChangeListener(this);
        }
        if (object instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object).addPropertyChangeListener(this);
        } else if (object instanceof Highlightable) {
            ((Highlightable)object).addPropertyChangeListener(this);
        }
        super.setOwner(object);
    }

    public void setPoints(Point[] pointArray) {
        this._fig.setPoints(pointArray);
        this.calcBounds();
    }

    public void setPoints(int n, int n2, int n3) {
        this._fig.setPoints(n, n2, n3);
        this.calcBounds();
    }

    public void setPoints(Handle handle, int n, int n2) {
        this._fig.setPoints(handle, n, n2);
        this.calcBounds();
    }

    public void setPrivateData(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=\"' ");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2;
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("sourcePortFig")) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                continue;
            }
            if (string3.equals("destPortFig")) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                continue;
            }
            if (string3.equals("sourceFigNode")) {
                string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2);
                continue;
            }
            if (!string3.equals("destFigNode")) continue;
            string2 = stringTokenizer.nextToken();
            n = Integer.parseInt(string2);
        }
    }

    public void setSourceArrowHead(ArrowHead arrowHead) {
        this._arrowHeadStart = arrowHead;
    }

    public void setSourceFigNode(FigNode figNode) {
        if (this._sourceFigNode != null) {
            this._sourceFigNode.removeFigEdge(this);
        }
        this._sourceFigNode = figNode;
        figNode.addFigEdge(this);
    }

    public void setSourcePortFig(Fig fig) {
        this._sourcePortFig = fig;
    }

    public void setXs(int[] nArray) {
        this._fig.setXs(nArray);
        this.calcBounds();
    }

    public void setYs(int[] nArray) {
        this._fig.setYs(nArray);
        this.calcBounds();
    }

    public void stuffPointAlongPerimeter(int n, Point point) {
        this._fig.stuffPointAlongPerimeter(n, point);
    }

    public void translateEdge(int n, int n2) {
        this._fig.translate(n, n2);
        this.calcBounds();
    }

    public void updatePathItemLocations() {
        this.calcBounds();
    }

    public FigEdge() {
        this._fig = this.makeEdgeFig();
    }

    public FigEdge(Fig fig, Fig fig2, FigNode figNode, FigNode figNode2, Object object) {
        this.setSourcePortFig(fig);
        this.setDestPortFig(fig2);
        this.setSourceFigNode(figNode);
        this.setDestFigNode(figNode2);
        this.setOwner(object);
        this._fig = this.makeEdgeFig();
        this._fig.setGroup(this);
        this._fig.setLayer(this.getLayer());
    }

    protected class PathItem
    implements Serializable {
        Fig _fig;
        PathConv _path;

        PathConv getPath() {
            return this._path;
        }

        Fig getFig() {
            return this._fig;
        }

        PathItem(Fig fig, PathConv pathConv) {
            this._fig = fig;
            this._path = pathConv;
        }
    }
}

