/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JMenu;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Selection;
import org.tigris.gef.graph.GraphEdgeHooks;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.presentation.FigGroup;
import org.tigris.gef.presentation.Handle;
import org.tigris.gef.properties.PropCategoryManager;
import org.tigris.gef.ui.PopupGenerator;

public class Fig
implements Cloneable,
Serializable,
PropertyChangeListener,
PopupGenerator {
    public static String[] DASHED_CHOICES = new String[]{"Solid", "Dashed"};
    public static int[][] DASH_ARRAYS = new int[][]{null, {5}, {15, 5}, {3, 10}, {3, 6, 10, 6}};
    public final int MIN_SIZE;
    protected Layer _layer = null;
    protected boolean _locked = false;
    private Object _owner;
    protected int _x;
    protected int _y;
    protected int _w;
    protected int _h;
    protected Color _lineColor = Color.black;
    protected Color _fillColor = Color.white;
    protected int _lineWidth = 1;
    protected int[] _dashes = null;
    protected boolean _filled = true;
    protected Fig _group = null;
    public final int BORDER;

    public void addPoint(int n, int n2) {
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Globals.addPropertyChangeListener(this, propertyChangeListener);
    }

    public void align(Rectangle rectangle, int n, Editor editor) {
        Rectangle rectangle2 = this.getBounds();
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 = rectangle.y - rectangle2.y;
                break;
            }
            case 1: {
                n3 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
                break;
            }
            case 2: {
                n2 = rectangle.x - rectangle2.x;
                break;
            }
            case 3: {
                n2 = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
                break;
            }
            case 4: {
                n2 = rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2);
                n3 = rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2);
                break;
            }
            case 5: {
                n2 = rectangle.x + rectangle.width / 2 - (rectangle2.x + rectangle2.width / 2);
                break;
            }
            case 6: {
                n3 = rectangle.y + rectangle.height / 2 - (rectangle2.y + rectangle2.height / 2);
                break;
            }
            case 7: {
                Point point = this.getLocation();
                Point point2 = new Point(point.x, point.y);
                editor.snap(point2);
                n2 = point2.x - point.x;
                n3 = point2.y - point.y;
                break;
            }
        }
        this.translate(n2, n3);
    }

    public void calcBounds() {
    }

    public Point center() {
        Rectangle rectangle = this.getBounds();
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    public String classNameAndBounds() {
        return this.getClass().getName() + "[" + this.getX() + ", " + this.getY() + ", " + this.getWidth() + ", " + this.getHeight() + "]";
    }

    public void cleanUp() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Point connectionPoint(Point point) {
        Vector vector = this.getGravityPoints();
        if (vector != null && vector.size() > 0) {
            int n = point.x;
            int n2 = point.y;
            Point point2 = (Point)vector.elementAt(0);
            int n3 = Integer.MAX_VALUE;
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                Point point3 = (Point)vector.elementAt(n5);
                int n6 = point3.x - n;
                int n7 = point3.y - n2;
                int n8 = n6 * n6 + n7 * n7;
                if (n8 < n3) {
                    n3 = n8;
                    point2 = point3;
                }
                ++n5;
            }
            return new Point(point2.x, point2.y);
        }
        return this.getClosestPoint(point);
    }

    public boolean contains(int n, int n2) {
        return this._x <= n && n <= this._x + this._w && this._y <= n2 && n2 <= this._y + this._h;
    }

    public final boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        return this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height) == 4;
    }

    protected int countCornersContained(int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (this.contains(n, n2)) {
            ++n5;
        }
        if (this.contains(n + n3, n2)) {
            ++n5;
        }
        if (this.contains(n, n2 + n4)) {
            ++n5;
        }
        if (this.contains(n + n3, n2 + n4)) {
            ++n5;
        }
        return n5;
    }

    public void createDrag(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.min(n, n5);
        int n8 = Math.min(n2, n6);
        int n9 = Math.max(n, n5) - n7;
        int n10 = Math.max(n2, n6) - n8;
        this.setBounds(n7, n8, n9, n10);
    }

    public void damage() {
        if (this._layer != null) {
            this._layer.damaged(this);
        }
    }

    public Rectangle getHandleBox() {
        return this.getBounds();
    }

    public void setHandleBox(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public void delete() {
        if (this._layer != null) {
            this._layer.deleted(this);
        }
        this.setOwner(null);
    }

    public void dispose() {
        Object object = this.getOwner();
        if (object instanceof GraphNodeHooks) {
            ((GraphNodeHooks)object).dispose();
        }
        if (object instanceof GraphEdgeHooks) {
            ((GraphEdgeHooks)object).dispose();
        }
        if (object instanceof GraphPortHooks) {
            ((GraphPortHooks)object).dispose();
        } else {
            this.delete();
        }
    }

    protected int drawDashedLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = (n4 - n2) * (n4 - n2);
        int n7 = (n5 - n3) * (n5 - n3);
        int n8 = (int)Math.sqrt(n6 + n7);
        int n9 = this._dashes.length;
        int n10 = 0;
        int n11 = 0;
        while (n11 < n9) {
            n10 += this._dashes[n11];
            ++n11;
        }
        n11 = 0;
        int n12 = 0;
        while (n12 < n8) {
            int n13;
            int n14;
            int n15 = n2 + (n4 - n2) * n12 / n8;
            int n16 = n3 + (n5 - n3) * n12 / n8;
            n12 += this._dashes[n11];
            n11 = (n11 + 1) % n9;
            if (n12 >= n8) {
                n14 = n4;
                n13 = n5;
            } else {
                n14 = n2 + (n4 - n2) * n12 / n8;
                n13 = n3 + (n5 - n3) * n12 / n8;
            }
            graphics.drawLine(n15, n16, n14, n13);
            n12 += this._dashes[n11];
            n11 = (n11 + 1) % n9;
        }
        return (n8 + n) % n10;
    }

    protected void drawDashedPerimeter(Graphics graphics) {
        Point point = new Point();
        Point point2 = new Point();
        int n = this._dashes.length;
        int n2 = this.getPerimeterLength();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            this.stuffPointAlongPerimeter(n3, point);
            n3 += this._dashes[n4];
            n4 = (n4 + 1) % n;
            this.stuffPointAlongPerimeter(n3, point2);
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            n3 += this._dashes[n4];
            n4 = (n4 + 1) % n;
        }
    }

    public void endTrans() {
        this.damage();
    }

    protected void firePropChange(String string, int n, int n2) {
        this.firePropChange(string, new Integer(n), new Integer(n2));
    }

    protected void firePropChange(String string, Object object, Object object2) {
        Globals.firePropChange((Object)this, string, object, object2);
        if (this._group != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
            this._group.propertyChange(propertyChangeEvent);
        }
    }

    protected void firePropChange(String string, boolean bl, boolean bl2) {
        this.firePropChange(string, new Boolean(bl), new Boolean(bl2));
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._w, this._h);
    }

    public Point getClosestPoint(Point point) {
        return Geometry.ptClosestTo(this.getBounds(), point);
    }

    public boolean getDashed() {
        return this._dashes != null;
    }

    public int getDashed01() {
        return this.getDashed() ? 1 : 0;
    }

    public String getDashedString() {
        return this._dashes == null ? DASHED_CHOICES[0] : DASHED_CHOICES[1];
    }

    public Vector getEnclosedFigs() {
        return null;
    }

    public Fig getEnclosingFig() {
        return null;
    }

    public Color getFillColor() {
        return this._fillColor;
    }

    public boolean getFilled() {
        return this._filled;
    }

    public int getFilled01() {
        return this._filled ? 1 : 0;
    }

    public Point getFirstPoint() {
        return new Point();
    }

    public Vector getGravityPoints() {
        return null;
    }

    public Fig getGroup() {
        return this._group;
    }

    public int getHalfHeight() {
        return this._h / 2;
    }

    public int getHalfWidth() {
        return this._w / 2;
    }

    public int getHeight() {
        return this._h;
    }

    public String getId() {
        if (this.getGroup() != null) {
            String string = this.getGroup().getId();
            if (this.getGroup() instanceof FigGroup) {
                return string + "." + ((FigGroup)this.getGroup()).getFigs().indexOf(this);
            }
            return string + ".1";
        }
        Layer layer = this.getLayer();
        if (layer == null) {
            return "LAYER_NULL";
        }
        Vector vector = layer.getContents();
        int n = vector.indexOf(this);
        return "Fig" + n;
    }

    public Point getLastPoint() {
        return new Point();
    }

    public Layer getLayer() {
        return this._layer;
    }

    public Color getLineColor() {
        return this._lineColor;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public Point getLocation() {
        return new Point(this._x, this._y);
    }

    public boolean getLocked() {
        return this._locked;
    }

    public Dimension getMinimumSize() {
        return new Dimension(4, 4);
    }

    public int getNumPoints() {
        return 0;
    }

    public Object getOwner() {
        return this._owner;
    }

    public int getPerimeterLength() {
        return this._w + this._w + this._h + this._h;
    }

    public Point[] getPoints() {
        return new Point[0];
    }

    public Point getPoints(int n) {
        return null;
    }

    public Vector getPopUpActions(MouseEvent mouseEvent) {
        Vector<JMenu> vector = new Vector<JMenu>();
        JMenu jMenu = new JMenu("Ordering");
        jMenu.add(CmdReorder.BringForward);
        jMenu.add(CmdReorder.SendBackward);
        jMenu.add(CmdReorder.BringToFront);
        jMenu.add(CmdReorder.SendToBack);
        vector.addElement(jMenu);
        return vector;
    }

    public Dimension getPreferedSize() {
        return new Dimension(this._w, this._h);
    }

    public String getPrivateData() {
        return "";
    }

    public Dimension getSize() {
        return new Dimension(this._w, this._h);
    }

    public String getTipString(MouseEvent mouseEvent) {
        return this.toString();
    }

    public Rectangle getTrapRect() {
        return this.getBounds();
    }

    public boolean getUseTrapRect() {
        return false;
    }

    public int getWidth() {
        return this._w;
    }

    public int getX() {
        return this._x;
    }

    public int[] getXs() {
        return new int[0];
    }

    public int getY() {
        return this._y;
    }

    public int[] getYs() {
        return new int[0];
    }

    public boolean hit(Rectangle rectangle) {
        int n = this.countCornersContained(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this._filled) {
            return n > 0;
        }
        return n > 0 && n < 4;
    }

    public void insertPoint(int n, int n2, int n3) {
    }

    public boolean intersects(Rectangle rectangle) {
        return !(rectangle.x + rectangle.width <= this._x || rectangle.y + rectangle.height <= this._y || rectangle.x >= this._x + this._w || rectangle.y >= this._y + this._h);
    }

    public boolean isLowerRightResizable() {
        return false;
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isReshapable() {
        return false;
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isRotatable() {
        return false;
    }

    public Selection makeSelection() {
        return null;
    }

    public boolean OK() {
        return this._lineWidth >= 0 && this._lineColor != null && this._fillColor != null;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.pink);
        graphics.fillRect(this._x, this._y, this._w, this._h);
        graphics.setColor(Color.black);
        graphics.drawString("(undefined)", this._x + this._w / 2, this._y + this._h / 2);
    }

    public Point pointAlongPerimeter(int n) {
        Point point = new Point();
        this.stuffPointAlongPerimeter(n, point);
        return point;
    }

    public void postLoad() {
    }

    public void postSave() {
    }

    public void preSave() {
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this._group != null) {
            this._group.propertyChange(propertyChangeEvent);
        }
    }

    public void removePoint(int n) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Globals.removePropertyChangeListener(this, propertyChangeListener);
    }

    public void reorder(int n, Layer layer) {
        layer.reorder(this, n);
    }

    public Rectangle routingRect() {
        return new Rectangle(this._x - 8, this._y - 8, this._w + 16, this._h + 16);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.getBounds();
        this._x = n;
        this._y = n2;
        this._w = n3;
        this._h = n4;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public final void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setDashed(boolean bl) {
        this._dashes = (int[])(bl ? DASH_ARRAYS[1] : null);
    }

    public void setDashedString(String string) {
        this._dashes = (int[])(string.equalsIgnoreCase("solid") ? null : DASH_ARRAYS[1]);
    }

    public void setEnclosingFig(Fig fig) {
        if (fig != null && fig != this.getEnclosingFig() && this._layer != null) {
            this._layer.bringInFrontOf(this, fig);
            this.damage();
        }
    }

    public void setFillColor(Color color) {
        if (color != null) {
            this.firePropChange("fillColor", this._fillColor, color);
            this._fillColor = color;
        } else {
            this.firePropChange("filled", this._filled, false);
            this._filled = false;
        }
    }

    public void setFilled(boolean bl) {
        this.firePropChange("filled", this._filled, bl);
        this._filled = bl;
    }

    public void setGroup(Fig fig) {
        this._group = fig;
    }

    public void setHeight(int n) {
        this.setBounds(this._x, this._y, this._w, n);
    }

    public void setLayer(Layer layer) {
        this.firePropChange("layer", this._layer, layer);
        this._layer = layer;
    }

    public void setLineColor(Color color) {
        if (color != null) {
            this.firePropChange("lineColor", this._lineColor, color);
            this._lineColor = color;
        } else {
            this.firePropChange("lineWidth", this._lineWidth, 0);
            this._lineWidth = 0;
        }
    }

    public void setLineWidth(int n) {
        int n2 = Math.max(0, Math.min(1, n));
        this.firePropChange("lineWidth", this._lineWidth, n2);
        this._lineWidth = n2;
    }

    public void setLocation(int n, int n2) {
        this.translate(n - this._x, n2 - this._y);
    }

    public final void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setLocked(boolean bl) {
        this.firePropChange("locked", this._locked, bl);
        this._locked = bl;
    }

    public void setNumPoints(int n) {
    }

    public void setOwner(Object object) {
        this.firePropChange("owner", this._owner, object);
        this._owner = object;
    }

    public void setPoints(Point[] pointArray) {
    }

    public void setPoints(int n, int n2, int n3) {
    }

    public final void setPoints(int n, Point point) {
        this.setPoints(n, point.x, point.y);
    }

    public void setPoints(Handle handle, int n, int n2) {
        this.setPoints(handle.index, n, n2);
    }

    public final void setPoints(Handle handle, Point point) {
        this.setPoints(handle, point.x, point.y);
    }

    public void setPrivateData(String string) {
    }

    public void setSize(int n, int n2) {
        this.setBounds(this._x, this._y, n, n2);
    }

    public final void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setWidth(int n) {
        this.setBounds(this._x, this._y, n, this._h);
    }

    public void setX(int n) {
        this.setBounds(n, this._y, this._w, this._h);
    }

    public void setXs(int[] nArray) {
    }

    public void setY(int n) {
        this.setBounds(this._x, n, this._w, this._h);
    }

    public void setYs(int[] nArray) {
    }

    public void startTrans() {
        this.damage();
    }

    public void stuffBounds(Rectangle rectangle) {
        rectangle.setBounds(this._x, this._y, this._w, this._h);
    }

    public void stuffPointAlongPerimeter(int n, Point point) {
        if (n < this._w && n >= 0) {
            point.x = this._x + n;
            point.y = this._y;
        } else if (n < this._w + this._h) {
            point.x = this._x + this._w;
            point.y = this._y + (n - this._w);
        } else if (n < this._w + this._h + this._w) {
            point.x = this._x + this._w - (n - this._w - this._h);
            point.y = this._y + this._h;
        } else if (n < this._w + this._h + this._w + this._h) {
            point.x = this._x;
            point.y = this._y + (this._w + this._h + this._w + this._h - n);
        } else {
            point.x = this._x;
            point.y = this._y;
        }
    }

    public void translate(int n, int n2) {
        Rectangle rectangle = this.getBounds();
        this._x += n;
        this._y += n2;
        this.firePropChange("bounds", rectangle, this.getBounds());
    }

    public boolean within(Rectangle rectangle) {
        return rectangle.contains(this._x, this._y) && rectangle.contains(this._x + this._w, this._y + this._h);
    }

    public Fig() {
        this.MIN_SIZE = 4;
        this.BORDER = 8;
    }

    public Fig(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, Color.black, Color.white, null);
    }

    public Fig(int n, int n2, int n3, int n4, Color color, Color color2) {
        this(n, n2, n3, n4, color, color2, null);
    }

    public Fig(int n, int n2, int n3, int n4, Color color, Color color2, Object object) {
        this.MIN_SIZE = 4;
        this.BORDER = 8;
        this._x = n;
        this._y = n2;
        this._w = n3;
        this._h = n4;
        if (color != null) {
            this._lineColor = color;
        } else {
            this._lineWidth = 0;
        }
        if (color2 != null) {
            this._fillColor = color2;
        } else {
            this._filled = false;
        }
        this.setOwner(object);
    }

    static {
        PropCategoryManager.categorizeProperty("Geometry", "x");
        PropCategoryManager.categorizeProperty("Geometry", "y");
        PropCategoryManager.categorizeProperty("Geometry", "width");
        PropCategoryManager.categorizeProperty("Geometry", "height");
        PropCategoryManager.categorizeProperty("Geometry", "filled");
        PropCategoryManager.categorizeProperty("Geometry", "locked");
        PropCategoryManager.categorizeProperty("Style", "lineWidth");
        PropCategoryManager.categorizeProperty("Style", "fillColor");
        PropCategoryManager.categorizeProperty("Style", "lineColor");
        PropCategoryManager.categorizeProperty("Style", "filled");
    }
}

