/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphPortHooks;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPrimitive;

public class NetPort
extends NetPrimitive
implements GraphPortHooks,
Serializable {
    public static String DEFAULT_EDGE_CLASS = "org.tigris.gef.graph.presentation.NetEdge";
    protected Vector _edges;
    protected Object _parent;

    public String getId() {
        return this.toString();
    }

    public NetNode getParentNode() {
        return (NetNode)this._parent;
    }

    public NetEdge getParentEdge() {
        return (NetEdge)this._parent;
    }

    public Object getParent() {
        return this._parent;
    }

    public Vector getEdges() {
        return this._edges;
    }

    public void addEdge(NetEdge netEdge) {
        this._edges.addElement(netEdge);
    }

    public void removeEdge(NetEdge netEdge) {
        this._edges.removeElement(netEdge);
    }

    public void dispose() {
        Enumeration enumeration = this._edges.elements();
        while (enumeration.hasMoreElements()) {
            NetEdge netEdge = (NetEdge)enumeration.nextElement();
            netEdge.dispose();
        }
        this.firePropertyChange("disposed", false, true);
    }

    public void postConnect(GraphModel graphModel, Object object) {
        NetPort netPort = (NetPort)object;
        NetNode netNode = this.getParentNode();
        netNode.postConnect(graphModel, netPort.getParentNode(), this, netPort);
    }

    public void postDisconnect(GraphModel graphModel, Object object) {
        NetPort netPort = (NetPort)object;
        NetNode netNode = this.getParentNode();
        netNode.postDisconnect(graphModel, netPort.getParentNode(), this, netPort);
    }

    protected Class defaultEdgeClass(NetPort netPort) {
        try {
            return Class.forName(DEFAULT_EDGE_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public NetEdge makeEdgeFor(NetPort netPort) {
        NetEdge netEdge;
        Class clazz = this.defaultEdgeClass(netPort);
        if (clazz == null) {
            System.out.println("defaultEdgeClass is null");
            return null;
        }
        try {
            netEdge = (NetEdge)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("asdasd");
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.out.println("ASdasd");
            return null;
        }
        return netEdge;
    }

    public boolean canConnectTo(GraphModel graphModel, Object object) {
        NetNode netNode = this.getParentNode();
        NetNode netNode2 = ((NetPort)object).getParentNode();
        return netNode.canConnectTo(graphModel, netNode2, object, this);
    }

    public NetPort(Object object) {
        this._parent = object;
        this._edges = new Vector();
    }
}

