/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.presentation.NetPort;
import org.tigris.gef.graph.presentation.NetPrimitive;
import org.tigris.gef.presentation.FigNode;

public abstract class NetNode
extends NetPrimitive
implements GraphNodeHooks,
Serializable {
    protected Vector _ports;

    public abstract void initialize(Hashtable var1);

    public Object getAttributes() {
        return null;
    }

    public NetPort getPort(int n) {
        return (NetPort)this._ports.elementAt(n);
    }

    public Vector getPorts() {
        return this._ports;
    }

    public void setPorts(Vector vector) {
        this._ports = vector;
    }

    public void addPort(NetPort netPort) {
        this._ports.addElement(netPort);
    }

    public void dispose() {
        Enumeration enumeration = this._ports.elements();
        while (enumeration.hasMoreElements()) {
            ((NetPort)enumeration.nextElement()).dispose();
        }
        this.firePropertyChange("disposed", false, true);
    }

    public FigNode presentationFor(Layer layer) {
        FigNode figNode;
        if (layer != null && (figNode = (FigNode)layer.presentationFor(this)) != null) {
            return figNode;
        }
        figNode = this.makePresentation(layer);
        return figNode;
    }

    public abstract FigNode makePresentation(Layer var1);

    public void postConnect(GraphModel graphModel, Object object, Object object2, Object object3) {
    }

    public void postDisconnect(GraphModel graphModel, Object object, Object object2, Object object3) {
    }

    public boolean canConnectTo(GraphModel graphModel, Object object, Object object2, Object object3) {
        return true;
    }

    public void postPlacement(Editor editor) {
    }

    public NetNode(NetNode netNode, Vector vector) {
        this._ports = vector;
    }

    public NetNode() {
        this(null, new Vector());
    }
}

