/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import org.tigris.gef.base.Editor;

class JGraphInternalPane
extends JPanel {
    protected Editor _editor;

    public void paintComponent(Graphics graphics) {
        this._editor.paint(graphics);
    }

    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (graphics == null) {
            return graphics;
        }
        Container container = this.getParent();
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            Rectangle rectangle = jViewport.getBounds();
            Point point = jViewport.getViewPosition();
            graphics.clipRect(rectangle.x + point.x - 1, rectangle.y + point.y - 1, rectangle.width + 1, rectangle.height + 1);
        }
        return graphics;
    }

    public void setToolTipText(String string) {
        if ("".equals(string)) {
            string = null;
        }
        this.putClientProperty("ToolTipText", string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public JGraphInternalPane(Editor editor) {
        this._editor = editor;
        this.setLayout(null);
        this.setDoubleBuffered(false);
    }
}

