/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.tigris.gef.base.CmdGroup;
import org.tigris.gef.base.CmdNudge;
import org.tigris.gef.base.CmdReorder;
import org.tigris.gef.base.CmdSelectNear;
import org.tigris.gef.base.CmdSelectNext;
import org.tigris.gef.base.CmdUngroup;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.JGraphInternalPane;
import org.tigris.gef.presentation.Fig;

public class JGraph
extends JPanel
implements Cloneable {
    protected Editor _editor;
    protected JGraphInternalPane _drawingPane;
    protected JScrollPane _scroll;

    public void addMouseListener(MouseListener mouseListener) {
        this._drawingPane.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this._drawingPane.addMouseMotionListener(mouseMotionListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this._drawingPane.addKeyListener(keyListener);
    }

    public Object clone() {
        JGraph jGraph = new JGraph((Editor)this._editor.clone());
        return jGraph;
    }

    public void initKeys() {
        int n = 1;
        int n2 = 2;
        int n3 = 3;
        int n4 = 8;
        int n5 = 4;
        this.bindKey(new CmdSelectNext(true), 9, 0);
        this.bindKey(new CmdSelectNext(false), 9, n);
        this.bindKey(new CmdGroup(), 71, n2);
        this.bindKey(new CmdUngroup(), 85, n2);
        this.bindKey(new CmdReorder(3), 66, n2);
        this.bindKey(new CmdReorder(4), 70, n2);
        this.bindKey(new CmdReorder(1), 66, n3);
        this.bindKey(new CmdReorder(2), 70, n3);
        this.bindKey(new CmdNudge(1), 37, 0);
        this.bindKey(new CmdNudge(2), 39, 0);
        this.bindKey(new CmdNudge(3), 38, 0);
        this.bindKey(new CmdNudge(4), 40, 0);
        this.bindKey(new CmdNudge(1, 8), 37, n);
        this.bindKey(new CmdNudge(2, 8), 39, n);
        this.bindKey(new CmdNudge(3, 8), 38, n);
        this.bindKey(new CmdNudge(4, 8), 40, n);
        this.bindKey(new CmdNudge(1, 18), 37, n4);
        this.bindKey(new CmdNudge(2, 18), 39, n4);
        this.bindKey(new CmdNudge(3, 18), 38, n4);
        this.bindKey(new CmdNudge(4, 18), 40, n4);
        this.bindKey(new CmdSelectNear(1), 37, n5);
        this.bindKey(new CmdSelectNear(2), 39, n5);
        this.bindKey(new CmdSelectNear(3), 38, n5);
        this.bindKey(new CmdSelectNear(4), 40, n5);
    }

    public void bindKey(ActionListener actionListener, int n, int n2) {
        this._drawingPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(n, n2), 0);
    }

    public Editor getEditor() {
        return this._editor;
    }

    public void setDiagram(Diagram diagram) {
        if (diagram == null) {
            return;
        }
        this._editor.getLayerManager().replaceActiveLayer(diagram.getLayer());
        this._editor.setGraphModel(diagram.getGraphModel());
        this._editor.getSelectionManager().deselectAll();
        this._editor.damageAll();
    }

    public void setDrawingSize(int n, int n2) {
        this._drawingPane.setPreferredSize(new Dimension(n, n2));
    }

    public void setGraphModel(GraphModel graphModel) {
        this._editor.setGraphModel(graphModel);
    }

    public GraphModel getGraphModel() {
        return this._editor.getGraphModel();
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this._editor.setGraphNodeRenderer(graphNodeRenderer);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this._editor.getGraphNodeRenderer();
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this._editor.setGraphEdgeRenderer(graphEdgeRenderer);
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this._editor.getGraphEdgeRenderer();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this._drawingPane.setVisible(bl);
        this._editor.setActiveTextEditor(null);
    }

    public boolean isManagingFocus() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.getEditor().addGraphSelectionListener(graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.getEditor().removeGraphSelectionListener(graphSelectionListener);
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this.getEditor().addModeChangeListener(modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this.getEditor().removeModeChangeListener(modeChangeListener);
    }

    public void layoutGraph() {
    }

    public void select(Fig fig) {
        if (fig == null) {
            this.deselectAll();
        } else {
            this._editor.getSelectionManager().select(fig);
        }
    }

    public void selectByOwner(Object object) {
        Layer layer = this._editor.getLayerManager().getActiveLayer();
        if (layer instanceof LayerDiagram) {
            this.select(((LayerDiagram)layer).presentationFor(object));
        }
    }

    public void selectByOwnerOrFig(Object object) {
        if (object instanceof Fig) {
            this.select((Fig)object);
        } else {
            this.selectByOwner(object);
        }
    }

    public void selectByOwnerOrNoChange(Object object) {
        Fig fig;
        Layer layer = this._editor.getLayerManager().getActiveLayer();
        if (layer instanceof LayerDiagram && (fig = ((LayerDiagram)layer).presentationFor(object)) != null) {
            this.select(fig);
        }
    }

    public void deselect(Fig fig) {
        this._editor.getSelectionManager().deselect(fig);
    }

    public void toggleItem(Fig fig) {
        this._editor.getSelectionManager().toggle(fig);
    }

    public void deselectAll() {
        this._editor.getSelectionManager().deselectAll();
    }

    public void select(Vector vector) {
        this._editor.getSelectionManager().select(vector);
    }

    public void toggleItems(Vector vector) {
        this._editor.getSelectionManager().toggle(vector);
    }

    public Vector selectedFigs() {
        return this._editor.getSelectionManager().getFigs();
    }

    public JGraph() {
        this(new DefaultGraphModel());
    }

    public JGraph(Diagram diagram) {
        this(new Editor(diagram));
    }

    public JGraph(GraphModel graphModel) {
        this(new Editor(graphModel, null));
    }

    public JGraph(Editor editor) {
        super(false);
        this._editor = editor;
        this._drawingPane = new JGraphInternalPane(this._editor);
        this.setDrawingSize(1500, 1500);
        this._scroll = new JScrollPane(this._drawingPane);
        this._scroll.setBorder(null);
        this._scroll.getHorizontalScrollBar().setUnitIncrement(25);
        this._scroll.getVerticalScrollBar().setUnitIncrement(25);
        this._editor.setAwtComponent(this._drawingPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this._scroll, "Center");
        this.addMouseListener(this._editor);
        this.addMouseMotionListener(this._editor);
        this.addKeyListener(this._editor);
        this.initKeys();
        this.validate();
    }
}

