/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.io.Serializable;
import java.util.Vector;
import org.tigris.gef.graph.MutableGraphSupport;
import org.tigris.gef.graph.presentation.NetEdge;
import org.tigris.gef.graph.presentation.NetList;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.graph.presentation.NetPort;

public class DefaultGraphModel
extends MutableGraphSupport
implements Serializable {
    protected NetList _netList;

    public NetList getNetList() {
        return this._netList;
    }

    public void setNetList(NetList netList) {
        this._netList = netList;
    }

    public boolean OK() {
        return this._netList != null;
    }

    public Vector getNodes() {
        return this._netList.getNodes();
    }

    public Vector getEdges() {
        return this._netList.getEdges();
    }

    public Vector getPorts(Object object) {
        if (object instanceof NetNode) {
            return ((NetNode)object).getPorts();
        }
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getPorts();
        }
        return null;
    }

    public Object getOwner(Object object) {
        if (object instanceof NetPort) {
            return ((NetPort)object).getParent();
        }
        return null;
    }

    public Vector getInEdges(Object object) {
        if (object instanceof NetPort) {
            return ((NetPort)object).getEdges();
        }
        return null;
    }

    public Vector getOutEdges(Object object) {
        if (object instanceof NetPort) {
            return ((NetPort)object).getEdges();
        }
        return null;
    }

    public Object getSourcePort(Object object) {
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getSourcePort();
        }
        return null;
    }

    public Object getDestPort(Object object) {
        if (object instanceof NetEdge) {
            return ((NetEdge)object).getDestPort();
        }
        return null;
    }

    public boolean canAddNode(Object object) {
        return object instanceof NetNode;
    }

    public boolean canAddEdge(Object object) {
        return object instanceof NetEdge;
    }

    public void removeNode(Object object) {
        NetNode netNode = (NetNode)object;
        this._netList.removeNode(netNode);
        this.fireNodeRemoved(netNode);
    }

    public void addNode(Object object) {
        NetNode netNode = (NetNode)object;
        this._netList.addNode(netNode);
        this.fireNodeAdded(netNode);
    }

    public void addEdge(Object object) {
        NetEdge netEdge = (NetEdge)object;
        this._netList.addEdge(netEdge);
        this.fireEdgeAdded(netEdge);
    }

    public void addNodeRelatedEdges(Object object) {
    }

    public void removeEdge(Object object) {
        NetEdge netEdge = (NetEdge)object;
        this._netList.removeEdge(netEdge);
        this.fireEdgeRemoved(netEdge);
    }

    public boolean canConnect(Object object, Object object2) {
        if (object instanceof NetPort && object2 instanceof NetPort) {
            NetPort netPort = (NetPort)object;
            NetPort netPort2 = (NetPort)object2;
            return netPort.canConnectTo(this, netPort2) && netPort2.canConnectTo(this, netPort);
        }
        return false;
    }

    public boolean canConnect(Object object, Object object2, Class clazz) {
        return this.canConnect(object, object2);
    }

    public Object connect(Object object, Object object2) {
        if (!this.canConnect(object, object2)) {
            return null;
        }
        if (object instanceof NetPort && object2 instanceof NetPort) {
            NetPort netPort = (NetPort)object;
            NetPort netPort2 = (NetPort)object2;
            NetEdge netEdge = netPort.makeEdgeFor(netPort2);
            return this.connectInternal(netPort, netPort2, netEdge);
        }
        return null;
    }

    public Object connect(Object object, Object object2, Class clazz) {
        if (!this.canConnect(object, object2)) {
            System.out.println("illegal connection");
            return null;
        }
        if (object instanceof NetPort && object2 instanceof NetPort) {
            NetPort netPort = (NetPort)object;
            NetPort netPort2 = (NetPort)object2;
            try {
                NetEdge netEdge = (NetEdge)clazz.newInstance();
                return this.connectInternal(netPort, netPort2, netEdge);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    protected Object connectInternal(NetPort netPort, NetPort netPort2, NetEdge netEdge) {
        System.out.println("connectInternal");
        netEdge.connect(this, netPort, netPort2);
        this.addEdge(netEdge);
        return netEdge;
    }

    public DefaultGraphModel() {
        this._netList = new NetList();
    }

    public DefaultGraphModel(NetList netList) {
        this._netList = netList;
    }
}

