/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.graph.GraphEvent;
import org.tigris.gef.graph.GraphListener;
import org.tigris.gef.graph.MutableGraphModel;

public abstract class MutableGraphSupport
implements MutableGraphModel,
Serializable {
    protected Vector _graphListeners;

    public Vector getGraphListeners() {
        return this._graphListeners;
    }

    public boolean canConnect(Object object, Object object2, Class clazz) {
        return this.canConnect(object, object2);
    }

    public Object connect(Object object, Object object2, Class clazz) {
        return this.connect(object, object2);
    }

    public boolean containsNode(Object object) {
        Vector vector = this.getNodes();
        return vector.contains(object);
    }

    public boolean containsEdge(Object object) {
        Vector vector = this.getEdges();
        return vector.contains(object);
    }

    public boolean containsNodePort(Object object) {
        Vector vector = this.getNodes();
        if (vector == null) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Vector vector2 = this.getPorts(e);
            if (vector2 == null || !vector2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEdgePort(Object object) {
        Vector vector = this.getNodes();
        if (vector == null) {
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Vector vector2 = this.getPorts(e);
            if (vector2 == null || !vector2.contains(object)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPort(Object object) {
        return this.containsNodePort(object) || this.containsEdgePort(object);
    }

    public void addGraphEventListener(GraphListener graphListener) {
        if (this._graphListeners == null) {
            this._graphListeners = new Vector();
        }
        this._graphListeners.addElement(graphListener);
    }

    public void removeGraphEventListener(GraphListener graphListener) {
        if (this._graphListeners == null) {
            return;
        }
        this._graphListeners.removeElement(graphListener);
    }

    public void fireNodeAdded(Object object) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            GraphListener graphListener = (GraphListener)enumeration.nextElement();
            graphListener.nodeAdded(graphEvent);
        }
    }

    public void fireNodeRemoved(Object object) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            GraphListener graphListener = (GraphListener)enumeration.nextElement();
            graphListener.nodeRemoved(graphEvent);
        }
    }

    public void fireEdgeAdded(Object object) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            GraphListener graphListener = (GraphListener)enumeration.nextElement();
            graphListener.edgeAdded(graphEvent);
        }
    }

    public void fireEdgeRemoved(Object object) {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, object);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            GraphListener graphListener = (GraphListener)enumeration.nextElement();
            graphListener.edgeRemoved(graphEvent);
        }
    }

    public void fireGraphChanged() {
        if (this._graphListeners == null) {
            return;
        }
        GraphEvent graphEvent = new GraphEvent(this, null);
        Enumeration enumeration = this._graphListeners.elements();
        while (enumeration.hasMoreElements()) {
            GraphListener graphListener = (GraphListener)enumeration.nextElement();
            graphListener.graphChanged(graphEvent);
        }
    }

    public abstract boolean canAddNode(Object var1);

    public abstract boolean canAddEdge(Object var1);

    public abstract void removeNode(Object var1);

    public abstract void addNode(Object var1);

    public abstract void addEdge(Object var1);

    public abstract void addNodeRelatedEdges(Object var1);

    public abstract void removeEdge(Object var1);

    public abstract boolean canConnect(Object var1, Object var2);

    public abstract Object connect(Object var1, Object var2);

    public abstract Vector getNodes();

    public abstract Vector getEdges();

    public abstract Vector getPorts(Object var1);

    public abstract Object getOwner(Object var1);

    public abstract Vector getInEdges(Object var1);

    public abstract Vector getOutEdges(Object var1);

    public abstract Object getSourcePort(Object var1);

    public abstract Object getDestPort(Object var1);
}

