/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.demo;

import java.awt.Color;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.Layer;
import org.tigris.gef.demo.PortData;
import org.tigris.gef.demo.PortPower;
import org.tigris.gef.graph.presentation.NetNode;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigImage;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigRRect;
import org.tigris.gef.presentation.FigRect;

public class NodeCPU
extends NetNode
implements Serializable {
    public static final String pMEGS_OF_RAM = "Megs Of RAM";
    public static final String pBUS_SPEED_MHZ = "Bus Speed Mhz";
    public static final String pCPU_SPEED_MHZ = "CPU Speed Mhz";
    public static final String pHAS_CD_ROM = "Has CD ROM";
    public static final String pOWNER_INFO = "Owner";
    protected int _megsOfRAM = 16;
    protected int _busSpeedMHz = 25;
    protected int _cpuSpeedMHz = 100;
    protected boolean _hasCDROM = true;
    protected String _ownerInfo = "Your Name Here\nYour Company\nYour Address Line1\nYour Address Line 2";
    PortPower powerPort;
    PortData dataPort;

    public void initialize(Hashtable hashtable) {
        this.powerPort = new PortPower(this, 2);
        this.addPort(this.powerPort);
        this.dataPort = new PortData(this);
        this.addPort(this.dataPort);
    }

    public String getId() {
        return this.toString();
    }

    public int getMegsOfRAM() {
        return this._megsOfRAM;
    }

    public int getBusSpeedMHz() {
        return this._busSpeedMHz;
    }

    public int getCPUSpeedMhz() {
        return this._cpuSpeedMHz;
    }

    public boolean getHasCDROM() {
        return this._hasCDROM;
    }

    public String getOwnerInfo() {
        return this._ownerInfo;
    }

    public void setMegsOfRAM(int n) {
        if (n % 8 == 0) {
            this._megsOfRAM = n;
        }
    }

    public void setBusSpeedMHz(int n) {
        if (n % 25 == 0 || n % 33 == 0) {
            this._busSpeedMHz = n;
        }
    }

    public void setCPUSpeedMhz(int n) {
        if (n == 25 || n == 33 || n == 50 || n == 66 || n == 75 || n == 90 || n == 100 || n == 120 || n == 133 || n == 150 || n == 166 || n == 200 || n == 233) {
            this._cpuSpeedMHz = n;
        }
    }

    public void setHasCDROM(boolean bl) {
        this._hasCDROM = bl;
    }

    public void setOwnerInfo(String string) {
        this._ownerInfo = string;
    }

    public FigNode makePresentation(Layer layer) {
        URL uRL = null;
        try {
            uRL = new URL("http://www.ics.uci.edu/~jrobbins/images/cpu.gif");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        FigImage figImage = new FigImage(0, 0, uRL);
        int n = figImage.getWidth();
        FigRect figRect = new FigRect(2, -7, 14, 14, Color.black, Color.white);
        FigRRect figRRect = new FigRRect(n - 4, 10, 8, 15, Color.black, Color.black);
        figRRect.setCornerRadius(3);
        Vector<Fig> vector = new Vector<Fig>();
        vector.addElement(figImage);
        vector.addElement(figRect);
        vector.addElement(figRRect);
        FigNode figNode = new FigNode(this, vector);
        figNode.bindPort(this.powerPort, figRect);
        figNode.bindPort(this.dataPort, figRRect);
        return figNode;
    }

    static {
        Vector<Integer> vector = new Vector<Integer>();
        vector.addElement(new Integer(25));
        vector.addElement(new Integer(33));
        vector.addElement(new Integer(66));
        vector.addElement(new Integer(75));
        vector.addElement(new Integer(90));
        vector.addElement(new Integer(100));
        vector.addElement(new Integer(120));
        vector.addElement(new Integer(133));
        vector.addElement(new Integer(150));
        vector.addElement(new Integer(166));
        vector.addElement(new Integer(200));
        vector.addElement(new Integer(233));
    }
}

