/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.demo;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.CmdAdjustGrid;
import org.tigris.gef.base.CmdCreateNode;
import org.tigris.gef.base.CmdDelete;
import org.tigris.gef.base.CmdDispose;
import org.tigris.gef.base.CmdExit;
import org.tigris.gef.base.CmdOpen;
import org.tigris.gef.base.CmdSave;
import org.tigris.gef.base.CmdShowProperties;
import org.tigris.gef.base.CmdSpawn;
import org.tigris.gef.base.Globals;
import org.tigris.gef.demo.SamplePalette;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.JGraph;
import org.tigris.gef.ui.PaletteFig;

public class FlexibleApplet
extends Applet {
    protected static boolean _spawnFrame = true;
    protected static int _drawAreaWidth = 400;
    protected static int _drawAreaHeight = 300;
    protected static String _loadDocument;
    private GraphModel gm;
    SamplePalette palette;
    PaletteFig shapePalette;
    private static /* synthetic */ Class class$Lorg$tigris$gef$demo$SampleNode;

    public static void main(String[] stringArray) {
        FlexibleApplet flexibleApplet = new FlexibleApplet();
        flexibleApplet.init();
    }

    public static void parseParams(Applet applet) {
        String string;
        _drawAreaWidth = 400;
        _drawAreaHeight = 300;
        _spawnFrame = "true".equals(applet.getParameter("SpawnFrame"));
        String string2 = applet.getParameter("DrawAreaWidth");
        if (string2 != null) {
            _drawAreaWidth = Integer.parseInt(string2);
        }
        if ((string = applet.getParameter("DrawAreaHeight")) != null) {
            _drawAreaHeight = Integer.parseInt(string);
        }
        _loadDocument = applet.getParameter("LoadDocument");
        System.out.println("SpawnFrame= " + _spawnFrame);
        System.out.println("DrawArea= " + _drawAreaWidth + " by " + _drawAreaHeight);
        System.out.println("LoadDocument= " + _loadDocument);
    }

    public void initWindows() {
        Dimension dimension = new Dimension(_drawAreaWidth, _drawAreaHeight);
        JGraph jGraph = new JGraph(this.gm);
        jGraph.setSize(dimension);
        jGraph.setPreferredSize(dimension);
        if (_spawnFrame) {
            System.out.println("spawning frame");
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add((Component)this.palette, "North");
            jFrame.getContentPane().add((Component)jGraph, "Center");
            ((Component)jFrame).setSize(dimension);
            jFrame.show();
        } else {
            this.add("North", this.palette);
            this.add("Center", jGraph);
        }
    }

    public void start() {
    }

    public void init() {
        Globals.setApplet(this);
        this.gm = new DefaultGraphModel();
        this.palette = new SamplePalette();
        this.shapePalette = new PaletteFig();
        FlexibleApplet.parseParams(this);
        this.initWindows();
        Cmd.register(new CmdSave());
        Cmd.register(new CmdOpen());
        Cmd.register(new CmdDispose());
        Cmd.register(new CmdDelete());
        Cmd.register(new CmdSpawn());
        Cmd.register(new CmdAdjustGrid());
        Cmd.register(new CmdShowProperties());
        Cmd.register(new CmdCreateNode(class$Lorg$tigris$gef$demo$SampleNode != null ? class$Lorg$tigris$gef$demo$SampleNode : (class$Lorg$tigris$gef$demo$SampleNode = FlexibleApplet.class$("org.tigris.gef.demo.SampleNode")), "Sample Node"));
        Cmd.register(new CmdExit());
    }

    public void stop() {
    }

    public void destroy() {
        this.gm = null;
        this.palette = null;
        this.shapePalette = null;
    }

    public String getAppletInfo() {
        return "GEF (the Graph Editing Framework) example editor applet. \n" + "FlexibleApplet a very simple demonstration of how GEF can \n" + "be used. " + "\n\n" + "Author: Jason Robbins\n" + "Copyright (c) 1996-1998 Regents of the University of California.\n" + "All rights reserved.\n\n";
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[5][3];
        stringArray[0][0] = "LoadDocument";
        stringArray[0][1] = "java.lang.String\n";
        stringArray[0][2] = "If supplied, automatically load the given URL.\n\n";
        stringArray[1][0] = "SpawnFrame";
        stringArray[1][1] = "boolean\n";
        stringArray[1][2] = "Open a new Frame for the drawing area.\n\n";
        stringArray[2][0] = "SpawnPalette";
        stringArray[2][1] = "boolean\n";
        stringArray[2][2] = "Open a new Frame for the palette.\n\n";
        stringArray[3][0] = "DrawAreaWidth";
        stringArray[3][1] = "int\n";
        stringArray[3][2] = "Width of the drawing area in pixels.\n\n";
        stringArray[4][0] = "DrawAreaHeight";
        stringArray[4][1] = "int\n";
        stringArray[4][2] = "Height of the drawing area in pixels.\n\n";
        return stringArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FlexibleApplet() {
        System.out.println("making an example");
    }
}

