/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.tigris.gef.base.CmdInsertPoint;
import org.tigris.gef.base.CmdRemovePoint;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdgePoly;
import org.tigris.gef.presentation.Handle;

public class SelectionReshape
extends Selection
implements KeyListener {
    protected int _selectedHandle = -1;

    public void hitHandle(Rectangle rectangle, Handle handle) {
        int n = this._content.getNumPoints();
        int[] nArray = this._content.getXs();
        int[] nArray2 = this._content.getYs();
        int n2 = 0;
        while (n2 < n) {
            if (rectangle.contains(nArray[n2], nArray2[n2])) {
                this._selectedHandle = n2;
                handle.index = n2;
                handle.instructions = "Move point";
                return;
            }
            ++n2;
        }
        if (this._content instanceof FigEdgePoly) {
            n2 = 0;
            while (n2 < n - 1) {
                if (Geometry.intersects(rectangle, nArray[n2], nArray2[n2], nArray[n2 + 1], nArray2[n2 + 1])) {
                    FigEdgePoly figEdgePoly = (FigEdgePoly)this._content;
                    handle.index = figEdgePoly.getNumPoints();
                    handle.instructions = "Add a point";
                    return;
                }
                ++n2;
            }
        }
        this._selectedHandle = -1;
        handle.index = -1;
        handle.instructions = "Move object(s)";
    }

    public void paint(Graphics graphics) {
        int n = this._content.getNumPoints();
        int[] nArray = this._content.getXs();
        int[] nArray2 = this._content.getYs();
        graphics.setColor(Globals.getPrefs().handleColorFor(this._content));
        int n2 = 0;
        while (n2 < n) {
            graphics.fillRect(nArray[n2] - 3, nArray2[n2] - 3, 6, 6);
            ++n2;
        }
        if (this._selectedHandle != -1) {
            graphics.drawRect(nArray[this._selectedHandle] - 3 - 2, nArray2[this._selectedHandle] - 3 - 2, 9, 9);
        }
        super.paint(graphics);
    }

    public void dragHandle(int n, int n2, int n3, int n4, Handle handle) {
        if (this._content instanceof FigEdgePoly) {
            FigEdgePoly figEdgePoly = (FigEdgePoly)this._content;
            int n5 = this._content.getNumPoints();
            int[] nArray = this._content.getXs();
            int[] nArray2 = this._content.getYs();
            Rectangle rectangle = new Rectangle(n3 - 4, n4 - 4, 8, 8);
            if (handle.index == figEdgePoly.getNumPoints()) {
                int n6 = 0;
                while (n6 < n5 - 1) {
                    if (Geometry.intersects(rectangle, nArray[n6], nArray2[n6], nArray[n6 + 1], nArray2[n6 + 1])) {
                        figEdgePoly.insertPoint(n6, rectangle.x, rectangle.y);
                        handle.index = n6 + 1;
                        break;
                    }
                    ++n6;
                }
            }
            if (handle.index < 0 || handle.index >= figEdgePoly.getNumPoints()) {
                System.out.println("mistake " + handle.index);
            }
        }
        this._content.setPoints(handle, n, n2);
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyReleased(keyEvent);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        Editor editor = Globals.curEditor();
        char c = keyEvent.getKeyChar();
        int n = this._content.getNumPoints();
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyTyped(keyEvent);
        }
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._selectedHandle != -1 && (c == '\u007f' || c == '\b')) {
            editor.executeCmd(new CmdRemovePoint(this._selectedHandle), keyEvent);
            keyEvent.consume();
            return;
        }
        if (c == 'i') {
            if (this._selectedHandle == -1) {
                this._selectedHandle = 0;
            }
            editor.executeCmd(new CmdInsertPoint(this._selectedHandle), keyEvent);
            keyEvent.consume();
            return;
        }
        if (c == 'n') {
            this.startTrans();
            this._selectedHandle = this._selectedHandle == -1 ? 0 : (this._selectedHandle + 1) % n;
            this.endTrans();
            keyEvent.consume();
            return;
        }
        if (c == 'p') {
            this.startTrans();
            this._selectedHandle = this._selectedHandle == -1 ? n - 1 : (this._selectedHandle + n - 1) % n;
            this.endTrans();
            keyEvent.consume();
            return;
        }
    }

    public SelectionReshape(Fig fig) {
        super(fig);
    }
}

