/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.Handle;

public abstract class Selection
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final int HAND_SIZE = 6;
    public static final int BORDER_WIDTH = 4;
    protected Fig _content;

    public Fig getContent() {
        return this._content;
    }

    public void setcontent(Fig fig) {
        this._content = fig;
    }

    public boolean getLocked() {
        return this.getContent().getLocked();
    }

    public boolean contains(Fig fig) {
        return fig == this._content;
    }

    public void print(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
    }

    public void startTrans() {
        this.getContent().startTrans();
    }

    public void endTrans() {
        this.getContent().endTrans();
    }

    public Point getLocation() {
        return this._content.getLocation();
    }

    public void damage() {
        this._content.damage();
    }

    public final boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        if (this._content.contains(n, n2)) {
            return true;
        }
        Handle handle = new Handle(-1);
        this.hitHandle(n, n2, 0, 0, handle);
        return handle.index != -1;
    }

    public boolean hit(Rectangle rectangle) {
        if (this._content.hit(rectangle)) {
            return true;
        }
        Handle handle = new Handle(-1);
        this.hitHandle(rectangle, handle);
        return handle.index != -1;
    }

    public abstract void hitHandle(Rectangle var1, Handle var2);

    public final void hitHandle(int n, int n2, int n3, int n4, Handle handle) {
        this.hitHandle(new Rectangle(n, n2, n3, n4), handle);
    }

    public void reorder(int n, Layer layer) {
        layer.reorder(this._content, n);
    }

    public void translate(int n, int n2) {
        this._content.translate(n, n2);
    }

    public Rectangle getBounds() {
        return new Rectangle(this._content.getX() - 3, this._content.getY() - 3, this._content.getWidth() + 6, this._content.getHeight() + 6);
    }

    public void stuffBounds(Rectangle rectangle) {
        rectangle.setBounds(this._content.getX() - 3, this._content.getY() - 3, this._content.getWidth() + 6, this._content.getHeight() + 6);
    }

    public void delete() {
        this._content.delete();
    }

    public void dispose() {
        this._content.dispose();
    }

    public abstract void dragHandle(int var1, int var2, int var3, int var4, Handle var5);

    public Rectangle getContentBounds() {
        return this._content.getBounds();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyTyped(keyEvent);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyPressed(keyEvent);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this._content instanceof KeyListener) {
            ((KeyListener)((Object)this._content)).keyReleased(keyEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this._content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this._content)).mouseMoved(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this._content instanceof MouseMotionListener) {
            ((MouseMotionListener)((Object)this._content)).mouseDragged(mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseReleased(mouseEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseClicked(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseEntered(mouseEvent);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this._content instanceof MouseListener) {
            ((MouseListener)((Object)this._content)).mouseExited(mouseEvent);
        }
    }

    public Selection(Fig fig) {
        if (fig == null) {
            throw new NullPointerException();
        }
        this._content = fig;
    }
}

