/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Mode;
import org.tigris.gef.graph.GraphFactory;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeHooks;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;

public class ModePlace
extends Mode {
    protected Object _node;
    protected FigNode _pers;
    protected GraphFactory _factory;
    protected boolean _addRelatedEdges = false;

    public String instructions() {
        if (this._node != null) {
            return "Click to place " + this._node.toString();
        }
        return "";
    }

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void setAddRelatedEdges(boolean bl) {
        this._addRelatedEdges = bl;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._node = this._factory.makeNode();
        this.start();
        this._editor = Globals.curEditor();
        GraphModel graphModel = this._editor.getGraphModel();
        GraphNodeRenderer graphNodeRenderer = this._editor.getGraphNodeRenderer();
        Layer layer = this._editor.getLayerManager().getActiveLayer();
        this._pers = graphNodeRenderer.getFigNodeFor(graphModel, layer, this._node);
        this.mouseMoved(mouseEvent);
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this._editor.damaged(this._pers);
        this._pers = null;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._pers == null) {
            mouseEvent.consume();
            return;
        }
        this._editor.damaged(this._pers);
        Point point = new Point(n, n2);
        this._editor.snap(point);
        this._pers.setLocation(point.x, point.y);
        this._editor.damaged(this._pers);
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        GraphModel graphModel = this._editor.getGraphModel();
        if (!(graphModel instanceof MutableGraphModel)) {
            return;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)graphModel;
        if (mutableGraphModel.canAddNode(this._node)) {
            this._editor.add(this._pers);
            mutableGraphModel.addNode(this._node);
            if (this._addRelatedEdges) {
                mutableGraphModel.addNodeRelatedEdges(this._node);
            }
            Fig fig = null;
            Rectangle rectangle = this._pers.getBounds();
            Layer layer = this._editor.getLayerManager().getActiveLayer();
            Vector vector = layer.getContents();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Rectangle rectangle2;
                Fig fig2 = (Fig)enumeration.nextElement();
                if (!(fig2 instanceof FigNode) || fig2.equals(this._pers) || (rectangle2 = fig2.getTrapRect()) == null || !rectangle2.contains(rectangle.x, rectangle.y) || !rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
                fig = fig2;
            }
            this._pers.setEnclosingFig(fig);
            if (this._node instanceof GraphNodeHooks) {
                ((GraphNodeHooks)this._node).postPlacement(this._editor);
            }
            this._editor.getSelectionManager().select(this._pers);
        }
        this.done();
        mouseEvent.consume();
    }

    public void done() {
        super.done();
        this._pers = null;
        this._node = null;
    }

    public void paint(Graphics graphics) {
        if (this._pers != null) {
            this._pers.paint(graphics);
        }
    }

    public ModePlace(GraphFactory graphFactory) {
        this._factory = graphFactory;
        this._node = null;
        this._pers = null;
    }
}

