/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.Handle;

public class ModeModify
extends Mode {
    public static final int MIN_DELTA = 4;
    public static final int NO_CONSTRAINT = 0;
    public static final int HORIZONTAL_CONSTRAINT = 1;
    public static final int VERTICAL_CONSTRAINT = 2;
    private static Point snapPt = new Point(0, 0);
    protected Point _anchor;
    protected int _lastX = 1000;
    protected int _lastY = 1000;
    protected int _startX;
    protected int _startY;
    protected boolean _minDeltaAchieved;
    protected Handle _curHandle = new Handle(-1);
    protected int _constraint = 0;
    protected Rectangle _highlightTrap = null;

    public String instructions() {
        return "Modify selected objects";
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        int n3;
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n4 = mouseEvent.getX();
        if (!this.checkMinDelta(n4, n3 = mouseEvent.getY())) {
            mouseEvent.consume();
            return;
        }
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        if (selectionManager.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            mouseEvent.consume();
            return;
        }
        Point point = snapPt;
        synchronized (point) {
            snapPt.setLocation(n4, n3);
            this.getEditor().snap(snapPt);
            n2 = ModeModify.snapPt.x;
            n = ModeModify.snapPt.y;
        }
        int n5 = n2 - this._lastX;
        int n6 = n - this._lastY;
        if (mouseEvent.isControlDown() && this._constraint == 0) {
            if (n5 != 0) {
                this._constraint = 1;
                Globals.showStatus("Moving objects horizontally");
            }
            if (n6 != 0) {
                this._constraint = 2;
                Globals.showStatus("Moving objects vertically");
            }
        }
        if (this._constraint == 1) {
            n6 = 0;
            n = this._anchor.y;
        }
        if (this._constraint == 2) {
            n5 = 0;
            n2 = this._anchor.x;
        }
        if (n5 == 0 && n6 == 0) {
            mouseEvent.consume();
            return;
        }
        selectionManager.startTrans();
        if (this._curHandle.index == -1) {
            this.setCursor(Cursor.getPredefinedCursor(13));
            if (this.legal(n5, n6, selectionManager, mouseEvent)) {
                selectionManager.translate(n5, n6);
                this._lastX = n2;
                this._lastY = n;
            }
        } else if (this._curHandle.index >= 0) {
            this.setCursor(Cursor.getPredefinedCursor(1));
            selectionManager.dragHandle(n2, n, this._anchor.x, this._anchor.y, this._curHandle);
            this._lastX = n2;
            this._lastY = n;
        }
        selectionManager.endTrans();
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.start();
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        if (selectionManager.size() == 0) {
            this.done();
        }
        if (selectionManager.getLocked()) {
            Globals.showStatus("Cannot Modify Locked Objects");
            mouseEvent.consume();
            return;
        }
        this._anchor.x = n;
        this._anchor.y = n2;
        selectionManager.hitHandle(new Rectangle(n - 4, n2 - 4, 8, 8), this._curHandle);
        Globals.showStatus(this._curHandle.instructions);
        selectionManager.endTrans();
        Point point = snapPt;
        synchronized (point) {
            snapPt.setLocation(n, n2);
            this.getEditor().snap(snapPt);
            this._startX = this._lastX = ModeModify.snapPt.x;
            this._startY = this._lastY = ModeModify.snapPt.y;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.done();
        mouseEvent.consume();
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        Vector vector = selectionManager.getFigs();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (!(fig instanceof FigNode)) continue;
            Rectangle rectangle = fig.getBounds();
            Layer layer = fig.getLayer();
            Vector vector2 = layer.getContents();
            Enumeration enumeration2 = vector2.elements();
            Fig fig2 = null;
            while (enumeration2.hasMoreElements()) {
                Rectangle rectangle2;
                Fig fig3 = (Fig)enumeration2.nextElement();
                if (!(fig3 instanceof FigNode) || !fig3.getUseTrapRect() || (rectangle2 = fig3.getTrapRect()) == null || !rectangle2.contains(rectangle.x, rectangle.y) || !rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) continue;
                fig2 = fig3;
            }
            fig.setEnclosingFig(fig2);
        }
    }

    public void start() {
        this._minDeltaAchieved = false;
        super.start();
    }

    public void done() {
        super.done();
        SelectionManager selectionManager = this.getEditor().getSelectionManager();
        selectionManager.cleanUp();
        if (this._highlightTrap != null) {
            this._editor.damaged(this._highlightTrap);
            this._highlightTrap = null;
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._highlightTrap != null) {
            Color color = Globals.getPrefs().getRubberbandColor();
            graphics.setColor(color);
            graphics.drawRect(this._highlightTrap.x - 1, this._highlightTrap.y - 1, this._highlightTrap.width + 1, this._highlightTrap.height + 1);
            graphics.drawRect(this._highlightTrap.x - 2, this._highlightTrap.y - 2, this._highlightTrap.width + 3, this._highlightTrap.height + 3);
        }
    }

    protected boolean checkMinDelta(int n, int n2) {
        if (n > this._startX + 4 || n < this._startX - 4 || n2 > this._startY + 4 || n2 < this._startY - 4) {
            this._minDeltaAchieved = true;
        }
        return this._minDeltaAchieved;
    }

    protected boolean legal(int n, int n2, SelectionManager selectionManager, MouseEvent mouseEvent) {
        if (this._highlightTrap != null) {
            this._editor.damaged(this._highlightTrap);
        }
        this._highlightTrap = null;
        Vector vector = selectionManager.getFigs();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            boolean bl = fig.getUseTrapRect();
            if (!(fig instanceof FigNode)) continue;
            Rectangle rectangle = fig.getBounds();
            rectangle.x += n;
            rectangle.y += n2;
            Layer layer = fig.getLayer();
            Vector vector2 = layer.getContents();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Rectangle rectangle2;
                Fig fig2 = (Fig)enumeration2.nextElement();
                if (!(fig2 instanceof FigNode) || !bl && !fig2.getUseTrapRect() || vector.contains(fig2) || (rectangle2 = fig2.getTrapRect()) == null) continue;
                int n3 = 0;
                if (rectangle2.contains(rectangle.x, rectangle.y)) {
                    ++n3;
                }
                if (rectangle2.contains(rectangle.x + rectangle.width, rectangle.y)) {
                    ++n3;
                }
                if (rectangle2.contains(rectangle.x, rectangle.y + rectangle.height)) {
                    ++n3;
                }
                if (rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height)) {
                    ++n3;
                }
                if (!rectangle2.intersects(rectangle) || rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height) || rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height)) continue;
                this._highlightTrap = rectangle2;
                this._editor.damaged(this._highlightTrap);
                return false;
            }
        }
        return true;
    }

    public ModeModify(Editor editor) {
        super(editor);
        this._anchor = new Point(0, 0);
    }
}

