/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;

public class ModeDragScroll
extends Mode
implements ActionListener {
    private static final int AUTOSCROLL_DELAY = 200;
    private static final int MIN_AUTOSCROLL_DELAY = 50;
    private static final int AUTOSCROLL_FACTOR = 10;
    private boolean autoscroll = false;
    private Rectangle currentView;
    private Rectangle newView = new Rectangle();
    private Point scrollOrigin = new Point();
    private int xcorrection = 0;
    private int ycorrection = 0;
    private JComponent component = null;
    private JViewport view = null;
    private Cursor oldCursor = null;
    private Dimension componentSize = null;
    private Timer autoTimer = new Timer(200, this);
    private boolean dragScrolling = false;
    private int recentX;
    private int recentY;

    public boolean canExit() {
        return false;
    }

    public String instructions() {
        return "Drag with mouse to scroll";
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.dragScrolling = mouseEvent.isAltDown();
        this.component = (JComponent)this._editor.getAwtComponent();
        if (this.component == null) {
            return;
        }
        if (this.component != null && this.component.getParent() instanceof JViewport) {
            this.view = (JViewport)this.component.getParent();
        }
        this.componentSize = this.component.getSize();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.currentView = this.view.getViewRect();
        this.newView.width = this.currentView.width;
        this.newView.height = this.currentView.height;
        this.newView.x = this.currentView.x;
        this.newView.y = this.currentView.y;
        this.scrollOrigin.x = n;
        this.scrollOrigin.y = n2;
        this.xcorrection = 0;
        this.ycorrection = 0;
        if (this.dragScrolling) {
            this.oldCursor = this.component.getCursor();
            this.component.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.autoTimer.stop();
        this.autoscroll = false;
        if (this.dragScrolling) {
            mouseEvent.consume();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.recentX = n;
        this.recentY = n2;
        if (n < this.currentView.x || n2 < this.currentView.y || n > this.currentView.x + this.currentView.width || n2 > this.currentView.y + this.currentView.height) {
            if (n < this.currentView.x) {
                this.newView.x = n - this.currentView.x;
                this.newView.y = 0;
            } else if (n > this.currentView.x + this.currentView.width) {
                this.newView.x = n - (this.currentView.x + this.currentView.width);
                this.newView.y = 0;
            }
            if (n2 < this.currentView.y) {
                this.newView.x = 0;
                this.newView.y = n2 - this.currentView.y;
            } else if (n2 > this.currentView.y + this.currentView.height) {
                this.newView.x = 0;
                this.newView.y = n2 - (this.currentView.y + this.currentView.height);
            }
            if (this.dragScrolling) {
                this.newView.x = -this.newView.x;
                this.newView.y = -this.newView.y;
            }
            if (!this.autoscroll) {
                this.autoscroll = true;
                this.autoTimer.start();
            }
            if (!this.doScroll()) {
                this.autoscroll = false;
                this.autoTimer.stop();
            }
            if (this.dragScrolling) {
                mouseEvent.consume();
            }
            return;
        }
        this.autoscroll = false;
        this.autoTimer.stop();
        if (this.dragScrolling) {
            this.newView.x = this.scrollOrigin.x - (n -= this.xcorrection);
            this.newView.y = this.scrollOrigin.y - (n2 -= this.ycorrection);
            if (this.doScroll()) {
                this.scrollOrigin.x = n;
                this.scrollOrigin.y = n2;
            }
            mouseEvent.consume();
        }
    }

    private boolean doScroll() {
        this.currentView.x += this.newView.x;
        this.currentView.y += this.newView.y;
        if (this.currentView.x < 0 || this.currentView.x > this.componentSize.width - this.currentView.width) {
            this.currentView.x -= this.newView.x;
            this.newView.x = 0;
        }
        if (this.currentView.y < 0 || this.currentView.y > this.componentSize.height - this.currentView.height) {
            this.currentView.y -= this.newView.y;
            this.newView.y = 0;
        }
        if (this.newView.x == 0 && this.newView.y == 0) {
            return false;
        }
        this.view.setViewPosition(new Point(this.currentView.x, this.currentView.y));
        this.xcorrection += this.newView.x;
        this.ycorrection += this.newView.y;
        this.currentView = this.view.getViewRect();
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.currentView = null;
        if (this.dragScrolling) {
            this.component.setCursor(this.oldCursor);
        }
        this.component = null;
        this.componentSize = null;
        this.view = null;
        this.oldCursor = null;
        if (this.autoscroll) {
            this.autoTimer.stop();
        }
        this.autoscroll = false;
        if (this.dragScrolling) {
            mouseEvent.consume();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.oldCursor != null && this.component != null && this.dragScrolling) {
            this.component.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (this.autoscroll) {
            this.autoTimer.stop();
        }
        this.autoscroll = false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MouseEvent mouseEvent = new MouseEvent(this.getEditor().getAwtComponent(), 506, 0L, 16, this.recentX, this.recentY, 0, false);
        this.getEditor().mouseDragged(mouseEvent);
    }

    public ModeDragScroll(Editor editor) {
        super(editor);
    }

    public ModeDragScroll() {
        this(null);
    }
}

