/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class ModeCreatePolyEdge
extends ModeCreate {
    private Object _startPort;
    private Fig _startPortFig;
    private FigNode _sourceFigNode;
    private Object _newEdge;
    protected int _npoints = 0;
    protected int _lastX;
    protected int _lastY;
    protected int _startX;
    protected int _startY;
    protected Handle _handle = new Handle(-1);

    public String instructions() {
        return "Drag to define an edge to another port";
    }

    public Fig createNewItem(MouseEvent mouseEvent, int n, int n2) {
        FigPoly figPoly = new FigPoly(n, n2);
        figPoly.setLineColor(Globals.getPrefs().getRubberbandColor());
        figPoly.setFillColor(null);
        figPoly.addPoint(n, n2);
        this._startX = this._lastX = n;
        this._startY = this._lastY = n2;
        this._npoints = 2;
        return figPoly;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getX();
        Fig fig = this._editor.hit(n2, n = mouseEvent.getY());
        if (fig == null) {
            fig = this._editor.hit(n2 - 16, n - 16, 32, 32);
        }
        if (fig == null && this._npoints == 0) {
            this.done();
            mouseEvent.consume();
            return;
        }
        if (!(fig instanceof FigNode) && this._npoints == 0) {
            this.done();
            mouseEvent.consume();
            return;
        }
        if (this._sourceFigNode == null) {
            this._sourceFigNode = (FigNode)fig;
            this._startPort = this._sourceFigNode.deepHitPort(n2, n);
        }
        if (this._startPort == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        this._startPortFig = this._sourceFigNode.getPortFig(this._startPort);
        if (this._npoints == 0) {
            super.mousePressed(mouseEvent);
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Cloneable cloneable;
        GraphModel graphModel;
        int n;
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._sourceFigNode == null) {
            this.done();
            mouseEvent.consume();
            return;
        }
        int n2 = mouseEvent.getX();
        Fig fig = this._editor.hit(n2, n = mouseEvent.getY());
        if (fig == null) {
            fig = this._editor.hit(n2 - 16, n - 16, 32, 32);
        }
        if (!((graphModel = this._editor.getGraphModel()) instanceof MutableGraphModel)) {
            fig = null;
        }
        MutableGraphModel mutableGraphModel = (MutableGraphModel)graphModel;
        if (fig instanceof FigNode) {
            cloneable = (FigNode)fig;
            Object object = ((FigNode)cloneable).deepHitPort(n2, n);
            if (object == this._startPort && this._npoints < 4) {
                this.done();
                mouseEvent.consume();
                return;
            }
            if (object != null) {
                Fig fig2 = ((FigNode)cloneable).getPortFig(object);
                FigPoly figPoly = (FigPoly)this._newItem;
                if (object == this._startPort && this._npoints >= 4) {
                    figPoly.setSelfLoop(true);
                }
                this._editor.damaged(figPoly);
                figPoly._isComplete = true;
                Class clazz = (Class)this.getArg("edgeClass");
                this._newEdge = clazz != null ? mutableGraphModel.connect(this._startPort, object, clazz) : mutableGraphModel.connect(this._startPort, object);
                if (this._newEdge == null) {
                    System.out.println("MutableGraphModel connect() return null");
                } else {
                    LayerManager layerManager = this._editor.getLayerManager();
                    this._sourceFigNode.damage();
                    ((Fig)cloneable).damage();
                    Layer layer = this._editor.getLayerManager().getActiveLayer();
                    FigEdge figEdge = (FigEdge)layer.presentationFor(this._newEdge);
                    this._newItem.setLineColor(Color.black);
                    figEdge.setFig(this._newItem);
                    figEdge.setSourcePortFig(this._startPortFig);
                    figEdge.setSourceFigNode(this._sourceFigNode);
                    figEdge.setDestPortFig(fig2);
                    figEdge.setDestFigNode((FigNode)cloneable);
                    if (figEdge != null) {
                        this._editor.getSelectionManager().select(figEdge);
                    }
                    this._editor.damaged(figEdge);
                    if (figEdge instanceof MouseListener) {
                        ((MouseListener)((Object)figEdge)).mouseReleased(mouseEvent);
                    }
                    if (this._sourceFigNode != null) {
                        this._sourceFigNode.updateEdges();
                    }
                    if (cloneable != null) {
                        ((FigNode)cloneable).updateEdges();
                    }
                }
                this.done();
                mouseEvent.consume();
                return;
            }
        }
        if (!this.nearLast(n2, n)) {
            this._editor.damaged(this._newItem);
            cloneable = new Point(n2, n);
            this._editor.snap((Point)cloneable);
            ((FigPoly)this._newItem).addPoint(((Point)cloneable).x, ((Point)cloneable).y);
            ++this._npoints;
            this._editor.damaged(this._newItem);
        }
        this._lastX = n2;
        this._lastY = n;
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseDragged(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this._npoints == 0) {
            mouseEvent.consume();
            return;
        }
        if (this._newItem == null) {
            mouseEvent.consume();
            return;
        }
        FigPoly figPoly = (FigPoly)this._newItem;
        this._editor.damaged(this._newItem);
        Point point = new Point(n, n2);
        this._editor.snap(point);
        this._handle.index = figPoly.getNumPoints() - 1;
        figPoly.moveVertex(this._handle, point.x, point.y, true);
        this._editor.damaged(this._newItem);
        mouseEvent.consume();
    }

    protected boolean nearLast(int n, int n2) {
        return n > this._lastX - 8 && n < this._lastX + 8 && n2 > this._lastY - 8 && n2 < this._lastY + 8;
    }

    public void done() {
        super.done();
        if (this._newItem != null) {
            this._editor.damaged(this._newItem);
        }
        this._newItem = null;
        this._npoints = 0;
        this._sourceFigNode = null;
        this._startPort = null;
        this._startPortFig = null;
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\u001b') {
            this.done();
            keyEvent.consume();
        }
    }

    public ModeCreatePolyEdge() {
    }

    public ModeCreatePolyEdge(Editor editor) {
        super(editor);
    }
}

