/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;
import org.tigris.gef.presentation.Fig;

public abstract class ModeCreate
extends Mode {
    protected static int _defaultWidth = 32;
    protected static int _defaultHeight = 32;
    protected int anchorX;
    protected int anchorY;
    protected Fig _newItem;
    private Point snapPt = new Point(0, 0);

    public Cursor getInitialCursor() {
        return Cursor.getPredefinedCursor(1);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.start();
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(mouseEvent.getX(), mouseEvent.getY());
            this._editor.snap(this.snapPt);
            this.anchorX = this.snapPt.x;
            this.anchorY = this.snapPt.y;
        }
        this._newItem = this.createNewItem(mouseEvent, this.anchorX, this.anchorY);
        mouseEvent.consume();
        this.setCursor(Cursor.getPredefinedCursor(1));
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this._editor.damaged(this._newItem);
            this.creationDrag(mouseEvent.getX(), mouseEvent.getY());
            this._editor.damaged(this._newItem);
        }
        this._editor.scrollToShow(mouseEvent.getX(), mouseEvent.getY());
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (this._newItem != null) {
            this._editor.damaged(this._newItem);
            this.creationDrag(mouseEvent.getX(), mouseEvent.getY());
            this._editor.add(this._newItem);
            this._editor.getSelectionManager().select(this._newItem);
            this._newItem = null;
        }
        this.done();
        mouseEvent.consume();
    }

    protected void creationDrag(int n, int n2) {
        int n3;
        int n4;
        if (this._newItem == null) {
            return;
        }
        Point point = this.snapPt;
        synchronized (point) {
            this.snapPt.setLocation(n, n2);
            this._editor.snap(this.snapPt);
            n4 = this.snapPt.x;
            n3 = this.snapPt.y;
        }
        if (this.anchorX == n4 && this.anchorY == n3) {
            this._newItem.createDrag(this.anchorX, this.anchorY, n + _defaultWidth, n2 + _defaultHeight, n4 + _defaultWidth, n3 + _defaultHeight);
        } else {
            this._newItem.createDrag(this.anchorX, this.anchorY, n, n2, n4, n3);
            _defaultWidth = n4 - this.anchorX;
            _defaultHeight = n3 - this.anchorY;
        }
    }

    public void paint(Graphics graphics) {
        if (this._newItem != null) {
            this._newItem.paint(graphics);
        }
    }

    public abstract Fig createNewItem(MouseEvent var1, int var2, int var3);

    public ModeCreate(Editor editor) {
        super(editor);
    }

    public ModeCreate() {
    }
}

