/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.CmdAlign;
import org.tigris.gef.base.CmdDistribute;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Mode;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class ModeBroom
extends Mode {
    public final int UNDEFINED;
    public final int UPWARD;
    public final int DOWNWARD;
    public final int RIGHTWARD;
    public final int LEFTWARD;
    public final int BROOM_WIDTH;
    public final int SMALL_BROOM_WIDTH;
    public final int FUDGE;
    public final int MAX_TOUCHED;
    public final int EVEN_SPACE;
    public final int PACK;
    public final int SPREAD;
    public final int ORIG;
    public final Font HINT_FONT = new Font("Dialog", 0, 9);
    private Point _start = new Point(0, 0);
    private Vector _LastTouched = new Vector();
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private int _lastX1;
    private int _lastY1;
    private int _lastX2;
    private int _lastY2;
    private int _lastMX;
    private int _lastMY;
    private int _dir = 0;
    private boolean _magnetic = false;
    private boolean _movable = true;
    private boolean _draw = false;
    private Fig[] _touched = new Fig[1000];
    private int[] _origX = new int[1000];
    private int[] _origY = new int[1000];
    private int[] _offX = new int[1000];
    private int[] _offY = new int[1000];
    private int _nTouched = 0;
    private int _broomMargin = 0;
    private int _distributeMode = 0;
    private Rectangle _addRect = new Rectangle();
    private Rectangle _selectRect = new Rectangle();
    private Rectangle _bigDamageRect = new Rectangle(0, 0, 400, 400);
    private Rectangle _origBBox = null;
    private String _hint = null;

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._touched = new Fig[1000];
        this._origX = new int[1000];
        this._origY = new int[1000];
        this._offX = new int[1000];
        this._offY = new int[1000];
        this._nTouched = 0;
        this._dir = 0;
        this._magnetic = false;
        this._draw = true;
        this.x2 = this._start.x = mouseEvent.getX();
        this.x1 = this._start.x;
        this.y2 = this._start.y = mouseEvent.getY();
        this.y1 = this._start.y;
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        this._selectRect.setBounds(this.x1 - 14, this.y1 - 14, this.x2 - this.x1 + 28, this.y2 - this.y1 + 28);
        this._editor.damaged(this._selectRect);
        this._editor.getSelectionManager().deselectAll();
        mouseEvent.consume();
        this._hint = null;
        this.start();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        mouseEvent.consume();
        this._lastMX = mouseEvent.getX();
        this._lastMY = mouseEvent.getY();
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        this._editor.snap(point);
        int n = point.x;
        int n2 = point.y;
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this._editor.damaged(this._bigDamageRect);
        this._editor.damaged(this._selectRect);
        if (this._dir == 0) {
            this._broomMargin = mouseEvent.isShiftDown() ? 30 : 200;
            int n3 = mouseEvent.getX() - this._start.x;
            int n4 = mouseEvent.getY() - this._start.y;
            if (Math.abs(n3) < 10 && Math.abs(n4) < 10) {
                return;
            }
            if (Math.abs(n3) > Math.abs(n4)) {
                this._dir = n3 > 0 ? 3 : 4;
                this.x1 = this.x2 = n;
                this.y1 = n2 - this._broomMargin / 2;
                this.y2 = n2 + this._broomMargin / 2;
                if (mouseEvent.isShiftDown()) {
                    this.y1 = n2 - this._broomMargin / 2;
                    this.y2 = n2 + this._broomMargin / 2;
                }
            } else {
                this._dir = n4 > 0 ? 2 : 1;
                this.y1 = this.y2 = n2;
                this.x1 = n - this._broomMargin / 2;
                this.x2 = n + this._broomMargin / 2;
                if (mouseEvent.isShiftDown()) {
                    this.x1 = n - this._broomMargin / 2;
                    this.x2 = n + this._broomMargin / 2;
                }
            }
        }
        if (!this._magnetic) {
            this.addNewItems();
        }
        this._lastX1 = this.x1;
        this._lastY1 = this.y1;
        this._lastX2 = this.x2;
        this._lastY2 = this.y2;
        switch (this._dir) {
            case 1: {
                if (this._movable) {
                    this.y1 = this.y2 = Math.min(n2, this._start.y);
                    if (this._magnetic) {
                        this.y1 = this.y2 = n2;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 2: {
                if (this._movable) {
                    this.y1 = this.y2 = Math.max(n2, this._start.y);
                    if (this._magnetic) {
                        this.y1 = this.y2 = n2;
                    }
                }
                this.x1 = Math.min(this.x1, this._lastMX - this._broomMargin / 2);
                this.x2 = Math.max(this.x2, this._lastMX + this._broomMargin / 2);
                break;
            }
            case 3: {
                if (this._movable) {
                    this.x1 = this.x2 = Math.max(n, this._start.x);
                    if (this._magnetic) {
                        this.x1 = this.x2 = n;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
                break;
            }
            case 4: {
                if (this._movable) {
                    this.x1 = this.x2 = Math.min(n, this._start.x);
                    if (this._magnetic) {
                        this.x1 = this.x2 = n;
                    }
                }
                this.y1 = Math.min(this.y1, this._lastMY - this._broomMargin / 2);
                this.y2 = Math.max(this.y2, this._lastMY + this._broomMargin / 2);
                break;
            }
        }
        if (this._movable) {
            Fig fig;
            Vector<FigEdge> vector = new Vector<FigEdge>();
            Vector<FigEdge> vector2 = new Vector<FigEdge>();
            int n5 = 0;
            while (n5 < this._nTouched) {
                fig = this._touched[n5];
                int n6 = n;
                int n7 = n2;
                int n8 = 0;
                int n9 = 0;
                switch (this._dir) {
                    case 1: {
                        if (!this._magnetic) {
                            n7 = Math.min(n2, this._origY[n5] + this._offY[n5]);
                        }
                        n9 = n7 - fig.getY() - this._offY[n5];
                        break;
                    }
                    case 2: {
                        if (!this._magnetic) {
                            n7 = Math.max(n2, this._origY[n5] + this._offY[n5]);
                        }
                        n9 = n7 - fig.getY() - this._offY[n5];
                        break;
                    }
                    case 3: {
                        if (!this._magnetic) {
                            n6 = Math.max(n, this._origX[n5] + this._offX[n5]);
                        }
                        n8 = n6 - fig.getX() - this._offX[n5];
                        break;
                    }
                    case 4: {
                        if (!this._magnetic) {
                            n6 = Math.min(n, this._origX[n5] + this._offX[n5]);
                        }
                        n8 = n6 - fig.getX() - this._offX[n5];
                        break;
                    }
                }
                fig.startTrans();
                if (!(fig instanceof FigNode)) {
                    fig.translate(n8, n9);
                } else {
                    FigNode figNode = (FigNode)fig;
                    figNode.superTranslate(n8, n9);
                    Vector vector3 = figNode.getFigEdges();
                    int n10 = vector3.size();
                    int n11 = 0;
                    while (n11 < n10) {
                        FigEdge figEdge = (FigEdge)vector3.elementAt(n11);
                        if (vector.contains(figEdge) && !vector2.contains(figEdge)) {
                            vector2.addElement(figEdge);
                            figEdge.translateEdge(n8, n9);
                        } else {
                            vector.addElement(figEdge);
                        }
                        ++n11;
                    }
                }
                fig.endTrans();
                ++n5;
            }
            n5 = 0;
            while (n5 < this._nTouched) {
                fig = this._touched[n5];
                if (fig instanceof FigNode) {
                    ((FigNode)fig).updateEdges();
                }
                ++n5;
            }
        }
        this._selectRect.setBounds(this.x1 - 4, this.y1 - 4, this.x2 - this.x1 + 8, this.y2 - this.y1 + 8);
        this._editor.damaged(this._selectRect);
        this._hint = null;
        this.touching();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this._selectRect.setBounds(this.x1 - 1, this.y1 - 1, this.x2 - this.x1 + 2, this.y2 - this.y1 + 20);
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this._editor.damaged(this._bigDamageRect);
        this._editor.damaged(this._selectRect);
        this._editor.getSelectionManager().select(this._LastTouched);
        this._draw = false;
        this.done();
        mouseEvent.consume();
        this._hint = null;
    }

    public void addNewItems() {
        if (this._nTouched >= 1000) {
            return;
        }
        this._addRect.setBounds(this._lastX1, this._lastY1, this._lastX2 - this._lastX1, this._lastY2 - this._lastY1);
        this._addRect.add(this._selectRect);
        Enumeration enumeration = this._editor.figs();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (!this._addRect.intersects(fig.getBounds())) continue;
            int n = 0;
            while (n < this._nTouched) {
                Fig fig2 = this._touched[n];
                if (fig2 == fig) break;
                ++n;
            }
            if (n < this._nTouched) continue;
            this._touched[this._nTouched] = fig;
            this._origX[this._nTouched] = fig.getX();
            this._origY[this._nTouched] = fig.getY();
            this._offX[this._nTouched] = this._dir == 4 ? fig.getWidth() : 0;
            this._offY[this._nTouched] = this._dir == 1 ? fig.getHeight() : 0;
            ++this._nTouched;
            this._origBBox = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        super.keyPressed(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (10 == keyEvent.getKeyCode() || 9 == keyEvent.getKeyCode()) {
            this._magnetic = !this._magnetic;
        } else if (32 == keyEvent.getKeyCode()) {
            this.doDistibute(false, keyEvent.isShiftDown());
            keyEvent.consume();
        } else {
            return;
        }
        this._bigDamageRect.setLocation(this.x1 - 200, this.y1 - 200);
        this._editor.damaged(this._bigDamageRect);
        this._editor.damaged(this._selectRect);
    }

    public void doDistibute(boolean bl, boolean bl2) {
        this._movable = false;
        Vector vector = this._LastTouched;
        if (vector == null) {
            vector = this.touching();
        }
        int n = 0;
        int n2 = vector.size();
        if (this._distributeMode == 0 || this._distributeMode == 2) {
            n = 4;
            if (this._dir == 1 || this._dir == 2) {
                n = 0;
            }
        } else if (this._distributeMode == 1) {
            n = 6;
            if (this._dir == 1 || this._dir == 2) {
                n = 2;
            }
        }
        if (this._distributeMode == 3) {
            int n3 = 0;
            while (n3 < n2) {
                Fig fig = (Fig)vector.elementAt(n3);
                if (this._dir == 1 || this._dir == 2) {
                    fig.setLocation(this._origX[n3], fig.getY());
                } else {
                    fig.setLocation(fig.getX(), this._origY[n3]);
                }
                ++n3;
            }
        } else {
            CmdDistribute cmdDistribute = new CmdDistribute(n);
            cmdDistribute.setArg("figs", vector);
            if (this._distributeMode == 2) {
                cmdDistribute.setArg("bbox", this._selectRect);
            } else if (this._distributeMode == 0 && this._origBBox != null) {
                cmdDistribute.setArg("bbox", this._origBBox);
            }
            cmdDistribute.doIt();
            if (bl2) {
                int n4 = 5;
                if (this._dir == 1 || this._dir == 2) {
                    n4 = 6;
                }
                CmdAlign cmdAlign = new CmdAlign(n4);
                cmdAlign.setArg("figs", vector);
                cmdAlign.doIt();
            }
            if (bl) {
                CmdAlign cmdAlign = new CmdAlign(7);
                cmdAlign.setArg("figs", vector);
                cmdAlign.doIt();
            }
            if (this._distributeMode == 0 && this._origBBox == null) {
                this._origBBox = cmdDistribute.getLastBBox();
            }
        }
        this._hint = this._distributeMode == 0 ? "Space evenly" : (this._distributeMode == 1 ? "Pack tightly" : (this._distributeMode == 2 ? "Spread out" : (this._distributeMode == 3 ? "Original" : "(internal prog error)")));
        if (bl2) {
            this._hint = this._hint + " + center";
        }
        if (bl) {
            this._hint = this._hint + " + snap";
        }
        this._distributeMode = (this._distributeMode + 1) % 4;
    }

    public Vector touching() {
        Vector<Fig> vector = new Vector<Fig>(this._nTouched);
        int n = 0;
        while (n < this._nTouched) {
            if (this._touched[n].getBounds().intersects(this._selectRect) && !(this._touched[n] instanceof FigEdge)) {
                vector.addElement(this._touched[n]);
            }
            ++n;
        }
        this._LastTouched = vector;
        return vector;
    }

    public String instructions() {
        return "Push objects around. Retrun toggles pulling. Space key distributes.";
    }

    public void paint(Graphics graphics) {
        if (!this._draw) {
            return;
        }
        Color color = Globals.getPrefs().getRubberbandColor();
        if (this._magnetic) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(color);
        }
        if (this._hint != null) {
            graphics.setFont(this.HINT_FONT);
        }
        int n = this._broomMargin / 2;
        switch (this._dir) {
            case 0: {
                graphics.fillRect(this.x1 - 10, (this.y1 + this.y2) / 2 - 2, 20, 4);
                graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 10, 4, 20);
                break;
            }
            case 1: {
                graphics.fillRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1 + 4);
                graphics.drawLine(this._lastMX - n, this.y2 + 4, this._lastMX - n, this.y2 + 8);
                graphics.drawLine(this._lastMX + n - 1, this.y2 + 4, this._lastMX + n - 1, this.y2 + 8);
                if (this._movable) {
                    graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1, 4, 14);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 + 15);
                break;
            }
            case 2: {
                graphics.fillRect(this.x1, this.y1 - 4, this.x2 - this.x1, this.y2 - this.y1 + 4);
                if (this._movable) {
                    graphics.fillRect((this.x1 + this.x2) / 2 - 2, this.y1 - 14, 4, 14);
                }
                graphics.drawLine(this._lastMX - n, this.y1 - 4, this._lastMX - n, this.y1 - 8);
                graphics.drawLine(this._lastMX + n - 1, this.y1 - 4, this._lastMX + n - 1, this.y1 - 8);
                if (this._hint == null) break;
                graphics.drawString(this._hint, (this.x1 + this.x2) / 2 + 5, this.y1 - 8);
                break;
            }
            case 3: {
                graphics.fillRect(this.x1 - 4, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                graphics.drawLine(this.x1 - 4, this._lastMY - n, this.x1 - 8, this._lastMY - n);
                graphics.drawLine(this.x1 - 4, this._lastMY + n - 1, this.x1 - 8, this._lastMY + n - 1);
                if (this._movable) {
                    graphics.fillRect(this.x1 - 14, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, this.x1 - 70, (this.y1 + this.y2) / 2 - 10);
                break;
            }
            case 4: {
                graphics.fillRect(this.x1, this.y1, this.x2 - this.x1 + 4, this.y2 - this.y1);
                graphics.drawLine(this.x2 + 4, this._lastMY - n, this.x2 + 8, this._lastMY - n);
                graphics.drawLine(this.x2 + 4, this._lastMY + n - 1, this.x2 + 8, this._lastMY + n - 1);
                if (this._movable) {
                    graphics.fillRect(this.x1, (this.y1 + this.y2) / 2 - 2, 14, 4);
                }
                if (this._hint == null) break;
                graphics.drawString(this._hint, this.x2 + 5, (this.y1 + this.y2) / 2 - 10);
                break;
            }
        }
    }

    public ModeBroom(Editor editor) {
        super(editor);
        this.UNDEFINED = 0;
        this.UPWARD = 1;
        this.DOWNWARD = 2;
        this.RIGHTWARD = 3;
        this.LEFTWARD = 4;
        this.BROOM_WIDTH = 200;
        this.SMALL_BROOM_WIDTH = 30;
        this.FUDGE = 10;
        this.MAX_TOUCHED = 1000;
        this.EVEN_SPACE = 0;
        this.PACK = 1;
        this.SPREAD = 2;
        this.ORIG = 3;
    }

    public ModeBroom() {
        this.UNDEFINED = 0;
        this.UPWARD = 1;
        this.DOWNWARD = 2;
        this.RIGHTWARD = 3;
        this.LEFTWARD = 4;
        this.BROOM_WIDTH = 200;
        this.SMALL_BROOM_WIDTH = 30;
        this.FUDGE = 10;
        this.MAX_TOUCHED = 1000;
        this.EVEN_SPACE = 0;
        this.PACK = 1;
        this.SPREAD = 2;
        this.ORIG = 3;
    }
}

