/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerPolar
extends Layer {
    private int _originX = 0;
    private int _originY = 0;
    private int _spacing = 32;
    private int _style = 0;
    private int NUM_STYLES = 5;
    protected Color _lineColor = new Color(55, 55, 255);
    protected Color _bgColor = null;

    public void origin(int n, int n2) {
        this._originX = n;
        this._originY = n2;
    }

    public void spacing(int n) {
        this._spacing = n;
    }

    public int dist(int n, int n2) {
        int n3 = (this._originX - n) * (this._originX - n) + (this._originY - n2) * (this._originY - n2);
        return (int)Math.round(Math.sqrt(n3));
    }

    public void lineColor(Color color) {
        this._lineColor = color;
    }

    public Color lineColor() {
        return this._lineColor;
    }

    public void bgColor(Color color) {
        this._bgColor = color;
    }

    public Color bgColor() {
        return this._bgColor;
    }

    public Vector getContents() {
        return null;
    }

    public Fig presentationFor(Object object) {
        return null;
    }

    public void paintContents(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = rectangle.y + rectangle.height;
        int n2 = rectangle.x + rectangle.width;
        if (this._bgColor != null) {
            graphics.setColor(this._bgColor);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        int n3 = this.dist(rectangle.x, rectangle.y);
        int n4 = this.dist(rectangle.x, n);
        int n5 = this.dist(n2, rectangle.y);
        int n6 = this.dist(n2, n);
        int n7 = Math.max(Math.max(n3, n4), Math.max(n5, n6));
        n7 = n7 / this._spacing * this._spacing + 1;
        graphics.setColor(this._lineColor);
        int n8 = this._originX;
        int n9 = this._originY;
        int n10 = 0;
        int n11 = 2 * n7;
        while (n10 <= n11) {
            graphics.drawOval(n8, n9, n10, n10);
            n8 -= this._spacing;
            n9 -= this._spacing;
            n10 += this._spacing;
            n10 += this._spacing;
        }
    }

    public void adjust() {
        this._style = (this._style + 1) % this.NUM_STYLES;
        switch (this._style) {
            case 0: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(32);
                break;
            }
            case 1: {
                this.setHidden(false);
                this.origin(0, 0);
                this.spacing(16);
                break;
            }
            case 2: {
                this.setHidden(false);
                this.origin(50, 50);
                this.spacing(16);
                break;
            }
            case 3: {
                this.setHidden(false);
                Editor editor = Globals.curEditor();
                if (editor != null) {
                    Dimension dimension = editor.getAwtComponent().getSize();
                    this.origin(dimension.width / 2, dimension.height / 2);
                } else {
                    this.origin(100, 100);
                }
                this.spacing(16);
                break;
            }
            case 4: {
                this.setHidden(true);
                break;
            }
        }
    }

    public LayerPolar() {
        super("Grid");
    }

    public LayerPolar(int n, int n2, int n3) {
        super("Grid");
        this.origin(n, n2);
        this.spacing(n3);
    }
}

