/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;

public class LayerPageBreaks
extends Layer {
    public final int DASH_LENGTH;
    public final int GAP_LENGTH;
    private boolean _paintLines = false;
    protected Color _color = Color.white;
    protected Dimension _pageSize = new Dimension(582, 717);

    public void setPageSize(Dimension dimension) {
        this._pageSize = dimension;
    }

    public Vector getContents() {
        return null;
    }

    public Fig presentationFor(Object object) {
        return null;
    }

    public synchronized void paintContents(Graphics graphics) {
        if (graphics instanceof PrintGraphics) {
            return;
        }
        if (!this._paintLines) {
            return;
        }
        if (this._pageSize == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        int n = rectangle.x / this._pageSize.width * this._pageSize.width - this._pageSize.width;
        int n2 = rectangle.y / this._pageSize.height * this._pageSize.height - this._pageSize.height;
        int n3 = rectangle.x + rectangle.width;
        int n4 = rectangle.y + rectangle.height;
        int n5 = (n3 - n) / this._pageSize.width + 1;
        int n6 = (n4 - n2) / this._pageSize.height + 1;
        graphics.setColor(this._color);
        while (n5 > 0) {
            this.drawDashedLine(graphics, 0, n - 1, 0, n - 1, n4);
            n += this._pageSize.width;
            --n5;
        }
        while (n6 > 0) {
            this.drawDashedLine(graphics, 0, 0, n2 - 1, n3, n2 - 1);
            n2 += this._pageSize.height;
            --n6;
        }
    }

    protected int drawDashedLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = (n4 - n2) * (n4 - n2);
        int n7 = (n5 - n3) * (n5 - n3);
        int n8 = (int)Math.sqrt(n6 + n7);
        int n9 = n;
        while (n9 < n8 - 2) {
            int n10;
            int n11;
            int n12 = n2 + (n4 - n2) * n9 / n8;
            int n13 = n3 + (n5 - n3) * n9 / n8;
            if ((n9 += 2) >= n8) {
                n11 = n4;
                n10 = n5;
            } else {
                n11 = n2 + (n4 - n2) * n9 / n8;
                n10 = n3 + (n5 - n3) * n9 / n8;
            }
            graphics.drawLine(n12, n13, n11, n10);
            n9 += 7;
        }
        return 0;
    }

    public void adjust() {
        this._paintLines = !this._paintLines;
        this.refreshEditors();
    }

    public LayerPageBreaks() {
        super("PageBreaks");
        this.DASH_LENGTH = 2;
        this.GAP_LENGTH = 7;
    }
}

