/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Layer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.presentation.FigPainter;
import org.tigris.gef.util.Dbg;

public class LayerDiagram
extends Layer {
    protected static int _nextLayerNumbered = 1;
    protected Vector _contents = new Vector();

    protected static String numberWordFor(int n) {
        switch (n) {
            case 1: {
                return "One";
            }
            case 2: {
                return "Two";
            }
            case 3: {
                return "Three";
            }
            case 4: {
                return "Four";
            }
            case 5: {
                return "Five";
            }
            case 6: {
                return "Six";
            }
            case 7: {
                return "Seven";
            }
            case 8: {
                return "Eight";
            }
            case 9: {
                return "Nine";
            }
        }
        return "Layer " + n;
    }

    public void add(Fig fig) {
        Dbg.assert(fig != null, "tried to add null Fig");
        this._contents.removeElement(fig);
        this._contents.addElement(fig);
        fig.setLayer(this);
        fig.endTrans();
    }

    public void insertAt(Fig fig, int n) {
        Dbg.assert(fig != null, "tried to insert null Fig");
        this._contents.removeElement(fig);
        this._contents.insertElementAt(fig, n);
        fig.setLayer(this);
        fig.endTrans();
    }

    public int indexOf(Fig fig) {
        Dbg.assert(fig != null, "tried to find null Fig");
        return this._contents.indexOf(fig);
    }

    public void remove(Fig fig) {
        this._contents.removeElement(fig);
        fig.endTrans();
        fig.setLayer(null);
    }

    public Enumeration elements() {
        return this._contents.elements();
    }

    public Vector getContents() {
        return this._contents;
    }

    public Fig hit(Rectangle rectangle) {
        int n = this._contents.size() - 1;
        while (n >= 0) {
            Fig fig = (Fig)this._contents.elementAt(n);
            if (fig.hit(rectangle)) {
                return fig;
            }
            --n;
        }
        return null;
    }

    public void removeAll() {
        int n = this._contents.size() - 1;
        while (n >= 0) {
            Fig fig = (Fig)this._contents.elementAt(n);
            fig.setLayer(null);
            --n;
        }
        this._contents.removeAllElements();
    }

    public FigNode getPortFig(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            FigNode figNode;
            Fig fig;
            Fig fig2 = (Fig)enumeration.nextElement();
            if (!(fig2 instanceof FigNode) || (fig = (figNode = (FigNode)fig2).getPortFig(object)) == null) continue;
            return figNode;
        }
        return null;
    }

    public Fig presentationFor(Object object) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() != object) continue;
            return fig;
        }
        return null;
    }

    public int presentationCountFor(Object object) {
        int n = 0;
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (fig.getOwner() != object) continue;
            ++n;
        }
        return n;
    }

    public void paintContents(Graphics graphics) {
        this.paintContents(graphics, null);
    }

    public void paintContents(Graphics graphics, FigPainter figPainter) {
        Rectangle rectangle = graphics.getClipBounds();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Fig fig = (Fig)enumeration.nextElement();
            if (rectangle != null && !fig.getBounds().intersects(rectangle)) continue;
            if (figPainter == null) {
                fig.paint(graphics);
                continue;
            }
            figPainter.paint(graphics, fig);
        }
    }

    public void sendToBack(Fig fig) {
        this._contents.removeElement(fig);
        this._contents.insertElementAt(fig, 0);
    }

    public void bringToFront(Fig fig) {
        this._contents.removeElement(fig);
        this._contents.addElement(fig);
    }

    public void sendBackward(Fig fig) {
        int n = this._contents.indexOf(fig);
        if (n == -1 || n == 0) {
            return;
        }
        Object e = this._contents.elementAt(n - 1);
        this._contents.setElementAt(e, n);
        this._contents.setElementAt(fig, n - 1);
    }

    public void bringForward(Fig fig) {
        int n = this._contents.indexOf(fig);
        if (n == -1 || n == this._contents.size() - 1) {
            return;
        }
        Object e = this._contents.elementAt(n + 1);
        this._contents.setElementAt(e, n);
        this._contents.setElementAt(fig, n + 1);
    }

    public void bringInFrontOf(Fig fig, Fig fig2) {
        int n = this._contents.indexOf(fig);
        int n2 = this._contents.indexOf(fig2);
        if (n == -1) {
            return;
        }
        if (n2 == -1) {
            return;
        }
        if (n >= n2) {
            return;
        }
        this._contents.removeElement(fig);
        this._contents.insertElementAt(fig, n2);
    }

    public void reorder(Fig fig, int n) {
        switch (n) {
            case 1: {
                this.sendToBack(fig);
                break;
            }
            case 2: {
                this.bringToFront(fig);
                break;
            }
            case 3: {
                this.sendBackward(fig);
                break;
            }
            case 4: {
                this.bringForward(fig);
                break;
            }
        }
    }

    public void preSave() {
        int n = 0;
        while (n < this._contents.size()) {
            ((Fig)this._contents.elementAt(n)).preSave();
            ++n;
        }
    }

    public void postSave() {
        int n = 0;
        while (n < this._contents.size()) {
            ((Fig)this._contents.elementAt(n)).postSave();
            ++n;
        }
    }

    public void postLoad() {
        int n = 0;
        while (n < this._contents.size()) {
            ((Fig)this._contents.elementAt(n)).postLoad();
            ++n;
        }
    }

    public LayerDiagram() {
        this("Layer" + LayerDiagram.numberWordFor(_nextLayerNumbered++));
    }

    public LayerDiagram(String string) {
        super(string);
        this._onMenu = true;
    }
}

