/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigPainter;
import org.tigris.gef.util.EnumerationEmpty;
import org.tigris.gef.util.EnumerationPredicate;
import org.tigris.gef.util.PredFigInRect;
import org.tigris.gef.util.PredFigNodeInRect;

public abstract class Layer
implements Serializable {
    private String _name = "aLayer";
    private String _type = "aLayer";
    private boolean _hidden = false;
    private boolean _grayed = false;
    private boolean _locked = false;
    protected boolean _onMenu = false;
    public transient Vector _editors = new Vector();

    public String toString() {
        return super.toString() + "[" + this._name + "]";
    }

    public Layer findLayerNamed(String string) {
        return string.equals(this._name) ? this : null;
    }

    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setHidden(boolean bl) {
        this._hidden = bl;
    }

    public boolean getHidden() {
        return this._hidden;
    }

    public void setGrayed(boolean bl) {
        this._grayed = bl;
    }

    public boolean getGrayed() {
        return this._grayed;
    }

    public void setLocked(boolean bl) {
        this._locked = bl;
    }

    public boolean getLocked() {
        return this._locked;
    }

    public void setOnMenu(boolean bl) {
        this._onMenu = bl;
    }

    public boolean getOnMenu() {
        return this._onMenu;
    }

    public abstract Vector getContents();

    public Vector getContentsNoEdges() {
        Vector vector = this.getContents();
        int n = vector.size();
        Vector vector2 = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (!(e instanceof FigEdge)) {
                vector2.addElement(e);
            }
            ++n2;
        }
        return vector2;
    }

    public Vector getContentsEdgesOnly() {
        Vector vector = this.getContents();
        int n = vector.size();
        Vector vector2 = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e instanceof FigEdge) {
                vector2.addElement(e);
            }
            ++n2;
        }
        return vector2;
    }

    public Vector getEditors() {
        return this._editors;
    }

    public void add(Fig fig) {
    }

    public void remove(Fig fig) {
    }

    public void removeAll() {
    }

    public Enumeration elements() {
        return EnumerationEmpty.theInstance();
    }

    public Fig hit(Rectangle rectangle) {
        return null;
    }

    public Enumeration elementsIn(Rectangle rectangle) {
        return new EnumerationPredicate(this.elements(), new PredFigInRect(rectangle));
    }

    public Enumeration nodesIn(Rectangle rectangle) {
        return new EnumerationPredicate(this.elements(), new PredFigNodeInRect(rectangle));
    }

    public abstract Fig presentationFor(Object var1);

    public String getPerspectiveType() {
        return this._type;
    }

    public void setPerspectiveType(String string) {
        this._type = string;
    }

    public void sendToBack(Fig fig) {
    }

    public void bringForward(Fig fig) {
    }

    public void sendBackward(Fig fig) {
    }

    public void bringToFront(Fig fig) {
    }

    public void bringInFrontOf(Fig fig, Fig fig2) {
    }

    public void reorder(Fig fig, int n) {
    }

    public void print(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, FigPainter figPainter) {
        if (this._hidden) {
            return;
        }
        if (!this._grayed) {
            this.paintContents(graphics, figPainter);
        } else {
            this.paintGrayContents(graphics);
        }
    }

    public void paintContents(Graphics graphics, FigPainter figPainter) {
        this.paintContents(graphics);
    }

    public abstract void paintContents(Graphics var1);

    public void paintGrayContents(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        this.paintContents(graphics);
    }

    public void damaged(Fig fig) {
        if (this._editors == null) {
            return;
        }
        Enumeration enumeration = this._editors.elements();
        while (enumeration.hasMoreElements()) {
            ((Editor)enumeration.nextElement()).damaged(fig);
        }
    }

    public void deleted(Fig fig) {
        if (this._editors == null) {
            return;
        }
        Enumeration enumeration = this._editors.elements();
        while (enumeration.hasMoreElements()) {
            ((Editor)enumeration.nextElement()).removed(fig);
        }
    }

    public void refreshEditors() {
        if (this._editors == null) {
            return;
        }
        Enumeration enumeration = this._editors.elements();
        while (enumeration.hasMoreElements()) {
            ((Editor)enumeration.nextElement()).damageAll();
        }
    }

    public void addEditor(Editor editor) {
        if (this._editors == null) {
            this._editors = new Vector();
        }
        this._editors.addElement(editor);
    }

    public void removeEditor(Editor editor) {
        if (this._editors == null) {
            return;
        }
        this._editors.removeElement(editor);
    }

    public void preSave() {
    }

    public void postSave() {
    }

    public void postLoad() {
    }

    public void adjust() {
    }

    public Layer() {
    }

    public Layer(String string) {
        this._name = string;
    }

    public Layer(String string, String string2) {
        this._name = string;
        this._type = string2;
    }
}

