/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.Prefs;
import org.tigris.gef.ui.IStatusBar;

public class Globals {
    public static final String REMOVE = "remove";
    protected static AppletContext _appletContext;
    protected static Applet _applet;
    protected static MediaTracker _tracker;
    public static String defaultStatus;
    public static Vector clipBoard;
    public static String LastDirectory;
    public static boolean ShowFigTips;
    public static IStatusBar _StatusBar;
    protected static Prefs _prefs;
    protected static boolean _sticky;
    protected static Mode _mode;
    protected static Editor _curEditor;
    protected static Hashtable _pcListeners;
    public static int MAX_LISTENERS;

    public static void setApplet(Applet applet) {
        _applet = applet;
        _appletContext = applet.getAppletContext();
        Globals.clearStatus();
        _tracker = new MediaTracker(applet);
    }

    public static AppletContext getAppletContext() {
        return _appletContext;
    }

    public static Applet getApplet() {
        return _applet;
    }

    public static String getLastDirectory() {
        return LastDirectory;
    }

    public static void setLastDirectory(String string) {
        LastDirectory = string;
    }

    public static boolean getShowFigTips() {
        return ShowFigTips;
    }

    public static void setShowFigTips(boolean bl) {
        ShowFigTips = bl;
    }

    public static void setStatusBar(IStatusBar iStatusBar) {
        _StatusBar = iStatusBar;
    }

    public static void showStatus(String string) {
        if (_StatusBar != null) {
            _StatusBar.showStatus(string);
        } else if (_appletContext != null) {
            _appletContext.showStatus(string);
        }
    }

    public static void clearStatus() {
        Globals.showStatus(defaultStatus);
    }

    public static void showDocument(URL uRL) {
        if (_appletContext != null) {
            _appletContext.showDocument(uRL);
        }
    }

    public static void showDocument(URL uRL, String string) {
        if (_appletContext != null) {
            _appletContext.showDocument(uRL, string);
        }
    }

    public static void showDocument(String string) {
        try {
            Globals.showDocument(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static Image getImage(URL uRL) {
        Image image = null;
        if (_appletContext != null) {
            image = _appletContext.getImage(uRL);
        }
        if (_tracker != null && image != null) {
            _tracker.addImage(image, 1);
        }
        return image;
    }

    public static Image getImage(String string) {
        try {
            Image image = null;
            if (_appletContext != null) {
                image = _appletContext.getImage(new URL(string));
            }
            if (_tracker != null && image != null) {
                _tracker.addImage(image, 1);
            }
            return image;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static void waitForImages() {
        if (_tracker == null) {
            return;
        }
        try {
            _tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void quit() {
        Globals.showStatus("Quiting");
        if (_appletContext != null) {
            _applet.destroy();
        }
        System.exit(0);
    }

    public static Prefs getPrefs() {
        return _prefs;
    }

    public static void startPropertySheet() {
    }

    public static Frame someFrame() {
        Editor editor = Globals.curEditor();
        if (editor == null) {
            return null;
        }
        Component component = editor.getAwtComponent();
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public static void setSticky(boolean bl) {
        _sticky = bl;
    }

    public static boolean getSticky() {
        return _sticky;
    }

    protected static Mode defaultMode() {
        return new ModeSelect();
    }

    public static void mode(Mode mode) {
        _mode = mode;
    }

    public static void mode(Mode mode, boolean bl) {
        _mode = mode;
        _sticky = bl;
    }

    public static Mode mode() {
        if (_mode == null) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static Mode nextMode() {
        if (!_sticky) {
            _mode = Globals.defaultMode();
        }
        return _mode;
    }

    public static void curEditor(Editor editor) {
        _curEditor = editor;
    }

    public static Editor curEditor() {
        return _curEditor;
    }

    public static void addPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        if (propertyChangeListenerArray == null) {
            propertyChangeListenerArray = new PropertyChangeListener[MAX_LISTENERS];
            _pcListeners.put(object, propertyChangeListenerArray);
        }
        if (_pcListeners.size() > 100) {
            System.out.println("_pcListeners size = " + _pcListeners.size());
        }
        int n = 0;
        while (n < MAX_LISTENERS) {
            if (propertyChangeListenerArray[n] == null) {
                propertyChangeListenerArray[n] = propertyChangeListener;
                return;
            }
            ++n;
        }
        System.out.println("ran out of listeners!");
    }

    public static void removePropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        boolean bl = false;
        if (propertyChangeListenerArray == null) {
            return;
        }
        int n = 0;
        while (n < MAX_LISTENERS) {
            if (propertyChangeListenerArray[n] == propertyChangeListener) {
                propertyChangeListenerArray[n] = null;
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            System.out.println("listener not found!");
        }
        n = 0;
        while (n < MAX_LISTENERS) {
            if (propertyChangeListenerArray[n] != null) {
                return;
            }
            ++n;
        }
        _pcListeners.remove(object);
    }

    public static void firePropChange(Object object, String string, boolean bl, boolean bl2) {
        Globals.firePropChange(object, string, new Boolean(bl), new Boolean(bl2));
    }

    public static void firePropChange(Object object, String string, int n, int n2) {
        Globals.firePropChange(object, string, new Integer(n), new Integer(n2));
    }

    public static void firePropChange(Object object, String string, Object object2, Object object3) {
        if (object2 != null && object2.equals(object3)) {
            return;
        }
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])_pcListeners.get(object);
        if (propertyChangeListenerArray == null) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(object, string, object2, object3);
        int n = 0;
        while (n < MAX_LISTENERS) {
            if (propertyChangeListenerArray[n] != null) {
                propertyChangeListenerArray[n].propertyChange(propertyChangeEvent);
            }
            ++n;
        }
    }

    static {
        defaultStatus = "  ";
        LastDirectory = ".";
        ShowFigTips = true;
        _StatusBar = null;
        _prefs = new Prefs();
        _sticky = false;
        _pcListeners = new Hashtable();
        MAX_LISTENERS = 4;
    }
}

