/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.JComponent;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Guide;
import org.tigris.gef.base.GuideGrid;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.base.LayerGrid;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.LayerPageBreaks;
import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.base.Mode;
import org.tigris.gef.base.ModeDragScroll;
import org.tigris.gef.base.ModeManager;
import org.tigris.gef.base.ModePopup;
import org.tigris.gef.base.ModeSelect;
import org.tigris.gef.base.Selection;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigTextEditor;

public class Editor
implements Serializable,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final int GRIP_SIZE = 8;
    protected static Rectangle _hitRect = new Rectangle(0, 0, 8, 8);
    protected ModeManager _modeManager = new ModeManager(this);
    protected Object _document;
    protected SelectionManager _selectionManager = new SelectionManager(this);
    protected LayerManager _layerManager = new LayerManager(this);
    protected Guide _guide = new GuideGrid(8);
    protected Fig _curFig = null;
    protected Selection _curSel = null;
    private transient Component _awt_component;
    private transient Component _peer_component = null;
    protected transient FigTextEditor _activeTextEditor = null;

    protected void defineLayers(GraphModel graphModel, Layer layer) {
        this._layerManager.addLayer(new LayerGrid());
        this._layerManager.addLayer(new LayerPageBreaks());
        if (layer != null) {
            this._layerManager.addLayer(layer);
        } else if (graphModel == null) {
            this._layerManager.addLayer(new LayerDiagram("Example"));
        } else {
            this._layerManager.addLayer(new LayerPerspective("untitled", graphModel));
        }
    }

    public void preSave() {
        this._layerManager.preSave();
    }

    public void postSave() {
        this._layerManager.postSave();
    }

    public void postLoad() {
        this._layerManager.postLoad();
    }

    public boolean getGridHidden() {
        boolean bl = false;
        Layer layer = this._layerManager.findLayerNamed("Grid");
        if (layer != null) {
            bl = layer.getHidden();
        }
        return bl;
    }

    public void setGridHidden(boolean bl) {
        Layer layer = this._layerManager.findLayerNamed("Grid");
        if (layer != null) {
            layer.setHidden(bl);
        }
    }

    public Object clone() {
        try {
            Editor editor = (Editor)this.getClass().newInstance();
            editor.getLayerManager().addLayer(this._layerManager.getActiveLayer());
            editor.document(this.document());
            return editor;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.out.println("IllegalAccessException in spawn");
        }
        catch (InstantiationException instantiationException) {
            System.out.println("InstantiationException in spawn");
        }
        return null;
    }

    public ModeManager getModeManager() {
        return this._modeManager;
    }

    public void mode(Mode mode) {
        this._modeManager.push(mode);
        mode.setEditor(this);
        Globals.showStatus(mode.instructions());
    }

    public void finishMode() {
        this._modeManager.pop();
        this.mode(Globals.mode());
        Globals.clearStatus();
    }

    public LayerManager getLayerManager() {
        return this._layerManager;
    }

    public GraphModel getGraphModel() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphModel();
        }
        return null;
    }

    public void setGraphModel(GraphModel graphModel) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphModel(graphModel);
        }
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphNodeRenderer();
        }
        return null;
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphNodeRenderer(graphNodeRenderer);
        }
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            return ((LayerPerspective)layer).getGraphEdgeRenderer();
        }
        return null;
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        Layer layer = this._layerManager.getActiveLayer();
        if (layer instanceof LayerPerspective) {
            ((LayerPerspective)layer).setGraphEdgeRenderer(graphEdgeRenderer);
        }
    }

    public Enumeration figs() {
        return this._layerManager.elements();
    }

    public void add(Fig fig) {
        this.getLayerManager().add(fig);
    }

    public void remove(Fig fig) {
        this.getLayerManager().remove(fig);
    }

    public final Fig hit(Point point) {
        _hitRect.setLocation(point.x - 4, point.y - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int n, int n2) {
        _hitRect.setLocation(n - 4, n2 - 4);
        return this.hit(_hitRect);
    }

    public final Fig hit(int n, int n2, int n3, int n4) {
        return this.hit(new Rectangle(n, n2, n3, n4));
    }

    public Fig hit(Rectangle rectangle) {
        return this.getLayerManager().hit(rectangle);
    }

    protected void setUnderMouse(MouseEvent mouseEvent) {
        int n;
        Object var2_2 = null;
        int n2 = mouseEvent.getX();
        Fig fig = this.hit(n2, n = mouseEvent.getY());
        if (fig != this._curFig) {
            if (this._curFig instanceof MouseListener) {
                ((MouseListener)((Object)this._curFig)).mouseExited(mouseEvent);
            }
            if (fig instanceof MouseListener) {
                ((MouseListener)((Object)fig)).mouseEntered(mouseEvent);
            }
        }
        this._curFig = fig;
        Selection selection = this._selectionManager.findSelectionAt(n2, n);
        if (selection != this._curSel) {
            if (this._curSel != null) {
                this._curSel.mouseExited(mouseEvent);
            }
            if (selection != null) {
                selection.mouseEntered(mouseEvent);
            }
        }
        this._curSel = selection;
    }

    public Object document() {
        return this._document;
    }

    public void document(Object object) {
        this._document = object;
    }

    public void snap(Point point) {
        if (this._guide != null) {
            this._guide.snap(point);
        }
    }

    public Guide getGuide() {
        return this._guide;
    }

    public void setGuide(Guide guide) {
        this._guide = guide;
    }

    public void damaged(Rectangle rectangle) {
        ((JComponent)this.getAwtComponent()).repaint(1000L, rectangle.x - 32, rectangle.y - 32, rectangle.width + 64, rectangle.height + 64);
    }

    public void damaged(Fig fig) {
        ((JComponent)this.getAwtComponent()).repaint(1000L, fig.getX() - 32, fig.getY() - 32, fig.getWidth() + 64, fig.getHeight() + 64);
    }

    public void damaged(Selection selection) {
        this.damaged(selection.getBounds());
    }

    public void damageAll() {
        Dimension dimension = this.getAwtComponent().getSize();
        ((JComponent)this.getAwtComponent()).repaint();
    }

    public void repairDamage() {
    }

    public synchronized void paint(Graphics graphics) {
        this.getLayerManager().paint(graphics);
        this._selectionManager.paint(graphics);
        this._modeManager.paint(graphics);
        if (this._activeTextEditor != null) {
            this._activeTextEditor.repaint();
        }
    }

    public synchronized void print(Graphics graphics) {
        this.getLayerManager().paint(graphics);
    }

    public void scrollToShow(int n, int n2) {
    }

    public SelectionManager getSelectionManager() {
        return this._selectionManager;
    }

    public Component getAwtComponent() {
        return this._awt_component;
    }

    public void setAwtComponent(Component component) {
        this._awt_component = component;
        this._peer_component = null;
    }

    public void setActiveTextEditor(FigTextEditor figTextEditor) {
        FigTextEditor figTextEditor2 = this._activeTextEditor;
        this._activeTextEditor = figTextEditor;
        if (figTextEditor2 != null) {
            figTextEditor2.endEditing();
        }
    }

    public void setCursor(Cursor cursor) {
        if (this.getAwtComponent() != null) {
            this.getAwtComponent().setCursor(cursor);
            Toolkit.getDefaultToolkit().sync();
        }
    }

    public Graphics getGraphics() {
        if (this._awt_component == null) {
            return null;
        }
        return this._awt_component.getGraphics();
    }

    public Frame findFrame() {
        Component component = this._awt_component;
        while (component != null && !(component instanceof Frame)) {
            component = component.getParent();
        }
        return (Frame)component;
    }

    public Image createImage(int n, int n2) {
        if (this._awt_component == null) {
            return null;
        }
        if (this._peer_component == null) {
            this._peer_component = this._awt_component;
            while (this._peer_component instanceof JComponent) {
                this._peer_component = this._peer_component.getParent();
            }
        }
        return this._peer_component.createImage(n, n2);
    }

    public Color getBackground() {
        if (this._awt_component == null) {
            return Color.lightGray;
        }
        return this._awt_component.getBackground();
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._selectionManager.addGraphSelectionListener(graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this._selectionManager.removeGraphSelectionListener(graphSelectionListener);
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this._modeManager.addModeChangeListener(modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this._modeManager.removeModeChangeListener(modeChangeListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseClicked(mouseEvent);
        }
        this._selectionManager.mouseClicked(mouseEvent);
        this._modeManager.mouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        this.setActiveTextEditor(null);
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mousePressed(mouseEvent);
        }
        this._selectionManager.mousePressed(mouseEvent);
        this._modeManager.mousePressed(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        Globals.curEditor(this);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseReleased(mouseEvent);
        }
        this._selectionManager.mouseReleased(mouseEvent);
        this._modeManager.mouseReleased(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this._activeTextEditor != null) {
            this._activeTextEditor.requestFocus();
        } else if (this._awt_component != null) {
            this._awt_component.requestFocus();
        }
        Globals.curEditor(this);
        this.mode(Globals.mode());
        this.setUnderMouse(mouseEvent);
        this._modeManager.mouseEntered(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setUnderMouse(mouseEvent);
        if (this._curFig instanceof MouseListener) {
            ((MouseListener)((Object)this._curFig)).mouseExited(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Globals.curEditor(this);
        this.setUnderMouse(mouseEvent);
        this._selectionManager.mouseDragged(mouseEvent);
        this._modeManager.mouseDragged(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Globals.curEditor(this);
        this.setUnderMouse(mouseEvent);
        if (this._curFig != null && Globals.getShowFigTips()) {
            String string = this._curFig.getTipString(mouseEvent);
            if (string != null && string.length() > 0 && !string.endsWith(" ")) {
                string = string + " ";
            }
            if (string != null && this._awt_component instanceof JComponent) {
                ((JComponent)this._awt_component).setToolTipText(string);
            }
        } else if (this._awt_component instanceof JComponent) {
            ((JComponent)this._awt_component).setToolTipText(null);
        }
        this._selectionManager.mouseMoved(mouseEvent);
        this._modeManager.mouseMoved(mouseEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        Globals.curEditor(this);
        this._selectionManager.keyTyped(keyEvent);
        this._modeManager.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        Globals.curEditor(this);
        this._selectionManager.keyPressed(keyEvent);
        this._modeManager.keyPressed(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void executeCmd(Cmd cmd, InputEvent inputEvent) {
        if (cmd == null) {
            return;
        }
        try {
            cmd.doIt();
        }
        catch (Throwable throwable) {
            System.out.println("While executing " + cmd + " on event " + inputEvent + " the following error occured:");
            throwable.printStackTrace();
        }
    }

    public void removed(Fig fig) {
        this._selectionManager.deselect(fig);
        this.remove(fig);
    }

    public Editor(GraphModel graphModel, Component component) {
        this(graphModel, component, null);
    }

    public Editor(GraphModel graphModel) {
        this(graphModel, null, null);
    }

    public Editor() {
        this(null, null, null);
    }

    public Editor(Diagram diagram) {
        this(diagram.getGraphModel(), null, diagram.getLayer());
    }

    public Editor(GraphModel graphModel, Component component, Layer layer) {
        this._awt_component = component;
        this.defineLayers(graphModel, layer);
        this.mode(new ModeSelect(this));
        this.mode(new ModePopup(this));
        this.mode(new ModeDragScroll(this));
        Globals.curEditor(this);
    }
}

