/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.LayerManager;
import org.tigris.gef.base.SelectionManager;

public class CmdReorder
extends Cmd {
    public static final int SEND_TO_BACK = 1;
    public static final int BRING_TO_FRONT = 2;
    public static final int SEND_BACKWARD = 3;
    public static final int BRING_FORWARD = 4;
    public static CmdReorder SendToBack = new CmdReorder(1);
    public static CmdReorder BringToFront = new CmdReorder(2);
    public static CmdReorder SendBackward = new CmdReorder(3);
    public static CmdReorder BringForward = new CmdReorder(4);
    private int function;

    protected static String wordFor(int n) {
        switch (n) {
            case 3: {
                return "Backward";
            }
            case 1: {
                return "To Back";
            }
            case 4: {
                return "Forward";
            }
            case 2: {
                return "To Front";
            }
        }
        return "";
    }

    public void doIt() {
        Editor editor = Globals.curEditor();
        LayerManager layerManager = editor.getLayerManager();
        SelectionManager selectionManager = editor.getSelectionManager();
        selectionManager.startTrans();
        selectionManager.reorder(this.function, layerManager.getActiveLayer());
        selectionManager.endTrans();
        editor.repairDamage();
    }

    public void undoIt() {
        System.out.println("Connot undo CmdReorder, yet");
    }

    public CmdReorder(int n) {
        super(CmdReorder.wordFor(n));
        this.function = n;
    }
}

