/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;
import org.tigris.gef.util.Util;
import org.tigris.gef.xml.pgml.PGMLParser;

public class CmdOpenPGML
extends Cmd
implements FilenameFilter {
    static final long serialVersionUID = 0L;

    public void doIt() {
        Editor editor = Globals.curEditor();
        FileDialog fileDialog = new FileDialog(editor.findFrame(), "Open...", 0);
        fileDialog.setFilenameFilter(this);
        fileDialog.setDirectory(Globals.getLastDirectory());
        fileDialog.show();
        String string = fileDialog.getFile();
        String string2 = fileDialog.getDirectory();
        Globals.setLastDirectory(string2);
        if (string != null) {
            try {
                Globals.showStatus("Reading " + string2 + string + "...");
                URL uRL = Util.fileToURL(new File(string2 + string));
                Diagram diagram = PGMLParser.SINGLETON.readDiagram(uRL);
                Editor editor2 = new Editor(diagram);
                Globals.showStatus("Read " + string2 + string);
                JGraphFrame jGraphFrame = new JGraphFrame(string2 + string, editor2);
                Object object = this.getArg("dimension");
                if (object instanceof Dimension) {
                    ((Component)jGraphFrame).setSize((Dimension)object);
                }
                jGraphFrame.setVisible(true);
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("bad URL");
            }
            catch (IOException iOException) {
                System.out.println("IOExcept in openpgml");
            }
        }
    }

    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }

    public CmdOpenPGML() {
        super("Open PGML...", false);
        this.setArg("filterPattern", "*.pgml");
    }
}

