/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.graph.presentation.JGraphFrame;

public class CmdOpen
extends Cmd
implements FilenameFilter {
    public void doIt() {
        try {
            Editor editor = Globals.curEditor();
            FileDialog fileDialog = new FileDialog(editor.findFrame(), "Open...", 0);
            fileDialog.setFilenameFilter(this);
            fileDialog.setDirectory(Globals.getLastDirectory());
            fileDialog.show();
            String string = fileDialog.getFile();
            String string2 = fileDialog.getDirectory();
            Globals.setLastDirectory(string2);
            if (string != null) {
                Globals.showStatus("Reading " + string2 + string + "...");
                FileInputStream fileInputStream = new FileInputStream(string2 + string);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                Editor editor2 = (Editor)objectInputStream.readObject();
                editor2.postLoad();
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                Globals.showStatus("Read " + string2 + string);
                JGraphFrame jGraphFrame = new JGraphFrame(string2 + string, editor2);
                Object object = this.getArg("dimension");
                if (object instanceof Dimension) {
                    ((Component)jGraphFrame).setSize((Dimension)object);
                }
                jGraphFrame.setVisible(true);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("got an FileNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("got an ClassNotFoundException");
        }
        catch (IOException iOException) {
            System.out.println("got an IOException");
        }
    }

    public boolean accept(File file, String string) {
        System.out.println("checking: " + file + " " + string);
        if (this.containsArg("filterPattern")) {
            return true;
        }
        return true;
    }

    public void undoIt() {
        System.out.println("Undo does not make sense for CmdOpen");
    }

    public CmdOpen() {
        super("Open...");
    }

    public CmdOpen(String string) {
        this();
        this.setArg("filterPattern", string);
    }
}

