/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdDistribute
extends Cmd {
    public static final int H_SPACING = 0;
    public static final int H_CENTERS = 1;
    public static final int H_PACK = 2;
    public static final int V_SPACING = 4;
    public static final int V_CENTERS = 5;
    public static final int V_PACK = 6;
    protected int _request;
    protected Rectangle _bbox = null;

    protected static String wordFor(int n) {
        switch (n) {
            case 0: {
                return "Horizontal Spacing";
            }
            case 1: {
                return "Horizontal Centers";
            }
            case 2: {
                return "Leftward";
            }
            case 4: {
                return "Vertical Spacing";
            }
            case 5: {
                return "Vertical Centers";
            }
            case 6: {
                return "Upward";
            }
        }
        return "";
    }

    public void doIt() {
        int n;
        Editor editor = Globals.curEditor();
        Vector vector = (Vector)this.getArg("figs");
        Integer n2 = (Integer)this.getArg("gap");
        int n3 = 8;
        if (n2 != null) {
            n3 = n2;
        }
        this._bbox = (Rectangle)this.getArg("bbox");
        if (vector == null) {
            SelectionManager selectionManager = editor.getSelectionManager();
            if (selectionManager.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            vector = selectionManager.getFigs();
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = vector.size();
        if (n8 == 0) {
            return;
        }
        Fig fig = (Fig)vector.elementAt(0);
        if (this._bbox == null) {
            this._bbox = fig.getBounds();
            n4 = this._bbox.x + this._bbox.width / 2;
            n5 = this._bbox.x + this._bbox.width / 2;
            n6 = this._bbox.y + this._bbox.height / 2;
            n7 = this._bbox.y + this._bbox.height / 2;
            n = 1;
            while (n < n8) {
                fig = (Fig)vector.elementAt(n);
                Rectangle rectangle = fig.getBounds();
                this._bbox.add(rectangle);
                n4 = Math.min(n4, rectangle.x + rectangle.width / 2);
                n5 = Math.max(n5, rectangle.x + rectangle.width / 2);
                n6 = Math.min(n6, rectangle.y + rectangle.height / 2);
                n7 = Math.max(n7, rectangle.y + rectangle.height / 2);
                ++n;
            }
        }
        n = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n8) {
            fig = (Fig)vector.elementAt(n10);
            n += fig.getWidth();
            n9 += fig.getHeight();
            ++n10;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this._request) {
            case 0: {
                f3 = this._bbox.x;
                f = (this._bbox.width - n) / Math.max(n8 - 1, 1);
                break;
            }
            case 1: {
                f3 = n4;
                f2 = (n5 - n4) / Math.max(n8 - 1, 1);
                break;
            }
            case 2: {
                f3 = this._bbox.x;
                f = n3;
                break;
            }
            case 4: {
                f4 = this._bbox.y;
                f = (this._bbox.height - n9) / Math.max(n8 - 1, 1);
                break;
            }
            case 5: {
                f4 = n6;
                f2 = (n7 - n6) / Math.max(n8 - 1, 1);
                break;
            }
            case 6: {
                f4 = this._bbox.y;
                f = n3;
                break;
            }
        }
        int n11 = 0;
        while (n11 < n8) {
            int n12 = n11 + 1;
            while (n12 < n8) {
                Fig fig2 = (Fig)vector.elementAt(n11);
                Fig fig3 = (Fig)vector.elementAt(n12);
                if (this._request == 0 || this._request == 1 || this._request == 2) {
                    if (fig2.getX() > fig3.getX()) {
                        this.swap(vector, n11, n12);
                    }
                } else if (fig2.getY() > fig3.getY()) {
                    this.swap(vector, n11, n12);
                }
                ++n12;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < n8) {
            fig = (Fig)vector.elementAt(n11);
            fig.startTrans();
            switch (this._request) {
                case 0: 
                case 2: {
                    fig.setLocation((int)f3, fig.getY());
                    f3 += (float)fig.getWidth() + f;
                    break;
                }
                case 1: {
                    fig.setLocation((int)f3 - fig.getWidth() / 2, fig.getY());
                    f3 += f2;
                    break;
                }
                case 4: 
                case 6: {
                    fig.setLocation(fig.getX(), (int)f4);
                    f4 += (float)fig.getHeight() + f;
                    break;
                }
                case 5: {
                    fig.setLocation(fig.getX(), (int)f4 - fig.getHeight() / 2);
                    f4 += f2;
                    break;
                }
            }
            fig.endTrans();
            ++n11;
        }
    }

    public void undoIt() {
    }

    protected void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    public Rectangle getLastBBox() {
        return this._bbox;
    }

    public CmdDistribute(int n) {
        super("Distribute " + CmdDistribute.wordFor(n));
        this._request = n;
    }
}

