/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.tigris.gef.util.Util;

public abstract class Cmd
extends AbstractAction
implements Serializable {
    public static final boolean HAS_ICON = true;
    public static final boolean NO_ICON = false;
    private static Vector _registeredCmds = new Vector();
    protected Hashtable _args;

    public void updateEnabled() {
        this.setEnabled(this.shouldBeEnabled());
    }

    public boolean shouldBeEnabled() {
        return true;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setName(String string) {
        this.putValue("Name", string);
    }

    protected Object getArg(String string) {
        if (this._args == null) {
            return null;
        }
        return this._args.get(string);
    }

    protected Object getArg(String string, Object object) {
        if (this._args == null) {
            return object;
        }
        Object v = this._args.get(string);
        if (v == null) {
            return object;
        }
        return v;
    }

    protected void setArg(String string, Object object) {
        if (this._args == null) {
            this._args = new Hashtable();
        }
        this._args.put(string, object);
    }

    protected boolean containsArg(String string) {
        return this._args != null && this._args.containsKey(string);
    }

    public String about() {
        return "http://www.ics.uci.edu/~jrobbins/gef/Docs.html#" + this.getClass().getName();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.doIt();
    }

    public abstract void doIt();

    public abstract void undoIt();

    public static Enumeration registeredCmds() {
        return _registeredCmds.elements();
    }

    public static void register(Cmd cmd) {
        _registeredCmds.addElement(cmd);
    }

    public static Cmd cmdAtIndex(int n) {
        return (Cmd)_registeredCmds.elementAt(n);
    }

    public Cmd(Hashtable hashtable, String string) {
        super(string);
        ImageIcon imageIcon = Util.loadIconResource(string, string);
        if (imageIcon != null) {
            this.putValue("SmallIcon", imageIcon);
        }
        this._args = hashtable;
    }

    public Cmd(Hashtable hashtable, String string, boolean bl) {
        super(string);
        ImageIcon imageIcon;
        if (bl && (imageIcon = Util.loadIconResource(string, string)) != null) {
            this.putValue("SmallIcon", imageIcon);
        }
        this._args = hashtable;
    }

    public Cmd(String string, boolean bl) {
        this(null, string, bl);
    }

    public Cmd(Hashtable hashtable, String string, ImageIcon imageIcon) {
        super(string, imageIcon);
        this._args = hashtable;
    }

    public Cmd(String string) {
        this(null, string);
    }
}

